/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp;

import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import grails.io.IOUtils;
import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsPluginManager;
import grails.util.CacheEntry;
import groovy.lang.GroovySystem;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.encoder.Encoder;
import org.grails.gsp.GroovyPagesException;
import org.grails.gsp.jsp.TagLibraryResolver;
import org.grails.taglib.TagLibraryLookup;
import org.grails.taglib.encoder.WithCodecHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;

public class GroovyPageMetaInfo
implements GrailsApplicationAware {
    private static final Log LOG = LogFactory.getLog(GroovyPageMetaInfo.class);
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private boolean precompiledMode = false;
    private Class<?> pageClass;
    private long lastModified;
    private InputStream groovySource;
    private String contentType;
    private int[] lineNumbers;
    private String[] htmlParts;
    private Map jspTags = Collections.emptyMap();
    private GroovyPagesException compilationException;
    private Encoder expressionEncoder;
    private Encoder staticEncoder;
    private Encoder outEncoder;
    private Encoder taglibEncoder;
    private String expressionCodecName;
    private String staticCodecName;
    private String outCodecName;
    private String taglibCodecName;
    public static final String HTML_DATA_POSTFIX = "_html.data";
    public static final String LINENUMBERS_DATA_POSTFIX = "_linenumbers.data";
    public static final long LASTMODIFIED_CHECK_INTERVAL = Long.getLong("grails.gsp.reload.interval", 5000L);
    private static final long LASTMODIFIED_CHECK_GRANULARITY = Long.getLong("grails.gsp.reload.granularity", 2000L);
    private GrailsApplication grailsApplication;
    private String pluginPath;
    private GrailsPlugin pagePlugin;
    private boolean initialized = false;
    private CacheEntry<Resource> shouldReloadCacheEntry = new CacheEntry();
    public static String DEFAULT_PLUGIN_PATH = "";
    volatile boolean metaClassShouldBeRemoved = false;

    public GroovyPageMetaInfo() {
    }

    public GroovyPageMetaInfo(Class<?> pageClass) {
        this();
        this.precompiledMode = true;
        this.pageClass = pageClass;
        this.contentType = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"CONTENT_TYPE"), null);
        this.jspTags = (Map)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"JSP_TAGS"), null);
        this.lastModified = (Long)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"LAST_MODIFIED"), null);
        this.expressionCodecName = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"EXPRESSION_CODEC"), null);
        this.staticCodecName = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"STATIC_CODEC"), null);
        this.outCodecName = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"OUT_CODEC"), null);
        this.taglibCodecName = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField(pageClass, (String)"TAGLIB_CODEC"), null);
        try {
            this.readHtmlData();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading html data for page class " + pageClass, e);
        }
    }

    synchronized void initializeOnDemand(GroovyPageMetaInfoInitializer initializer) {
        if (!this.initialized) {
            initializer.initialize(this);
        }
    }

    public void initialize() {
        this.expressionEncoder = this.getCodec(this.expressionCodecName);
        this.staticEncoder = this.getCodec(this.staticCodecName);
        this.outEncoder = this.getCodec(this.outCodecName);
        this.taglibEncoder = this.getCodec(this.taglibCodecName);
        this.initializePluginPath();
        this.initialized = true;
    }

    private Encoder getCodec(String codecName) {
        return WithCodecHelper.lookupEncoder((GrailsApplication)this.grailsApplication, (String)codecName);
    }

    private void initializePluginPath() {
        if (this.grailsApplication == null || this.pageClass == null) {
            return;
        }
        ApplicationContext applicationContext = this.grailsApplication.getMainContext();
        if (applicationContext == null || !applicationContext.containsBean("pluginManager")) {
            return;
        }
        GrailsPluginManager pluginManager = (GrailsPluginManager)applicationContext.getBean("pluginManager", GrailsPluginManager.class);
        this.pluginPath = pluginManager.getPluginPathForClass(this.pageClass);
        if (this.pluginPath == null) {
            this.pluginPath = DEFAULT_PLUGIN_PATH;
        }
        this.pagePlugin = pluginManager.getPluginForClass(this.pageClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHtmlData() throws IOException {
        String dataResourceName = this.resolveDataResourceName(HTML_DATA_POSTFIX);
        DataInputStream input = null;
        try {
            InputStream resourceStream = this.pageClass.getResourceAsStream(dataResourceName);
            if (resourceStream != null) {
                input = new DataInputStream(resourceStream);
                int arrayLen = input.readInt();
                this.htmlParts = new String[arrayLen];
                for (int i = 0; i < arrayLen; ++i) {
                    this.htmlParts[i] = input.readUTF();
                }
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLineNumbers() throws IOException {
        String dataResourceName = this.resolveDataResourceName(LINENUMBERS_DATA_POSTFIX);
        DataInputStream input = null;
        try {
            input = new DataInputStream(this.pageClass.getResourceAsStream(dataResourceName));
            int arrayLen = input.readInt();
            this.lineNumbers = new int[arrayLen];
            for (int i = 0; i < arrayLen; ++i) {
                this.lineNumbers[i] = input.readInt();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)input);
    }

    private String resolveDataResourceName(String postfix) {
        String dataResourceName = this.pageClass.getName();
        int pos = dataResourceName.lastIndexOf(46);
        if (pos > -1) {
            dataResourceName = dataResourceName.substring(pos + 1);
        }
        dataResourceName = dataResourceName + postfix;
        return dataResourceName;
    }

    public TagLibraryLookup getTagLibraryLookup() {
        return this.tagLibraryLookup;
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public TagLibraryResolver getJspTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public Class<?> getPageClass() {
        return this.pageClass;
    }

    public void setPageClass(Class<?> pageClass) {
        this.pageClass = pageClass;
        this.initializePluginPath();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public InputStream getGroovySource() {
        return this.groovySource;
    }

    public void setGroovySource(InputStream groovySource) {
        this.groovySource = groovySource;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int[] getLineNumbers() {
        if (this.precompiledMode) {
            return this.getPrecompiledLineNumbers();
        }
        return this.lineNumbers;
    }

    private synchronized int[] getPrecompiledLineNumbers() {
        if (this.lineNumbers == null) {
            try {
                this.readLineNumbers();
            }
            catch (IOException e) {
                LOG.warn((Object)"Problem reading precompiled linenumbers", (Throwable)e);
            }
        }
        return this.lineNumbers;
    }

    public void setLineNumbers(int[] lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags != null ? jspTags : Collections.emptyMap();
    }

    public Map getJspTags() {
        return this.jspTags;
    }

    public void setCompilationException(GroovyPagesException e) {
        this.compilationException = e;
    }

    public GroovyPagesException getCompilationException() {
        return this.compilationException;
    }

    public String[] getHtmlParts() {
        return this.htmlParts;
    }

    public void setHtmlParts(String[] htmlParts) {
        this.htmlParts = htmlParts;
    }

    public void applyLastModifiedFromResource(Resource resource) {
        this.lastModified = this.establishLastModified(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long establishLastModified(Resource resource) {
        long last;
        if (resource == null) {
            return -1L;
        }
        if (resource instanceof FileSystemResource) {
            return ((FileSystemResource)resource).getFile().lastModified();
        }
        URLConnection urlc = null;
        try {
            File file;
            URL url = resource.getURL();
            if ("file".equals(url.getProtocol()) && (file = new File(url.getFile())).exists()) {
                long l = file.lastModified();
                return l;
            }
            urlc = url.openConnection();
            urlc.setDoInput(false);
            urlc.setDoOutput(false);
            last = urlc.getLastModified();
        }
        catch (FileNotFoundException fnfe) {
            last = -1L;
        }
        catch (IOException e) {
            last = -1L;
        }
        finally {
            if (urlc != null) {
                try {
                    InputStream is = urlc.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return last;
    }

    public boolean shouldReload(PrivilegedAction<Resource> resourceCallable) {
        if (resourceCallable == null) {
            return false;
        }
        Resource resource = this.checkIfReloadableResourceHasChanged(resourceCallable);
        return resource != null;
    }

    public Resource checkIfReloadableResourceHasChanged(final PrivilegedAction<Resource> resourceCallable) {
        Callable<Resource> checkerCallable = new Callable<Resource>(){

            @Override
            public Resource call() {
                long currentLastmodified;
                Resource resource = (Resource)resourceCallable.run();
                if (resource != null && resource.exists() && (currentLastmodified = GroovyPageMetaInfo.this.establishLastModified(resource)) > 0L && Math.abs(currentLastmodified - GroovyPageMetaInfo.this.lastModified) > LASTMODIFIED_CHECK_GRANULARITY) {
                    return resource;
                }
                return null;
            }
        };
        return (Resource)this.shouldReloadCacheEntry.getValue(LASTMODIFIED_CHECK_INTERVAL, (Callable)checkerCallable, true, null);
    }

    public boolean isPrecompiledMode() {
        return this.precompiledMode;
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public String getPluginPath() {
        return this.pluginPath;
    }

    public GrailsPlugin getPagePlugin() {
        return this.pagePlugin;
    }

    public Encoder getOutEncoder() {
        return this.outEncoder;
    }

    public Encoder getStaticEncoder() {
        return this.staticEncoder;
    }

    public Encoder getExpressionEncoder() {
        return this.expressionEncoder;
    }

    public Encoder getTaglibEncoder() {
        return this.taglibEncoder;
    }

    public void setExpressionCodecName(String expressionCodecName) {
        this.expressionCodecName = expressionCodecName;
    }

    public void setStaticCodecName(String staticCodecName) {
        this.staticCodecName = staticCodecName;
    }

    public void setOutCodecName(String pageCodecName) {
        this.outCodecName = pageCodecName;
    }

    public void setTaglibCodecName(String taglibCodecName) {
        this.taglibCodecName = taglibCodecName;
    }

    public void removePageMetaClass() {
        this.metaClassShouldBeRemoved = true;
        if (this.pageClass != null) {
            GroovySystem.getMetaClassRegistry().removeMetaClass(this.pageClass);
        }
    }

    public void writeToFinished(Writer out) {
        if (this.metaClassShouldBeRemoved) {
            this.removePageMetaClass();
        }
    }

    static interface GroovyPageMetaInfoInitializer {
        public void initialize(GroovyPageMetaInfo var1);
    }
}

