/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ByteArrayAccess;
import com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.nio.ByteBuffer;

public abstract class TypedArray
extends ScriptArray {
    private final boolean offset;
    private final int bytesPerElement;
    private final String name;
    private final TypedArrayFactory factory;
    static final int INT8_BYTES_PER_ELEMENT = 1;
    static final int UINT8_BYTES_PER_ELEMENT = 1;
    static final int INT16_BYTES_PER_ELEMENT = 2;
    static final int UINT16_BYTES_PER_ELEMENT = 2;
    static final int INT32_BYTES_PER_ELEMENT = 4;
    static final int UINT32_BYTES_PER_ELEMENT = 4;
    static final int BIGINT64_BYTES_PER_ELEMENT = 8;
    static final int BIGUINT64_BYTES_PER_ELEMENT = 8;
    static final int FLOAT32_BYTES_PER_ELEMENT = 4;
    static final int FLOAT64_BYTES_PER_ELEMENT = 8;

    protected TypedArray(TypedArrayFactory factory, boolean offset) {
        this.offset = offset;
        this.bytesPerElement = factory.getBytesPerElement();
        this.name = factory.getName();
        this.factory = factory;
    }

    @Override
    public final long length(DynamicObject object) {
        return this.lengthInt(object);
    }

    @Override
    public final int lengthInt(DynamicObject object) {
        return JSArrayBufferView.typedArrayGetLength(object);
    }

    @Override
    public final TypedArray setLengthImpl(DynamicObject object, long len, ScriptArray.ProfileHolder profile) {
        return this;
    }

    @Override
    public final long firstElementIndex(DynamicObject object) {
        return 0L;
    }

    @Override
    public final long lastElementIndex(DynamicObject object) {
        return this.length(object) - 1L;
    }

    @Override
    public final long nextElementIndex(DynamicObject object, long index) {
        return index + 1L;
    }

    @Override
    public final long previousElementIndex(DynamicObject object, long index) {
        return index - 1L;
    }

    @Override
    public final Object[] toArray(DynamicObject object) {
        int length = this.lengthInt(object);
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getElement(object, i);
        }
        return result;
    }

    @Override
    public final ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict) {
        return this;
    }

    @Override
    public final boolean hasElement(DynamicObject object, long index) {
        return 0L <= index && index < this.length(object);
    }

    protected static byte[] getByteArray(DynamicObject object) {
        return JSArrayBufferView.typedArrayGetByteArray(object);
    }

    protected static ByteBuffer getByteBuffer(DynamicObject object) {
        return JSArrayBufferView.typedArrayGetByteBuffer(object);
    }

    public final Object getBufferFromTypedArray(DynamicObject object) {
        return this.isDirect() ? TypedArray.getByteBuffer(object) : (Object)TypedArray.getByteArray(object);
    }

    protected final int getOffset(DynamicObject object) {
        if (this.offset) {
            return JSArrayBufferView.typedArrayGetOffset(object);
        }
        return 0;
    }

    public final TypedArrayFactory getFactory() {
        return this.factory;
    }

    public final int bytesPerElement() {
        return this.bytesPerElement;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isHolesType() {
        return false;
    }

    @Override
    public boolean hasHoles(DynamicObject object) {
        return false;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        throw Errors.unsupported("cannot removeRange() on TypedArray");
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long atOffset, int size) {
        throw Errors.unsupported("cannot addRange() on TypedArray");
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isFrozen() {
        return false;
    }

    @Override
    public boolean isLengthNotWritable() {
        return false;
    }

    @Override
    public ScriptArray seal() {
        return this;
    }

    @Override
    public ScriptArray freeze() {
        return this;
    }

    @Override
    public ScriptArray setLengthNotWritable() {
        return this;
    }

    @Override
    public ScriptArray preventExtensions() {
        return this;
    }

    @Override
    public final boolean isStatelessType() {
        return true;
    }

    public boolean isDirect() {
        return false;
    }

    public final boolean hasOffset() {
        return this.offset;
    }

    public abstract Object getBufferElement(DynamicObject var1, int var2, boolean var3);

    public abstract void setBufferElement(DynamicObject var1, int var2, boolean var3, Object var4);

    public static TypedArrayFactory[] factories(JSContext context) {
        if (context.getContextOptions().isBigInt()) {
            return TypedArrayFactory.FACTORIES;
        }
        return TypedArrayFactory.getNoBigIntFactories();
    }

    public static final class DirectFloat64Array
    extends TypedFloatArray<ByteBuffer> {
        DirectFloat64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(ByteBuffer buffer, int offset, int index) {
            return ByteBufferAccess.nativeOrder().getDouble(buffer, offset + index * 8);
        }

        @Override
        public void setDoubleImpl(ByteBuffer buffer, int offset, int index, double value) {
            ByteBufferAccess.nativeOrder().putDouble(buffer, offset + index * 8, value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteBufferAccess.forOrder(littleEndian).getDouble(JSArrayBuffer.getDirectByteBuffer(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putDouble(JSArrayBuffer.getDirectByteBuffer(buffer), index, JSRuntime.doubleValue((Number)value));
        }
    }

    public static final class Float64Array
    extends TypedFloatArray<byte[]> {
        Float64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getDouble(array, offset + index * 8);
        }

        @Override
        public void setDoubleImpl(byte[] array, int offset, int index, double value) {
            ByteArrayAccess.nativeOrder().putDouble(array, offset + index * 8, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getDouble(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putDouble(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.doubleValue((Number)value));
        }
    }

    public static final class DirectFloat32Array
    extends TypedFloatArray<ByteBuffer> {
        DirectFloat32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(ByteBuffer buffer, int offset, int index) {
            return ByteBufferAccess.nativeOrder().getFloat(buffer, offset + index * 4);
        }

        @Override
        public void setDoubleImpl(ByteBuffer buffer, int offset, int index, double value) {
            ByteBufferAccess.nativeOrder().putFloat(buffer, offset + index * 4, (float)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return (double)ByteBufferAccess.forOrder(littleEndian).getFloat(JSArrayBuffer.getDirectByteBuffer(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putFloat(JSArrayBuffer.getDirectByteBuffer(buffer), index, JSRuntime.floatValue((Number)value));
        }
    }

    public static final class Float32Array
    extends TypedFloatArray<byte[]> {
        Float32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getFloat(array, offset + index * 4);
        }

        @Override
        public void setDoubleImpl(byte[] array, int offset, int index, double value) {
            ByteArrayAccess.nativeOrder().putFloat(array, offset + index * 4, (float)value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return (double)ByteArrayAccess.forOrder(littleEndian).getFloat(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putFloat(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.floatValue((Number)value));
        }
    }

    public static abstract class TypedFloatArray<T>
    extends TypedArray {
        protected TypedFloatArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public final Object getElement(DynamicObject object, long index) {
            if (this.hasElement(object, index)) {
                return this.getDouble(object, (int)index);
            }
            return Undefined.instance;
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index) {
            assert (this.hasElement(object, index));
            return this.getDouble(object, (int)index);
        }

        @Override
        public final TypedFloatArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict) {
            if (this.hasElement(object, index)) {
                this.setDouble(object, (int)index, JSRuntime.toDouble(value));
            }
            return this;
        }

        private T getBufferFromTypedArrayT(DynamicObject object) {
            return (T)super.getBufferFromTypedArray(object);
        }

        public final double getDouble(DynamicObject object, int index) {
            return this.getDoubleImpl(this.getBufferFromTypedArrayT(object), this.getOffset(object), index);
        }

        public final void setDouble(DynamicObject object, int index, double value) {
            this.setDoubleImpl(this.getBufferFromTypedArrayT(object), this.getOffset(object), index, value);
        }

        public abstract double getDoubleImpl(T var1, int var2, int var3);

        public abstract void setDoubleImpl(T var1, int var2, int var3, double var4);
    }

    public static final class DirectBigUint64Array
    extends TypedBigIntArray<ByteBuffer> {
        DirectBigUint64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return BigInt.valueOfUnsigned(ByteBufferAccess.forOrder(littleEndian).getInt64(JSArrayBuffer.getDirectByteBuffer(buffer), index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putInt64(JSArrayBuffer.getDirectByteBuffer(buffer), index, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(ByteBuffer buffer, int offset, int index) {
            return BigInt.valueOfUnsigned(ByteBufferAccess.nativeOrder().getInt64(buffer, offset + index * 8));
        }

        @Override
        public void setBigIntImpl(ByteBuffer buffer, int offset, int index, BigInt value) {
            ByteBufferAccess.nativeOrder().putInt64(buffer, offset + index * 8, value.longValue());
        }
    }

    public static final class BigUint64Array
    extends TypedBigIntArray<byte[]> {
        BigUint64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return BigInt.valueOfUnsigned(ByteArrayAccess.forOrder(littleEndian).getInt64(JSArrayBuffer.getByteArray(buffer), index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt64(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(byte[] buffer, int offset, int index) {
            return BigInt.valueOfUnsigned(ByteArrayAccess.nativeOrder().getInt64(buffer, offset + index * 8));
        }

        @Override
        public void setBigIntImpl(byte[] buffer, int offset, int index, BigInt value) {
            ByteArrayAccess.nativeOrder().putInt64(buffer, offset + index * 8, value.longValue());
        }
    }

    public static final class DirectBigInt64Array
    extends TypedBigIntArray<ByteBuffer> {
        DirectBigInt64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return BigInt.valueOf(ByteBufferAccess.forOrder(littleEndian).getInt64(JSArrayBuffer.getDirectByteBuffer(buffer), index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putInt64(JSArrayBuffer.getDirectByteBuffer(buffer), index, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(ByteBuffer buffer, int offset, int index) {
            return BigInt.valueOf(ByteBufferAccess.nativeOrder().getInt64(buffer, offset + index * 8));
        }

        @Override
        public void setBigIntImpl(ByteBuffer buffer, int offset, int index, BigInt value) {
            ByteBufferAccess.nativeOrder().putInt64(buffer, offset + index * 8, value.longValue());
        }
    }

    public static final class BigInt64Array
    extends TypedBigIntArray<byte[]> {
        BigInt64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return BigInt.valueOf(ByteArrayAccess.forOrder(littleEndian).getInt64(JSArrayBuffer.getByteArray(buffer), index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt64(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(byte[] buffer, int offset, int index) {
            return BigInt.valueOf(ByteArrayAccess.nativeOrder().getInt64(buffer, offset + index * 8));
        }

        @Override
        public void setBigIntImpl(byte[] buffer, int offset, int index, BigInt value) {
            ByteArrayAccess.nativeOrder().putInt64(buffer, offset + index * 8, value.longValue());
        }
    }

    public static abstract class TypedBigIntArray<T>
    extends TypedArray {
        protected TypedBigIntArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public Object getElement(DynamicObject object, long index) {
            if (this.hasElement(object, index)) {
                return this.getBigInt(object, (int)index);
            }
            return Undefined.instance;
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index) {
            assert (this.hasElement(object, index));
            return this.getBigInt(object, (int)index);
        }

        @Override
        public TypedBigIntArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict) {
            if (this.hasElement(object, index)) {
                this.setBigInt(object, (int)index, JSRuntime.toBigInt(value));
            }
            return this;
        }

        public final BigInt getBigInt(DynamicObject object, int index) {
            return this.getBigIntImpl(this.getBufferFromTypedArrayT(object), this.getOffset(object), index);
        }

        public final void setBigInt(DynamicObject object, int index, BigInt value) {
            this.setBigIntImpl(this.getBufferFromTypedArrayT(object), this.getOffset(object), index, value);
        }

        private T getBufferFromTypedArrayT(DynamicObject object) {
            return (T)super.getBufferFromTypedArray(object);
        }

        public abstract BigInt getBigIntImpl(T var1, int var2, int var3);

        public abstract void setBigIntImpl(T var1, int var2, int var3, BigInt var4);
    }

    public static final class DirectUint32Array
    extends AbstractUint32Array<ByteBuffer> {
        DirectUint32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return ByteBufferAccess.nativeOrder().getInt32(buffer, offset + index * 4);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            ByteBufferAccess.nativeOrder().putInt32(buffer, offset + index * 4, value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return DirectUint32Array.toUint32(ByteBufferAccess.forOrder(littleEndian).getInt32(JSArrayBuffer.getDirectByteBuffer(buffer), index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putInt32(JSArrayBuffer.getDirectByteBuffer(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Uint32Array
    extends AbstractUint32Array<byte[]> {
        Uint32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getInt32(array, offset + index * 4);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt32(array, offset + index * 4, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return Uint32Array.toUint32((int)ByteArrayAccess.forOrder(littleEndian).getUint32(JSArrayBuffer.getByteArray(buffer), index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt32(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static abstract class AbstractUint32Array<T>
    extends TypedIntArray<T> {
        private AbstractUint32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public Object getElement(DynamicObject object, long index) {
            if (this.hasElement(object, index)) {
                int value = this.getInt(object, (int)index);
                return AbstractUint32Array.toUint32(value);
            }
            return Undefined.instance;
        }

        protected static Number toUint32(int value) {
            if (value >= 0) {
                return value;
            }
            return (double)((long)value & 0xFFFFFFFFL);
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index) {
            assert (this.hasElement(object, index));
            return AbstractUint32Array.toUint32(this.getInt(object, (int)index));
        }
    }

    public static final class DirectInt32Array
    extends TypedIntArray<ByteBuffer> {
        DirectInt32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return ByteBufferAccess.nativeOrder().getInt32(buffer, offset + index * 4);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            ByteBufferAccess.nativeOrder().putInt32(buffer, offset + index * 4, value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteBufferAccess.forOrder(littleEndian).getInt32(JSArrayBuffer.getDirectByteBuffer(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putInt32(JSArrayBuffer.getDirectByteBuffer(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Int32Array
    extends TypedIntArray<byte[]> {
        Int32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getInt32(array, offset + index * 4);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt32(array, offset + index * 4, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getInt32(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt32(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectUint16Array
    extends TypedIntArray<ByteBuffer> {
        DirectUint16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return ByteBufferAccess.nativeOrder().getUint16(buffer, offset + index * 2);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            ByteBufferAccess.nativeOrder().putInt16(buffer, offset + index * 2, (char)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteBufferAccess.forOrder(littleEndian).getUint16(JSArrayBuffer.getDirectByteBuffer(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putInt16(JSArrayBuffer.getDirectByteBuffer(buffer), index, (char)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Uint16Array
    extends TypedIntArray<byte[]> {
        Uint16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getUint16(array, offset + index * 2);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt16(array, offset + index * 2, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getUint16(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt16(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectInt16Array
    extends TypedIntArray<ByteBuffer> {
        DirectInt16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return ByteBufferAccess.nativeOrder().getInt16(buffer, offset + index * 2);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            ByteBufferAccess.nativeOrder().putInt16(buffer, offset + index * 2, (short)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteBufferAccess.forOrder(littleEndian).getInt16(JSArrayBuffer.getDirectByteBuffer(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteBufferAccess.forOrder(littleEndian).putInt16(JSArrayBuffer.getDirectByteBuffer(buffer), index, (short)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Int16Array
    extends TypedIntArray<byte[]> {
        Int16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getInt16(array, offset + index * 2);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt16(array, offset + index * 2, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getInt16(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt16(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectUint8ClampedArray
    extends AbstractUint8ClampedArray<ByteBuffer> {
        DirectUint8ClampedArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return buffer.get(offset + index * 1) & 0xFF;
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            buffer.put(offset + index * 1, (byte)DirectUint8ClampedArray.uint8Clamp(value));
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return JSArrayBuffer.getDirectByteBuffer(buffer).get(index) & 0xFF;
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            JSArrayBuffer.getDirectByteBuffer(buffer).put(index, (byte)DirectUint8ClampedArray.uint8Clamp(DirectUint8ClampedArray.toInt(JSRuntime.toDouble((Number)value))));
        }
    }

    public static final class Uint8ClampedArray
    extends AbstractUint8ClampedArray<byte[]> {
        Uint8ClampedArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getUint8(array, offset + index * 1);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt8(array, offset + index * 1, Uint8ClampedArray.uint8Clamp(value));
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getUint8(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt8(JSArrayBuffer.getByteArray(buffer), index, Uint8ClampedArray.uint8Clamp(Uint8ClampedArray.toInt(JSRuntime.toDouble((Number)value))));
        }
    }

    public static abstract class AbstractUint8ClampedArray<T>
    extends TypedIntArray<T> {
        private AbstractUint8ClampedArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public TypedIntArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict) {
            if (this.hasElement(object, index)) {
                this.setInt(object, (int)index, AbstractUint8ClampedArray.toInt(JSRuntime.toDouble(value)));
            }
            return this;
        }

        protected static int uint8Clamp(int value) {
            return value < 0 ? 0 : (value > 255 ? 255 : value);
        }

        public static int toInt(double value) {
            return (int)JSRuntime.mathRint(value);
        }
    }

    public static final class DirectUint8Array
    extends TypedIntArray<ByteBuffer> {
        DirectUint8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return buffer.get(offset + index * 1) & 0xFF;
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            buffer.put(offset + index * 1, (byte)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return JSArrayBuffer.getDirectByteBuffer(buffer).get(index) & 0xFF;
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            JSArrayBuffer.getDirectByteBuffer(buffer).put(index, (byte)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Uint8Array
    extends TypedIntArray<byte[]> {
        Uint8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getUint8(array, offset + index * 1);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt8(array, offset + index * 1, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getUint8(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt8(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectInt8Array
    extends TypedIntArray<ByteBuffer> {
        DirectInt8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return buffer.get(offset + index * 1);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            buffer.put(offset + index * 1, (byte)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return (int)JSArrayBuffer.getDirectByteBuffer(buffer).get(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            JSArrayBuffer.getDirectByteBuffer(buffer).put(index, (byte)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Int8Array
    extends TypedIntArray<byte[]> {
        Int8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return ByteArrayAccess.nativeOrder().getInt8(array, offset + index * 1);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            ByteArrayAccess.nativeOrder().putInt8(array, offset + index * 1, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian) {
            return ByteArrayAccess.forOrder(littleEndian).getInt8(JSArrayBuffer.getByteArray(buffer), index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, Object value) {
            ByteArrayAccess.forOrder(littleEndian).putInt8(JSArrayBuffer.getByteArray(buffer), index, JSRuntime.toInt32((Number)value));
        }
    }

    public static abstract class TypedIntArray<T>
    extends TypedArray {
        protected TypedIntArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public Object getElement(DynamicObject object, long index) {
            if (this.hasElement(object, index)) {
                return this.getInt(object, (int)index);
            }
            return Undefined.instance;
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index) {
            assert (this.hasElement(object, index));
            return this.getInt(object, (int)index);
        }

        @Override
        public TypedIntArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict) {
            if (this.hasElement(object, index)) {
                this.setInt(object, (int)index, JSRuntime.toInt32(value));
            }
            return this;
        }

        public final int getInt(DynamicObject object, int index) {
            return this.getIntImpl(this.getBufferFromTypedArrayT(object), this.getOffset(object), index);
        }

        public final void setInt(DynamicObject object, int index, int value) {
            this.setIntImpl(this.getBufferFromTypedArrayT(object), this.getOffset(object), index, value);
        }

        private T getBufferFromTypedArrayT(DynamicObject object) {
            return (T)super.getBufferFromTypedArray(object);
        }

        public abstract int getIntImpl(T var1, int var2, int var3);

        public abstract void setIntImpl(T var1, int var2, int var3, int var4);
    }
}

