/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.util.Arrays;

public final class JSPrototypeData {
    private static final Shape[] EMPTY_SHAPE_ARRAY = new Shape[0];
    private volatile Shape[] protoChildTrees = EMPTY_SHAPE_ARRAY;

    public Shape getProtoChildTree(JSClass jsclass) {
        for (Shape childTree : this.protoChildTrees) {
            if (JSShape.getJSClassNoCast(childTree) != jsclass) continue;
            return childTree;
        }
        return null;
    }

    public synchronized Shape getOrAddProtoChildTree(JSClass jsclass, Shape newRootShape) {
        CompilerAsserts.neverPartOfCompilation();
        Shape existingRootShape = this.getProtoChildTree(jsclass);
        if (existingRootShape == null) {
            Shape[] oldArray = this.protoChildTrees;
            Shape[] newArray = Arrays.copyOf(oldArray, oldArray.length + 1);
            newArray[oldArray.length] = newRootShape;
            this.protoChildTrees = newArray;
            return newRootShape;
        }
        return existingRootShape;
    }
}

