/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingComponentDecorationFactory;

final class SimpleDefaultDecorator
extends SwingComponentDecorationFactory {
    private Icon fatalIconTransp = null;
    private Icon warningIconTransp = null;
    private Icon infoIconTransp = null;

    SimpleDefaultDecorator() {
    }

    @Override
    public ValidationUI decorationFor(JComponent c) {
        return new ToolTippedIconLabel(c, this);
    }

    protected boolean configureToolTipLabel(Problem problem, JComponent decoratedComponent, JLabel ttLabel) {
        Color bg = UIManager.getColor("white");
        ttLabel.setBackground(bg == null ? Color.WHITE : bg);
        ttLabel.setOpaque(true);
        ttLabel.setIcon(problem.severity().icon());
        ttLabel.setForeground(problem.severity().color());
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(problem.severity().color(), 1), BorderFactory.createMatteBorder(3, 3, 3, 3, bg));
        ttLabel.setBorder(b);
        ttLabel.setText(problem.getMessage());
        return true;
    }

    protected Color getComponentOverlayColor(Severity s, JComponent decoratedComponent) {
        int alpha = 13;
        return new Color(s.color().getRed(), s.color().getGreen(), s.color().getBlue(), alpha);
    }

    protected Point getDecorationLocation(Severity s, JComponent decoratedComponent, Dimension decorationIconSize) {
        return new Point(decoratedComponent.getWidth() - decorationIconSize.width + 2, -2);
    }

    protected Image getDecorationImage(Severity severity, JComponent decoratedComponent) {
        return severity.badge();
    }

    protected Double getDecorationImageScaling(Severity s, JComponent decoratedComponent) {
        return null;
    }

    protected Integer getDecorationOverlapTransparency(Severity s, JComponent decoratedComponent) {
        return null;
    }

    Icon getDecorationIcon(Severity severity, JComponent decoratedComponent) {
        Integer alpha;
        if (severity.equals((Object)Severity.FATAL) && this.fatalIconTransp != null) {
            return this.fatalIconTransp;
        }
        if (severity.equals((Object)Severity.WARNING) && this.warningIconTransp != null) {
            return this.warningIconTransp;
        }
        if (severity.equals((Object)Severity.INFO) && this.infoIconTransp != null) {
            return this.infoIconTransp;
        }
        Image image = this.getDecorationImage(severity, decoratedComponent);
        if (image == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(image);
        Double scaling = this.getDecorationImageScaling(severity, decoratedComponent);
        if (scaling != null) {
            int scaledWidth = (int)(scaling * (double)icon.getIconWidth());
            int scaledHeight = (int)(scaling * (double)icon.getIconHeight());
            BufferedImage scaledImg = new BufferedImage(scaledWidth, scaledHeight, 2);
            Graphics2D g2 = scaledImg.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
            g2.dispose();
            image = scaledImg;
            icon = new ImageIcon(image);
        }
        if ((alpha = this.getDecorationOverlapTransparency(severity, decoratedComponent)) != null) {
            final Point translate = this.getDecorationLocation(null, decoratedComponent, new Dimension(icon.getIconWidth(), icon.getIconWidth()));
            final int dcW = decoratedComponent.getWidth();
            final int dcH = decoratedComponent.getHeight();
            RGBImageFilter filter = new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    if ((x += translate.x) > 0 && x < dcW && (y += translate.y) > 0 && y < dcH) {
                        return (alpha << 24 | 0xFFFFFF) & rgb;
                    }
                    return rgb;
                }
            };
            image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
            icon = new ImageIcon(image);
        }
        if (severity.equals((Object)Severity.FATAL)) {
            this.fatalIconTransp = icon;
            return this.fatalIconTransp;
        }
        if (severity.equals((Object)Severity.WARNING)) {
            this.warningIconTransp = icon;
            return this.warningIconTransp;
        }
        assert (severity.equals((Object)Severity.INFO));
        this.infoIconTransp = icon;
        return this.infoIconTransp;
    }

    static final class ToolTippedIconLabel
    extends JLabel
    implements ValidationUI {
        private final JToolTip tt = new JToolTip();
        private final JLabel ttLabel = new JLabel();
        private final JComponent decoratedComponent;
        private final ValidationUI colorizingBorder;
        private Problem currentProblem = null;
        private MouseEvent lastMouseEvent = null;
        private boolean hasAddedToPane = false;
        private SimpleDefaultDecorator decorator;

        ToolTippedIconLabel(JComponent component, SimpleDefaultDecorator decorator) {
            this.decorator = decorator;
            this.decoratedComponent = component;
            this.colorizingBorder = new ColorizingBorder(component, decorator);
            this.setOpaque(false);
            this.decoratedComponent.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        ToolTippedIconLabel.this.tryDecorationIcon();
                        ToolTippedIconLabel.this.setVisible(ToolTippedIconLabel.this.decoratedComponent.isShowing() && ToolTippedIconLabel.this.currentProblem != null);
                    }
                }
            });
            this.decoratedComponent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent evt) {
                    ToolTippedIconLabel.this.tryDecorationIcon();
                }

                @Override
                public void componentResized(ComponentEvent evt) {
                    ToolTippedIconLabel.this.tryDecorationIcon();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ToolTippedIconLabel.this.lastMouseEvent = e;
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ToolTippedIconLabel.this.lastMouseEvent = null;
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    ToolTippedIconLabel.this.lastMouseEvent = e;
                }
            });
            this.tt.setLayout(new BorderLayout());
            this.tt.add(this.ttLabel);
            this.tt.setBorder(null);
        }

        @Override
        public JToolTip createToolTip() {
            assert (SwingUtilities.isEventDispatchThread()) : "Not on EventDispatchThread";
            assert (this.tt != null);
            return this.tt;
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.currentProblem != null) {
                this.colorizingBorder.showProblem(this.currentProblem);
            } else {
                this.colorizingBorder.clearProblem();
            }
        }

        @Override
        public void showProblem(Problem problem) {
            assert (SwingUtilities.isEventDispatchThread()) : "Not on EventDispatchThread";
            if (problem != null && problem.equals(this.currentProblem)) {
                return;
            }
            this.colorizingBorder.showProblem(problem);
            this.currentProblem = problem;
            if (this.currentProblem == null) {
                if (this.isVisible()) {
                    this.setVisible(false);
                }
                if (this.tt.isShowing()) {
                    MouseEvent theEvent = this.lastMouseEvent;
                    this.dispatchEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, 0, 0, 0, false));
                    this.lastMouseEvent = theEvent;
                }
                return;
            }
            this.problemUpdateTooltip(problem);
            if (!this.tryDecorationIcon()) {
                return;
            }
            this.setVisible(true);
        }

        private void problemUpdateTooltip(Problem problem) {
            if (this.decorator.getDecorationImage(problem.severity(), this.decoratedComponent) == null || !this.decorator.configureToolTipLabel(problem, this.decoratedComponent, this.ttLabel)) {
                this.tt.setVisible(false);
                if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
                return;
            }
            this.tt.setVisible(true);
            if (this.getToolTipText() == null) {
                this.setToolTipText("");
            }
            this.tt.setPreferredSize(this.ttLabel.getPreferredSize());
            if (this.lastMouseEvent != null) {
                MouseEvent theEvent = this.lastMouseEvent;
                this.dispatchEvent(new MouseEvent(this, 505, System.currentTimeMillis() - 100L, theEvent.getModifiers(), theEvent.getX(), theEvent.getY(), 0, false));
                assert (this.lastMouseEvent == null);
                this.dispatchEvent(new MouseEvent(this, 504, System.currentTimeMillis() - 50L, theEvent.getModifiers(), theEvent.getX(), theEvent.getY(), 0, false));
                this.dispatchEvent(new MouseEvent(this, 503, System.currentTimeMillis(), theEvent.getModifiers(), theEvent.getX(), theEvent.getY(), 0, false));
                assert (this.lastMouseEvent != null);
            }
        }

        private boolean tryDecorationIcon() {
            assert (SwingUtilities.isEventDispatchThread()) : "Not on EventDispatchThread";
            if (!this.decoratedComponent.isShowing()) {
                return false;
            }
            assert (JLayeredPane.getLayeredPaneAbove(this.decoratedComponent) != null) : "JLayeredPane.getLayeredPaneAbove(decoratedComponent) unexpectedly returned null";
            if (!this.hasAddedToPane) {
                JLayeredPane.getLayeredPaneAbove(this.decoratedComponent).add((Component)this, new Integer(JLayeredPane.getLayer(this.decoratedComponent) + 10));
                this.hasAddedToPane = true;
            }
            if (this.currentProblem == null) {
                return false;
            }
            Icon icon = this.decorator.getDecorationIcon(this.currentProblem.severity(), this.decoratedComponent);
            if (icon == null) {
                return false;
            }
            this.setIcon(icon);
            this.setSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            Point p = this.decoratedComponent.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(p, this.getParent());
            Point transl = this.decorator.getDecorationLocation(null, this.decoratedComponent, new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            p.translate(transl.x, transl.y);
            this.setLocation(p);
            return true;
        }

        @Override
        public void clearProblem() {
            this.showProblem(null);
        }
    }

    static final class ColorizingBorder
    implements Border,
    ValidationUI {
        private SimpleDefaultDecorator decorator;
        private final JComponent decoratedComponent;
        private final Border real;
        private Severity severity = null;

        public ColorizingBorder(JComponent c, SimpleDefaultDecorator decorator) {
            this.decorator = decorator;
            this.decoratedComponent = c;
            this.real = c.getBorder() != null ? c.getBorder() : BorderFactory.createEmptyBorder();
            c.setBorder(this);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.real.paintBorder(c, g, x, y, width, height);
            if (this.severity == null) {
                return;
            }
            Color niceTransparentColorForRectangle = this.decorator.getComponentOverlayColor(this.severity, this.decoratedComponent);
            if (niceTransparentColorForRectangle == null) {
                return;
            }
            g.setColor(niceTransparentColorForRectangle);
            g.fillRect(x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.real.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void showProblem(Problem problem) {
            this.severity = problem == null ? null : problem.severity();
        }

        @Override
        public void clearProblem() {
            this.severity = null;
        }
    }
}

