/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.lang.reflect.Proxy;

interface HostWrapper {
    public Object getGuestObject();

    public PolyglotContextImpl getContext();

    public PolyglotLanguageContext getLanguageContext();

    public static boolean isInstance(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Proxy) {
            return HostWrapper.isHostProxy(v);
        }
        return v instanceof HostWrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isHostProxy(Object v) {
        if (Proxy.isProxyClass(v.getClass())) {
            return Proxy.getInvocationHandler(v) instanceof HostWrapper;
        }
        return false;
    }

    public static HostWrapper asInstance(Object v) {
        if (v instanceof Proxy) {
            return HostWrapper.getHostProxy(v);
        }
        return (HostWrapper)v;
    }

    @CompilerDirectives.TruffleBoundary
    public static HostWrapper getHostProxy(Object v) {
        return (HostWrapper)((Object)Proxy.getInvocationHandler(v));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equalsProxy(HostWrapper wrapper, Object other) {
        if (other == null) {
            return false;
        }
        if (Proxy.isProxyClass(other.getClass())) {
            return HostWrapper.equals(wrapper.getLanguageContext(), wrapper.getGuestObject(), HostWrapper.getHostProxy(other).getGuestObject());
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(PolyglotLanguageContext languageContext, Object receiver, Object obj) {
        if (obj == null) {
            return false;
        }
        if (receiver == obj) {
            return true;
        }
        if (languageContext != null && (languageContext.context.closed || languageContext.context.invalid)) {
            return false;
        }
        Object prev = null;
        try {
            prev = PolyglotValue.hostEnter(languageContext);
        }
        catch (Throwable t) {
            return false;
        }
        try {
            InteropLibrary receiverLib = InteropLibrary.getUncached(receiver);
            InteropLibrary objLib = InteropLibrary.getUncached(obj);
            boolean bl = receiverLib.isIdentical(receiver, obj, objLib);
            return bl;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t);
        }
        finally {
            try {
                PolyglotValue.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int hashCode(PolyglotLanguageContext languageContext, Object receiver) {
        int n;
        if (languageContext != null && (languageContext.context.closed || languageContext.context.invalid)) {
            return System.identityHashCode(receiver);
        }
        Object prev = null;
        try {
            prev = PolyglotValue.hostEnter(languageContext);
        }
        catch (Throwable t) {
            return System.identityHashCode(receiver);
        }
        try {
            InteropLibrary receiverLib = InteropLibrary.getUncached(receiver);
            if (receiverLib.hasIdentity(receiver)) {
                int n2 = receiverLib.identityHashCode(receiver);
                return n2;
            }
            n = System.identityHashCode(receiver);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t);
        }
        finally {
            try {
                PolyglotValue.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    public static String toString(HostWrapper thisObj) {
        PolyglotLanguageContext thisContext = thisObj.getLanguageContext();
        Object thisGuestObject = thisObj.getGuestObject();
        if (thisContext != null) {
            try {
                return thisContext.asValue(thisGuestObject).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "Error in toString()";
    }
}

