/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.jsch.agentproxy;

import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorFactory {
    private static ConnectorFactory instance;
    private static final Logger LOG;

    private ConnectorFactory() {
    }

    public static synchronized ConnectorFactory getInstance() {
        if (instance == null) {
            instance = new ConnectorFactory();
        }
        return instance;
    }

    public Connector createConnector(ConnectorKind preferredKind) {
        SSHAgentConnector con = null;
        try {
            if ((preferredKind == ConnectorKind.ANY || preferredKind == ConnectorKind.SSH_AGENT) && SSHAgentConnector.isConnectorAvailable()) {
                JNAUSocketFactory usf = new JNAUSocketFactory();
                con = new SSHAgentConnector((USocketFactory)usf);
            }
        }
        catch (Throwable ex) {
            LOG.log(Level.FINE, null, ex);
        }
        try {
            if ((preferredKind == ConnectorKind.ANY || preferredKind == ConnectorKind.PAGEANT) && PageantConnector.isConnectorAvailable()) {
                con = new PageantConnector();
            }
        }
        catch (Throwable ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return con;
    }

    static {
        LOG = Logger.getLogger(ConnectorFactory.class.getName());
    }

    public static enum ConnectorKind {
        ANY,
        PAGEANT,
        SSH_AGENT;

    }
}

