/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.processtreekiller.EnvVars;
import org.netbeans.processtreekiller.UnixSystem;

abstract class UnixProcess<P extends UnixProcess<P>> {
    private static final Method DESTROY_PROCESS;
    private static final Logger LOGGER;
    public final UnixSystem<P> system;

    protected UnixProcess(UnixSystem<P> system) {
        this.system = system;
    }

    public abstract int getPid();

    public abstract P getParent();

    protected final File getFile(String relativePath) {
        return new File(new File("/proc/" + this.getPid()), relativePath);
    }

    protected final Path getPath(String relativePath) {
        return Paths.get("/proc/", Integer.toString(this.getPid()), relativePath);
    }

    public List<UnixProcess> getChildren() {
        ArrayList<UnixProcess> r = new ArrayList<UnixProcess>();
        for (UnixProcess p : this.system) {
            if (p.getParent() != this) continue;
            r.add(p);
        }
        return r;
    }

    public void kill() {
        try {
            if (DESTROY_PROCESS.getParameterTypes().length > 1) {
                DESTROY_PROCESS.invoke(null, this.getPid(), false);
            } else {
                DESTROY_PROCESS.invoke(null, this.getPid());
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError();
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            LOGGER.log(Level.INFO, "Failed to terminate pid=" + this.getPid(), e);
        }
    }

    public void killRecursively() {
        for (UnixProcess p : this.getChildren()) {
            p.killRecursively();
        }
        this.kill();
    }

    public abstract EnvVars getEnvVars();

    public abstract List<String> getArguments();

    static {
        Method destroyMethod;
        LOGGER = Logger.getLogger(UnixProcess.class.getName());
        try {
            Class<?> clazz = Class.forName("java.lang.UNIXProcess");
            try {
                destroyMethod = clazz.getDeclaredMethod("destroyProcess", Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                destroyMethod = clazz.getDeclaredMethod("destroyProcess", Integer.TYPE, Boolean.TYPE);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LinkageError x = new LinkageError();
            x.initCause(e);
            throw x;
        }
        DESTROY_PROCESS = destroyMethod;
        DESTROY_PROCESS.setAccessible(true);
    }
}

