/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.spi.WatchedResourceProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public final class NbGradleProject {
    public static final String GRADLE_PROJECT_TYPE = "org-netbeans-modules-gradle";
    public static final String GRADLE_PLUGIN_TYPE = "org-netbeans-modules-gradle/Plugins";
    public static final String PROP_PROJECT_INFO = "ProjectInfo";
    public static final String PROP_RESOURCES = "resources";
    private static final String GRADLE_ICON = "org/netbeans/modules/gradle/resources/gradle.png";
    private static final String WARNING_BADGE = "org/netbeans/modules/gradle/resources/warning-badge.png";
    private static Icon warningIcon;
    public static final String CODENAME_BASE = "org.netbeans.modules.gradle";
    private final NbGradleProjectImpl project;
    private final PropertyChangeSupport support;
    private final Set<File> resources = new HashSet<File>();
    private Preferences privatePrefs;
    private Preferences sharedPrefs;
    private final FileChangeListener FCHSL = new FileChangeListener(){

        public void fileFolderCreated(FileEvent fe) {
            NbGradleProject.this.fireChange(FileUtil.toFile((FileObject)fe.getFile()));
        }

        public void fileDataCreated(FileEvent fe) {
            NbGradleProject.this.fireChange(FileUtil.toFile((FileObject)fe.getFile()));
        }

        public void fileChanged(FileEvent fe) {
            NbGradleProject.this.fireChange(FileUtil.toFile((FileObject)fe.getFile()));
        }

        public void fileDeleted(FileEvent fe) {
            NbGradleProject.this.fireChange(FileUtil.toFile((FileObject)fe.getFile()));
        }

        public void fileRenamed(FileRenameEvent fe) {
            NbGradleProject.this.fireChange(FileUtil.toFile((FileObject)fe.getFile()));
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    };

    public boolean isGradleProjectLoaded() {
        return this.project.isGradleProjectLoaded();
    }

    private NbGradleProject(NbGradleProjectImpl project) {
        this.project = project;
        this.support = new PropertyChangeSupport(project);
    }

    public <T> T projectLookup(Class<T> clazz) {
        return (T)this.project.getGradleProject().getLookup().lookup(clazz);
    }

    public Quality getQuality() {
        return this.project.getGradleProject().getQuality();
    }

    public Quality getAimedQuality() {
        return this.project.getAimedQuality();
    }

    public boolean isUnloadable() {
        return this.getQuality().worseThan(Quality.SIMPLE);
    }

    @NonNull
    public CompletionStage<NbGradleProject> toQuality(@NullAllowed String reason, @NonNull Quality q, boolean forceLoad) {
        return this.project.projectWithQualityTask(reason, q, false, forceLoad).thenApply(p -> this);
    }

    public Preferences getPreferences(boolean shared) {
        Preferences ret;
        Preferences preferences = ret = shared ? this.sharedPrefs : this.privatePrefs;
        if (ret == null) {
            ret = shared ? (this.sharedPrefs = ProjectUtils.getPreferences((Project)this.project, NbGradleProject.class, (boolean)true)) : (this.privatePrefs = ProjectUtils.getPreferences((Project)this.project, NbGradleProject.class, (boolean)false));
        }
        return ret;
    }

    private void fireProjectReload() {
        this.project.fireProjectReload(false);
    }

    private void doFireReload() {
        this.detachResourceWatchers();
        this.support.firePropertyChange(PROP_PROJECT_INFO, null, null);
        this.attachResourceWatchers();
    }

    private void detachResourceWatchers() {
        for (File resource : this.resources) {
            try {
                FileUtil.removeFileChangeListener((FileChangeListener)this.FCHSL, (File)resource);
            }
            catch (IllegalArgumentException ex) {
                assert (false) : "Something is wrong with the resource handling";
            }
        }
        this.resources.clear();
    }

    private void attachResourceWatchers() {
        if (this.project.getAimedQuality() == Quality.FALLBACK) {
            return;
        }
        Collection all = this.project.getLookup().lookupAll(WatchedResourceProvider.class);
        for (WatchedResourceProvider pvd : all) {
            this.resources.addAll(pvd.getWatchedResources());
        }
        for (File resource : this.resources) {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this.FCHSL, (File)resource);
            }
            catch (IllegalArgumentException ex) {
                assert (false) : "Something is wrong with the resource handling";
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public static NbGradleProject get(Project project) {
        return project instanceof NbGradleProjectImpl ? ((NbGradleProjectImpl)project).getProjectWatcher() : null;
    }

    public String toString() {
        return "Watcher for " + this.project.toString();
    }

    public static ImageIcon getIcon() {
        return ImageUtilities.loadImageIcon((String)GRADLE_ICON, (boolean)false);
    }

    public static final Icon getWarningIcon() {
        if (warningIcon == null) {
            Image icon = ImageUtilities.icon2Image((Icon)NbGradleProject.getIcon());
            Image badge = ImageUtilities.loadImage((String)WARNING_BADGE);
            icon = ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)8, (int)0);
            warningIcon = ImageUtilities.image2Icon((Image)icon);
        }
        return warningIcon;
    }

    public static void addPropertyChangeListener(Project project, PropertyChangeListener l) {
        if (project != null && project instanceof NbGradleProjectImpl) {
            ((NbGradleProjectImpl)project).getProjectWatcher().addPropertyChangeListener(l);
        } else assert (false) : "Attempted to add PropertyChangeListener to project " + project;
    }

    public static void removePropertyChangeListener(Project project, PropertyChangeListener l) {
        if (project != null && project instanceof NbGradleProjectImpl) {
            ((NbGradleProjectImpl)project).getProjectWatcher().removePropertyChangeListener(l);
        } else assert (false) : "Attempted to remove PropertyChangeListener to project " + project;
    }

    public static void fireGradleProjectReload(Project prj) {
        NbGradleProject watcher;
        if (prj != null && (watcher = NbGradleProject.get(prj)) != null) {
            watcher.fireProjectReload();
        }
    }

    public static Preferences getPreferences(Project project, boolean shared) {
        NbGradleProject watcher = NbGradleProject.get(project);
        return watcher.getPreferences(shared);
    }

    private void fireChange(File f) {
        this.support.firePropertyChange(PROP_RESOURCES, null, Utilities.toURI((File)f));
    }

    static {
        AccessorImpl impl = new AccessorImpl();
        impl.assign();
    }

    static class AccessorImpl
    extends NbGradleProjectImpl.WatcherAccessor {
        AccessorImpl() {
        }

        public void assign() {
            if (NbGradleProjectImpl.ACCESSOR == null) {
                NbGradleProjectImpl.ACCESSOR = this;
            }
        }

        @Override
        public NbGradleProject createWatcher(NbGradleProjectImpl proj) {
            return new NbGradleProject(proj);
        }

        @Override
        public void doFireReload(NbGradleProject watcher) {
            watcher.doFireReload();
        }

        @Override
        public void activate(NbGradleProject watcher) {
            watcher.attachResourceWatchers();
        }

        @Override
        public void passivate(NbGradleProject watcher) {
            watcher.detachResourceWatchers();
        }
    }

    public static enum Quality {
        FALLBACK,
        EVALUATED,
        SIMPLE,
        FULL,
        FULL_ONLINE;


        public boolean betterThan(Quality q) {
            return this.ordinal() > q.ordinal();
        }

        public boolean atLeast(Quality q) {
            return this.ordinal() >= q.ordinal();
        }

        public boolean worseThan(Quality q) {
            return this.ordinal() < q.ordinal();
        }

        public boolean notBetterThan(Quality q) {
            return this.ordinal() <= q.ordinal();
        }
    }
}

