/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.spi;

import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.spi.Bundle;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ProjectHudsonJobCreatorFactory {
    public ProjectHudsonJobCreator forProject(Project var1);

    public static final class Helper {
        private Helper() {
        }

        public static HudsonSCM.Configuration prepareSCM(File basedir) {
            for (HudsonSCM scm : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                HudsonSCM.Configuration cfg = scm.forFolder(basedir);
                if (cfg == null) continue;
                return cfg;
            }
            return null;
        }

        public static HudsonSCM.ConfigurationStatus noSCMError() {
            return HudsonSCM.ConfigurationStatus.withError((String)Bundle.ProjectHudsonJobCreatorFactory_no_vcs());
        }

        public static void addLogRotator(Document configXml) {
            Element lr = (Element)configXml.getDocumentElement().appendChild(configXml.createElement("logRotator"));
            lr.appendChild(configXml.createElement("daysToKeep")).appendChild(configXml.createTextNode("-1"));
            lr.appendChild(configXml.createElement("numToKeep")).appendChild(configXml.createTextNode("1"));
        }
    }

    public static interface ProjectHudsonJobCreator {
        public String jobName();

        public JComponent customizer();

        public HudsonSCM.ConfigurationStatus status();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public Document configure() throws IOException;

        public static class SilentIOException
        extends IOException {
            public SilentIOException() {
            }

            public SilentIOException(String message) {
                super(message);
            }

            public SilentIOException(String message, Throwable cause) {
                super(message, cause);
            }

            public SilentIOException(Throwable cause) {
                super(cause);
            }
        }
    }
}

