/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.api.GoToSource;
import org.openide.filesystems.FileObject;

public final class SampledCPUSnapshot {
    public static final String OPEN_THREADS_URL = "file:/stackframe/";
    private FileObject npssFile;
    private LoadedSnapshot.SamplesInputStream samplesStream;
    private long lastTimestamp;
    private int samples;
    private int currentIndex;
    private LoadedSnapshot.ThreadsSample sample;
    private StackTraceSnapshotBuilder builder;
    private long startTime;

    public SampledCPUSnapshot(FileObject file) throws IOException {
        this.samplesStream = new LoadedSnapshot.SamplesInputStream(file.getInputStream());
        this.npssFile = file;
        this.samples = this.samplesStream.getSamples();
        this.lastTimestamp = this.samplesStream.getLastTimestamp();
        if (this.samples == 0) {
            this.initSamples();
        }
        this.currentIndex = -1;
    }

    public int getSamplesCount() {
        return this.samples;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTimestamp(int sampleIndex) throws IOException {
        if (sampleIndex == this.getSamplesCount() - 1) {
            return this.lastTimestamp;
        }
        this.getSample(sampleIndex);
        long timestamp = this.sample.getTime();
        if (this.startTime == 0L) {
            this.startTime = timestamp;
            this.builder = new StackTraceSnapshotBuilder();
        }
        this.builder.addStacktrace(this.sample.getTinfos(), timestamp);
        return timestamp;
    }

    public long getValue(int sampleIndex, int valIndex) throws IOException {
        this.getSample(sampleIndex);
        long ret = 0L;
        for (ThreadInfo info : this.sample.getTinfos()) {
            if (!info.getThreadState().equals((Object)Thread.State.RUNNABLE)) continue;
            ret += (long)info.getStackTrace().length;
        }
        return ret;
    }

    public List<Integer> getIntervals(int startIndex, int endIndex, PrestimeCPUCCTNode node) throws IOException {
        ArrayList<Integer> intervals = new ArrayList<Integer>();
        LoadedSnapshot.SamplesInputStream stream = this.seek(startIndex);
        PrestimeCPUCCTNode n = node;
        ArrayList<String[]> stack = new ArrayList<String[]>();
        String NATIVE_ID = "[native]";
        boolean match = false;
        do {
            PrestimeCPUCCTNode cctNode;
            if (!(n instanceof PrestimeCPUCCTNode) || !this.isRegular(cctNode = n)) continue;
            String[] mid = cctNode.getMethodClassNameAndSig();
            if (mid[1].endsWith("[native]")) {
                mid[1] = mid[1].substring(0, mid[1].length() - "[native]".length());
            }
            stack.add(0, mid);
        } while ((n = n.getParent()) != null);
        for (int i = startIndex; i <= endIndex; ++i) {
            LoadedSnapshot.ThreadsSample _sample = stream.readSample();
            ThreadInfo[] threads = _sample.getTinfos();
            if (this.findStack(stack, threads)) {
                if (!match) {
                    intervals.add(i);
                }
                match = true;
                continue;
            }
            if (match) {
                intervals.add(i - 1);
            }
            match = false;
        }
        if (match) {
            intervals.add(endIndex);
        }
        stream.close();
        stream = null;
        return intervals;
    }

    private boolean findStack(List<String[]> stack, ThreadInfo[] threads) {
        for (ThreadInfo t : threads) {
            int j;
            StackTraceElement[] els = t.getStackTrace();
            if (els == null || els.length < stack.size()) continue;
            for (j = 0; j < stack.size(); ++j) {
                StackTraceElement el = els[els.length - j - 1];
                String[] method = stack.get(j);
                if (!el.getClassName().equals(method[0]) || !el.getMethodName().equals(method[1])) break;
            }
            if (j != stack.size()) continue;
            return true;
        }
        return false;
    }

    public String getThreadDump(int sampleIndex) throws IOException {
        StringBuilder sb = new StringBuilder(4096);
        LoadedSnapshot.SamplesInputStream stream = this.seek(sampleIndex);
        LoadedSnapshot.ThreadsSample _sample = stream.readSample();
        ThreadInfo[] threads = _sample.getTinfos();
        stream.close();
        stream = null;
        this.printThreads(sb, threads);
        return sb.toString();
    }

    public LoadedSnapshot getCPUSnapshot(int startIndex, int endIndex) throws IOException {
        LoadedSnapshot snapshot;
        if (this.builder != null && this.samplesStream == null && startIndex == 0 && endIndex == this.getSamplesCount() - 1) {
            snapshot = this.createSnapshot(this.startTime / 1000000L, this.builder);
            this.builder = null;
        } else {
            LoadedSnapshot.SamplesInputStream stream = this.seek(startIndex);
            StackTraceSnapshotBuilder _builder = new StackTraceSnapshotBuilder();
            long _startTime = 0L;
            for (int i = startIndex; i <= endIndex; ++i) {
                LoadedSnapshot.ThreadsSample _sample = stream.readSample();
                if (_startTime == 0L) {
                    _startTime = _sample.getTime() / 1000000L;
                }
                _builder.addStacktrace(_sample.getTinfos(), _sample.getTime());
            }
            stream.close();
            stream = null;
            snapshot = this.createSnapshot(_startTime, _builder);
        }
        return snapshot;
    }

    private LoadedSnapshot createSnapshot(long startTime, StackTraceSnapshotBuilder builder) throws IOException {
        CPUResultsSnapshot snapshot;
        try {
            snapshot = builder.createSnapshot(startTime);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException ex) {
            throw new IOException(ex);
        }
        LoadedSnapshot ls = new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
        ls.setSaved(true);
        return ls;
    }

    private LoadedSnapshot.SamplesInputStream seek(int sampleIndex) throws IOException {
        LoadedSnapshot.SamplesInputStream stream = new LoadedSnapshot.SamplesInputStream(this.npssFile.getInputStream());
        for (int i = 0; i < sampleIndex; ++i) {
            stream.readSample();
        }
        return stream;
    }

    private void getSample(int sampleIndex) throws IllegalArgumentException, IOException {
        if (this.currentIndex > sampleIndex || this.currentIndex + 1 < sampleIndex) {
            throw new IllegalArgumentException("current sample " + this.currentIndex + " requested sample " + sampleIndex);
        }
        if (this.currentIndex + 1 == sampleIndex) {
            ++this.currentIndex;
            this.sample = this.samplesStream.readSample();
            if (sampleIndex == this.getSamplesCount() - 1) {
                this.samplesStream.close();
                this.samplesStream = null;
            }
        }
    }

    private void printThreads(StringBuilder sb, ThreadInfo[] threads) {
        boolean goToSourceAvailable = GoToSource.isAvailable();
        sb.append("<pre>");
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            this.print16Thread(sb, thread, goToSourceAvailable);
        }
        sb.append("</pre>");
    }

    private void print16Thread(StringBuilder sb, ThreadInfo thread, boolean goToSourceAvailable) {
        LockInfo[] synchronizers;
        MonitorInfo[] monitors = thread.getLockedMonitors();
        sb.append("&nbsp;<b>");
        sb.append("\"").append(thread.getThreadName()).append("\" - Thread t@").append(thread.getThreadId()).append("<br>");
        sb.append("    java.lang.Thread.State: ").append((Object)thread.getThreadState());
        sb.append("</b><br>");
        int index = 0;
        for (StackTraceElement st : thread.getStackTrace()) {
            LockInfo lock = thread.getLockInfo();
            String stackElementText = SampledCPUSnapshot.htmlize(st.toString());
            String lockOwner = thread.getLockOwnerName();
            String className = st.getClassName();
            String method = st.getMethodName();
            int lineNo = st.getLineNumber();
            String stackEl = stackElementText;
            if (goToSourceAvailable) {
                String stackUrl = OPEN_THREADS_URL + className + "|" + method + "|" + lineNo;
                stackEl = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
            }
            sb.append("\tat ").append(stackEl).append("<br>");
            if (index == 0) {
                if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                    if (lock != null) {
                        sb.append("\t- waiting on ");
                        this.printLock(sb, lock);
                        sb.append("<br>");
                    }
                } else if (lock != null) {
                    if (lockOwner == null) {
                        sb.append("\t- parking to wait for ");
                        this.printLock(sb, lock);
                        sb.append("<br>");
                    } else {
                        sb.append("\t- waiting to lock ");
                        this.printLock(sb, lock);
                        sb.append(" owned by \"").append(lockOwner).append("\" t@").append(thread.getLockOwnerId()).append("<br>");
                    }
                }
            }
            this.printMonitors(sb, monitors, index);
            ++index;
        }
        StringBuilder jnisb = new StringBuilder();
        this.printMonitors(jnisb, monitors, -1);
        if (jnisb.length() > 0) {
            sb.append("   JNI locked monitors:<br>");
            sb.append((CharSequence)jnisb);
        }
        if ((synchronizers = thread.getLockedSynchronizers()) != null) {
            sb.append("<br>   Locked ownable synchronizers:");
            if (synchronizers.length == 0) {
                sb.append("<br>\t- None\n");
            } else {
                for (LockInfo li : synchronizers) {
                    sb.append("<br>\t- locked ");
                    this.printLock(sb, li);
                    sb.append("<br>");
                }
            }
        }
        sb.append("<br>");
    }

    private void printMonitors(StringBuilder sb, MonitorInfo[] monitors, int index) {
        if (monitors != null) {
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != index) continue;
                sb.append("\t- locked ");
                this.printLock(sb, mi);
                sb.append("<br>");
            }
        }
    }

    private void printLock(StringBuilder sb, LockInfo lock) {
        String id = Integer.toHexString(lock.getIdentityHashCode());
        String className = lock.getClassName();
        sb.append("&lt;").append(id).append("&gt; (a ").append(className).append(")");
    }

    private static String htmlize(String value) {
        return value.replace(">", "&gt;").replace("<", "&lt;");
    }

    private boolean isRegular(PrestimeCPUCCTNode n) {
        return !n.isThreadNode() && !n.isFiltered();
    }

    private void initSamples() throws IOException {
        LoadedSnapshot.SamplesInputStream stream = new LoadedSnapshot.SamplesInputStream(this.npssFile.getInputStream());
        int samplesGuess = (int)(this.npssFile.getSize() / 130L);
        ProgressHandle ph = ProgressHandle.createSystemHandle((String)"Computing snapshot samples", null);
        ph.start(samplesGuess);
        LoadedSnapshot.ThreadsSample s = stream.readSample();
        while (s != null) {
            ++this.samples;
            this.lastTimestamp = s.getTime();
            if (this.samples < samplesGuess) {
                ph.progress(this.samples);
            }
            s = stream.readSample();
        }
        ph.finish();
    }
}

