/*
 * Decompiled with CFR 0.152.
 */
package com.github.rzymek.opczip.reader.ordered;

import com.github.rzymek.opczip.reader.ordered.OrderedZipStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class DiskCacheOrderedZipStreamReader
extends OrderedZipStreamReader {
    private final File dir = Files.createTempDirectory(DiskCacheOrderedZipStreamReader.class.getSimpleName(), new FileAttribute[0]).toFile();

    @Override
    protected OutputStream getTempOutputStream(String name) throws FileNotFoundException {
        File file = new File(this.dir, name);
        file.deleteOnExit();
        return new FileOutputStream(file);
    }

    @Override
    protected InputStream getTempInputStream(String name) throws UncheckedIOException {
        try {
            final File file = new File(this.dir, name);
            return new FileInputStream(file){

                @Override
                public void close() throws IOException {
                    super.close();
                    file.delete();
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }
}

