/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.InputReader;
import org.netbeans.api.extexecution.base.input.InputReaderTask;
import org.netbeans.api.extexecution.base.input.InputReaders;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.openide.windows.InputOutput;

public final class WildflyOutputSupport {
    private static final Logger LOGGER = Logger.getLogger(WildflyOutputSupport.class.getName());
    private static final ExecutionDescriptor DESCRIPTOR = new ExecutionDescriptor().frontWindow(true).inputVisible(true);
    private static final Map<InstanceProperties, WildflyOutputSupport> INSTANCE_CACHE = new HashMap<InstanceProperties, WildflyOutputSupport>();
    private static final ExecutorService PROFILER_SERVICE = Executors.newCachedThreadPool();
    private static final ExecutorService LOG_FILE_SERVICE = Executors.newCachedThreadPool();
    private static final Pattern JBOSS_7_STARTED_ML = Pattern.compile(".*JBoss AS 7(\\..*)* \\d+ms .*");
    private static final Pattern WILDFLY_8_STARTED_ML = Pattern.compile(".*JBAS015874: WildFly 8(\\..*)* .* started in \\d+ms .*");
    private static final Pattern WILDFLY_8_STARTING_ML = Pattern.compile(".*JBAS015899: WildFly 8(\\..*)* .* starting");
    private static final Pattern WILDFLY_9_STARTED_ML = Pattern.compile(".*WFLYSRV0050: WildFly Full \\d+(\\..*)* .* started in \\d+ms .*");
    private static final Pattern WILDFLY_STARTING_ML = Pattern.compile(".*WFLYSRV0049: WildFly .* \\d+(\\..*)* .* starting");
    private static final Pattern WILDFLY_10_STARTED_ML = Pattern.compile(".*WFLYSRV0025: WildFly .* \\d+(\\..*)* .* started in \\d+ms .*");
    private static final Pattern EAP6_STARTED_ML = Pattern.compile(".*JBAS015874: JBoss EAP 6\\.[0-9]?.[0-9]?\\.GA .* \\d+ms .*");
    private static final Pattern EAP6_STARTING_ML = Pattern.compile(".*JBAS015899: JBoss EAP 6\\.[0-9]?.[0-9]?\\.GA .*");
    private static final Pattern EAP7_STARTED_ML = Pattern.compile(".*WFLYSRV0025: JBoss EAP 7\\.[0-9]?.[0-9]?\\.GA .* \\d+ms .*");
    private static final Pattern EAP7_STARTING_ML = Pattern.compile(".*WFLYSRV0049: JBoss EAP 7\\.[0-9]?.[0-9]?\\.GA .*");
    private final InstanceProperties props;
    private boolean started;
    private boolean failed;
    private Future<Integer> processTask;
    private Process process;
    private Future<?> profileCheckTask;
    private InputReaderTask fileTask;

    private WildflyOutputSupport(InstanceProperties props) {
        this.props = props;
    }

    public static synchronized WildflyOutputSupport getInstance(InstanceProperties props, boolean create) {
        WildflyOutputSupport instance = INSTANCE_CACHE.get(props);
        if (instance == null && create) {
            instance = new WildflyOutputSupport(props);
            INSTANCE_CACHE.put(props, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InputOutput io, final Process serverProcess, final boolean profiler) {
        this.reset();
        ExecutionDescriptor descriptor = DESCRIPTOR.inputOutput(io);
        descriptor = descriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new StartLineProcessor(profiler))});
            }
        });
        descriptor = descriptor.errProcessorFactory(new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new StartLineProcessor(profiler))});
            }
        });
        descriptor = descriptor.postExecution(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WildflyOutputSupport.this;
                synchronized (object) {
                    if (WildflyOutputSupport.this.profileCheckTask != null) {
                        WildflyOutputSupport.this.profileCheckTask.cancel(true);
                    }
                    WildflyOutputSupport.this.notifyAll();
                }
                object = WildflyOutputSupport.class;
                synchronized (WildflyOutputSupport.class) {
                    INSTANCE_CACHE.remove(WildflyOutputSupport.this.props);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        ExecutionService service = ExecutionService.newService((Callable)new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                return serverProcess;
            }
        }, (ExecutionDescriptor)descriptor, (String)this.props.getProperty("displayName"));
        Future localProcessTask = service.run();
        WildflyOutputSupport wildflyOutputSupport = this;
        synchronized (wildflyOutputSupport) {
            if (profiler) {
                this.profileCheckTask = PROFILER_SERVICE.submit(new ProfilerCheckTask());
            }
            this.processTask = localProcessTask;
            this.process = serverProcess;
        }
        this.failed = !this.isAlive(serverProcess);
    }

    private boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InputOutput io, File file) {
        InputReader reader;
        this.reset();
        try {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            in.skip(file.length());
            reader = InputReaders.forStream((InputStream)in, (Charset)Charset.defaultCharset());
        }
        catch (IOException ex) {
            reader = InputReaders.forFile((File)file, (Charset)Charset.defaultCharset());
        }
        InputReaderTask localFileTask = InputReaderTask.newTask((InputReader)reader, (InputProcessor)InputProcessors.printing((PrintWriter)io.getOut()));
        LOG_FILE_SERVICE.submit((Runnable)localFileTask);
        WildflyOutputSupport wildflyOutputSupport = this;
        synchronized (wildflyOutputSupport) {
            this.fileTask = localFileTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object;
        try {
            object = this;
            synchronized (object) {
                if (this.processTask != null) {
                    this.processTask.cancel(true);
                } else if (this.fileTask != null) {
                    this.fileTask.cancel();
                }
                if (this.profileCheckTask != null) {
                    this.profileCheckTask.cancel(true);
                }
                this.started = false;
                this.failed = false;
                this.processTask = null;
                this.process = null;
                this.profileCheckTask = null;
                this.fileTask = null;
            }
        }
        finally {
            object = WildflyOutputSupport.class;
            synchronized (WildflyOutputSupport.class) {
                INSTANCE_CACHE.remove(this.props);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    public boolean waitForStart(long timeout) throws TimeoutException, InterruptedException {
        WildflyOutputSupport wildflyOutputSupport = this;
        synchronized (wildflyOutputSupport) {
            if (this.processTask == null) {
                return this.fileTask != null;
                {
                }
            }
            while (!this.started && !this.failed) {
                this.wait(timeout);
                if (this.process == null || this.isAlive(this.process)) continue;
                this.failed = true;
                return false;
            }
            if (this.started) {
                return true;
            }
            if (this.failed) {
                return false;
            }
            if (this.profileCheckTask != null) {
                this.profileCheckTask.cancel(true);
            }
            throw new TimeoutException("Expired timeout " + timeout + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop(long timeout) throws TimeoutException, InterruptedException, ExecutionException {
        Future<Integer> localProcessTask;
        WildflyOutputSupport wildflyOutputSupport = this;
        synchronized (wildflyOutputSupport) {
            localProcessTask = this.processTask;
        }
        if (localProcessTask == null) {
            return;
        }
        localProcessTask.get(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process getProcess() {
        WildflyOutputSupport wildflyOutputSupport = this;
        synchronized (wildflyOutputSupport) {
            return this.process;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        WildflyOutputSupport wildflyOutputSupport = this;
        synchronized (wildflyOutputSupport) {
            if (this.fileTask != null) {
                this.fileTask.cancel();
            }
            if (this.started) {
                LOGGER.log(Level.INFO, "Instance {0} started again without proper stop", this.props.getProperty("displayName"));
            }
            this.started = false;
            this.failed = false;
            this.processTask = null;
            this.process = null;
            this.profileCheckTask = null;
            this.fileTask = null;
        }
    }

    private static boolean isProfilerReady() {
        int state = ProfilerSupport.getState();
        return state == 2 || state == 3 || state == 4;
    }

    private static boolean isProfilerInactive() {
        return ProfilerSupport.getState() == 0;
    }

    private class ProfilerCheckTask
    implements Runnable {
        private ProfilerCheckTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (WildflyOutputSupport.isProfilerReady()) {
                    WildflyOutputSupport wildflyOutputSupport = WildflyOutputSupport.this;
                    synchronized (wildflyOutputSupport) {
                        WildflyOutputSupport.this.started = true;
                        WildflyOutputSupport.this.notifyAll();
                        break;
                    }
                }
                if (WildflyOutputSupport.isProfilerInactive()) {
                    WildflyOutputSupport wildflyOutputSupport = WildflyOutputSupport.this;
                    synchronized (wildflyOutputSupport) {
                        WildflyOutputSupport.this.failed = true;
                        WildflyOutputSupport.this.notifyAll();
                        break;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    break;
                }
            }
        }
    }

    private class StartLineProcessor
    implements LineProcessor {
        private final boolean profiler;
        private boolean check = true;

        public StartLineProcessor(boolean profiler) {
            this.profiler = profiler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            if (!this.check) {
                return;
            }
            WildflyOutputSupport wildflyOutputSupport = WildflyOutputSupport.this;
            synchronized (wildflyOutputSupport) {
                if (WildflyOutputSupport.this.started) {
                    this.check = false;
                    return;
                }
            }
            if (this.profiler) {
                if (WildflyOutputSupport.isProfilerReady()) {
                    wildflyOutputSupport = WildflyOutputSupport.this;
                    synchronized (wildflyOutputSupport) {
                        WildflyOutputSupport.this.started = true;
                        WildflyOutputSupport.this.notifyAll();
                    }
                    this.check = false;
                } else if (WildflyOutputSupport.isProfilerInactive()) {
                    wildflyOutputSupport = WildflyOutputSupport.this;
                    synchronized (wildflyOutputSupport) {
                        WildflyOutputSupport.this.failed = true;
                        WildflyOutputSupport.this.notifyAll();
                    }
                    this.check = false;
                }
            }
            if (this.isStarting(line)) {
                LOGGER.log(Level.FINER, "STARTING message fired");
            } else if (this.isStarted(line)) {
                LOGGER.log(Level.FINER, "STARTED message fired");
                wildflyOutputSupport = WildflyOutputSupport.this;
                synchronized (wildflyOutputSupport) {
                    WildflyOutputSupport.this.started = true;
                    WildflyOutputSupport.this.notifyAll();
                }
                this.check = false;
            } else if (line.contains("Shutdown complete")) {
                wildflyOutputSupport = WildflyOutputSupport.this;
                synchronized (wildflyOutputSupport) {
                    WildflyOutputSupport.this.failed = true;
                    WildflyOutputSupport.this.notifyAll();
                }
                this.check = false;
            }
        }

        private boolean isStarting(String line) {
            return line.contains("Starting JBoss (MX MicroKernel)") || line.contains("Starting JBoss (Microcontainer)") || line.contains("Starting JBossAS") || WILDFLY_8_STARTING_ML.matcher(line).matches() || WILDFLY_STARTING_ML.matcher(line).matches() || EAP6_STARTING_ML.matcher(line).matches() || EAP7_STARTING_ML.matcher(line).matches();
        }

        private boolean isStarted(String line) {
            return (line.contains("JBoss (MX MicroKernel)") || line.contains("JBoss (Microcontainer)") || line.contains("JBossAS") || line.contains("JBoss AS")) && line.contains("Started in") || line.contains("started in") || line.contains("started (with errors) in") || JBOSS_7_STARTED_ML.matcher(line).matches() || WILDFLY_8_STARTED_ML.matcher(line).matches() || WILDFLY_9_STARTED_ML.matcher(line).matches() || WILDFLY_10_STARTED_ML.matcher(line).matches() || EAP6_STARTED_ML.matcher(line).matches() || EAP7_STARTED_ML.matcher(line).matches();
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

