/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTagDefaultsRequest
extends BmcRequest<Void> {
    private String page;
    private Integer limit;
    private String id;
    private String compartmentId;
    private String tagDefinitionId;
    private TagDefaultSummary.LifecycleState lifecycleState;

    @ConstructorProperties(value={"page", "limit", "id", "compartmentId", "tagDefinitionId", "lifecycleState"})
    ListTagDefaultsRequest(String page, Integer limit, String id, String compartmentId, String tagDefinitionId, TagDefaultSummary.LifecycleState lifecycleState) {
        this.page = page;
        this.limit = limit;
        this.id = id;
        this.compartmentId = compartmentId;
        this.tagDefinitionId = tagDefinitionId;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().page(this.page).limit(this.limit).id(this.id).compartmentId(this.compartmentId).tagDefinitionId(this.tagDefinitionId).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "ListTagDefaultsRequest(super=" + super.toString() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", tagDefinitionId=" + this.getTagDefinitionId() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTagDefaultsRequest)) {
            return false;
        }
        ListTagDefaultsRequest other = (ListTagDefaultsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$tagDefinitionId = this.getTagDefinitionId();
        String other$tagDefinitionId = other.getTagDefinitionId();
        if (this$tagDefinitionId == null ? other$tagDefinitionId != null : !this$tagDefinitionId.equals(other$tagDefinitionId)) {
            return false;
        }
        TagDefaultSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        TagDefaultSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListTagDefaultsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $tagDefinitionId = this.getTagDefinitionId();
        result = result * 59 + ($tagDefinitionId == null ? 43 : $tagDefinitionId.hashCode());
        TagDefaultSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public TagDefaultSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagDefaultsRequest, Void> {
        private String page;
        private Integer limit;
        private String id;
        private String compartmentId;
        private String tagDefinitionId;
        private TagDefaultSummary.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagDefaultsRequest o) {
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.id(o.getId());
            this.compartmentId(o.getCompartmentId());
            this.tagDefinitionId(o.getTagDefinitionId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagDefaultsRequest build() {
            ListTagDefaultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder tagDefinitionId(String tagDefinitionId) {
            this.tagDefinitionId = tagDefinitionId;
            return this;
        }

        public Builder lifecycleState(TagDefaultSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListTagDefaultsRequest buildWithoutInvocationCallback() {
            return new ListTagDefaultsRequest(this.page, this.limit, this.id, this.compartmentId, this.tagDefinitionId, this.lifecycleState);
        }

        public String toString() {
            return "ListTagDefaultsRequest.Builder(page=" + this.page + ", limit=" + this.limit + ", id=" + this.id + ", compartmentId=" + this.compartmentId + ", tagDefinitionId=" + this.tagDefinitionId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

