/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LSResourceResolverImpl
implements LSResourceResolver {
    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURIStr) {
        if (systemId == null || systemId.trim().length() <= 0) {
            return null;
        }
        URI systemIdURI = null;
        try {
            systemIdURI = new URI(systemId);
        }
        catch (URISyntaxException ex) {
            return null;
        }
        FileObject baseFO = null;
        CatalogModel depRez = null;
        try {
            baseFO = this.getFileObject(baseURIStr);
            depRez = this.getResolver(baseFO);
        }
        catch (CatalogModelException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        if (depRez == null) {
            return null;
        }
        ModelSource baseMS = null;
        try {
            baseMS = Utilities.createModelSource(baseFO, false);
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
        ModelSource resultMS = null;
        try {
            resultMS = depRez.getModelSource(systemIdURI, baseMS);
        }
        catch (CatalogModelException ex) {
            return null;
        }
        if (resultMS == null) {
            return null;
        }
        FileObject resultFob = (FileObject)resultMS.getLookup().lookup(FileObject.class);
        if (resultFob == null) {
            return null;
        }
        File resultFile = FileUtil.toFile((FileObject)resultFob);
        if (resultFile == null) {
            return null;
        }
        URI resultURI = resultFile.toURI();
        DOMImplementation domImpl = null;
        try {
            domImpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
        DOMImplementationLS dols = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        LSInput lsi = dols.createLSInput();
        InputStream is = this.getFileStreamFromDocument(resultFile);
        if (is != null) {
            lsi.setByteStream(is);
        }
        lsi.setSystemId(resultURI.toString());
        return lsi;
    }

    private FileObject getFileObject(String baseURIStr) throws IOException {
        if (baseURIStr == null) {
            return null;
        }
        URI baseURI = null;
        try {
            baseURI = new URI(baseURIStr);
        }
        catch (URISyntaxException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        if (baseURI.isAbsolute() && baseURI.getScheme().equalsIgnoreCase("file")) {
            File baseFile = null;
            try {
                baseFile = new File(baseURI);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            baseFile = FileUtil.normalizeFile((File)baseFile);
            FileObject baseFileObject = null;
            try {
                baseFileObject = FileUtil.toFileObject((File)baseFile);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            return baseFileObject;
        }
        return null;
    }

    private CatalogModel getResolver(FileObject baseFileObject) throws CatalogModelException {
        if (baseFileObject != null) {
            return CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(baseFileObject);
        }
        return null;
    }

    private InputStream getFileStreamFromDocument(File resultFile) {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)resultFile));
        if (fo != null) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                return null;
            }
            if (dobj.isModified()) {
                EditorCookie thisDocumentEditorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (thisDocumentEditorCookie == null) {
                    return null;
                }
                StyledDocument sd = null;
                try {
                    sd = thisDocumentEditorCookie.openDocument();
                }
                catch (IOException ex) {
                    return null;
                }
                if (sd == null) {
                    return null;
                }
                String docContent = null;
                try {
                    docContent = sd.getText(0, sd.getLength());
                }
                catch (BadLocationException ex) {
                    return null;
                }
                if (docContent == null) {
                    return null;
                }
                BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(docContent.getBytes()));
                return bis;
            }
            return null;
        }
        return null;
    }
}

