/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class BlockStatement
extends Statement {
    private final Block block;

    public BlockStatement(Block block) {
        this(block.getFirstStatementLineNumber(), block);
    }

    public BlockStatement(int n, Block block) {
        super(n, block.getToken(), block.getFinish());
        this.block = block;
    }

    private BlockStatement(BlockStatement blockStatement, Block block) {
        super(blockStatement);
        this.block = block;
    }

    @Override
    public boolean isTerminal() {
        return this.block.isTerminal();
    }

    public boolean isSynthetic() {
        return this.block.isSynthetic();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterBlockStatement(this)) {
            return nodeVisitor.leaveBlockStatement(this.setBlock((Block)this.block.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterBlockStatement(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        this.block.toString(stringBuilder, bl);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockStatement setBlock(Block block) {
        if (this.block == block) {
            return this;
        }
        return new BlockStatement(this, block);
    }
}

