/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.nbimpl.actions.Bundle;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;
import org.netbeans.modules.profiler.nbimpl.javac.JavacClassInfo;
import org.netbeans.modules.profiler.nbimpl.javac.JavacMethodInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ParsingUtils;
import org.netbeans.modules.profiler.nbimpl.javac.ScanSensitiveTask;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public final class ProfileElementNavigatorAction
extends NodeAction {
    private String name = Bundle.ProfileElementNavigatorAction_Name();

    public String getName() {
        return this.name;
    }

    protected boolean enable(Node[] activatedNodes) {
        ElementKind kind;
        ElementHandle eh = ProfileElementNavigatorAction.getHandle(activatedNodes);
        ElementKind elementKind = kind = eh == null ? null : eh.getKind();
        if (ElementKind.METHOD.equals((Object)kind) || ElementKind.CONSTRUCTOR.equals((Object)kind)) {
            this.name = Bundle.ProfileMethodEditorAction_Name();
            return true;
        }
        if (ElementKind.CLASS.equals((Object)kind)) {
            this.name = Bundle.ProfileClassEditorAction_Name();
            return true;
        }
        this.name = Bundle.ProfileElementNavigatorAction_Name();
        return false;
    }

    protected void performAction(final Node[] nodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    ElementHandle eh = ProfileElementNavigatorAction.getHandle(nodes);
                    if (eh == null) {
                        return;
                    }
                    FileObject fo = (FileObject)nodes[0].getLookup().lookup(FileObject.class);
                    if (fo == null) {
                        return;
                    }
                    Lookup.Provider project = ProjectUtilities.getProject((FileObject)fo);
                    if (project == null) {
                        return;
                    }
                    JavaSource src = ElementUtilitiesEx.getSources((Project)project);
                    if (src == null) {
                        return;
                    }
                    Object sourceInfo = null;
                    ElementKind kind = eh.getKind();
                    if (ElementKind.METHOD.equals((Object)kind) || ElementKind.CONSTRUCTOR.equals((Object)kind)) {
                        sourceInfo = ProfileElementNavigatorAction.getMethod(eh, src.getClasspathInfo());
                    } else if (ElementKind.CLASS.equals((Object)kind)) {
                        sourceInfo = new JavacClassInfo((ElementHandle<TypeElement>)eh, src.getClasspathInfo());
                    }
                    if (sourceInfo != null) {
                        ProfilerSession.findAndConfigure((Lookup)Lookups.fixed((Object[])new Object[]{sourceInfo}), (Lookup.Provider)project, (String)ProfileElementNavigatorAction.this.getName());
                    }
                }
                catch (Exception ex) {
                    ProfilerDialogs.displayWarning((String)Bundle.ProfileElementNavigatorAction_ProblemProfilingElement());
                }
            }
        });
    }

    private static ElementHandle getHandle(Node[] nodes) {
        if (nodes.length != 1) {
            return null;
        }
        TreePathHandle tph = (TreePathHandle)nodes[0].getLookup().lookup(TreePathHandle.class);
        return tph == null ? null : tph.getElementHandle();
    }

    private static JavacMethodInfo getMethod(final ElementHandle eh, ClasspathInfo ci) {
        final JavacMethodInfo[] info = new JavacMethodInfo[1];
        ParsingUtils.invokeScanSensitiveTask(ci, new ScanSensitiveTask<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                Element el = eh.resolve((CompilationInfo)cc);
                if (el instanceof ExecutableElement) {
                    info[0] = new JavacMethodInfo((ExecutableElement)el, cc);
                }
            }

            @Override
            public boolean shouldRetry() {
                return info[0] == null;
            }
        });
        return info[0];
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

