/*
 * Decompiled with CFR 0.152.
 */
package com.unityjdbc.sourcebuilder;

import com.unityjdbc.sourcebuilder.ExtractStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JTextArea;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceTable;
import unity.jdbc.UnityDriver;
import unity.mapping.Database;
import unity.mapping.DatabaseMapping;
import unity.util.StringFunc;

public class AnnotatedExtractor {
    protected DatabaseMetaData dmd;
    protected String dbName;
    protected AnnotatedSourceDatabase db;
    protected Connection con;
    protected JTextArea outputBox = null;
    protected String dbProduct;
    protected String dbVersion;
    protected String driver;
    protected String url;
    protected char dbdelimitChar;
    public static final char unitydelimitChar = '\"';
    protected ExtractStatus status;

    public AnnotatedExtractor() {
        this.status = new ExtractStatus();
    }

    public AnnotatedExtractor(ExtractStatus extractStatus) {
        this.status = extractStatus;
    }

    public void setOutputArea(JTextArea jTextArea) {
        this.outputBox = jTextArea;
    }

    public AnnotatedSourceDatabase extract(String string, String string2, String string3, String string4, Properties properties, String string5, String string6, String string7, String string8, String string9, int n) throws SQLException {
        this.outputMessage("Registering driver: " + string);
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(UnityDriver.i18n.getString("AnnotatedExtractor.unableFindDriver") + string + UnityDriver.i18n.getString("Exception") + classNotFoundException);
        }
        this.outputMessage("Connecting to database...");
        Connection connection = properties != null ? DriverManager.getConnection(string2, properties) : (string3 != null && !string3.equals("") ? DriverManager.getConnection(string2, string3, string4) : DriverManager.getConnection(string2));
        this.outputMessage("Connection successful.");
        AnnotatedSourceDatabase annotatedSourceDatabase = this.extract(string, string2, string3, string4, properties, string5, string6, string7, string8, n, connection, null, string9);
        connection.close();
        return annotatedSourceDatabase;
    }

    public AnnotatedSourceDatabase extract(String string, String string2, String string3, String string4, Properties properties, String string5, String string6, String string7, String string8, int n, Connection connection, ClassLoader classLoader, String string9) throws SQLException {
        String string10;
        int n2;
        int n3;
        Connection connection2 = connection;
        try {
            Class.forName("unity.jdbc.UnityDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(UnityDriver.i18n.getString("AnnotatedExtractor.unableFindUnityDriver"));
        }
        this.dmd = connection.getMetaData();
        this.dbdelimitChar = this.dmd.getIdentifierQuoteString().charAt(0);
        this.dbName = connection.getCatalog();
        if (this.dbName != null && (n3 = this.dbName.lastIndexOf("\\")) > 0) {
            this.dbName = this.dbName.substring(n3 + 1);
        }
        this.dbName = StringFunc.delimitName(this.dbName, '\"');
        String string11 = string5;
        if (string11 == null) {
            string11 = this.dbName;
        }
        this.dbProduct = this.dmd.getDatabaseProductName();
        this.dbVersion = this.dmd.getDatabaseProductVersion();
        String string12 = string2;
        this.driver = this.dmd.getDriverName();
        this.db = new AnnotatedSourceDatabase(string11, this.dbName, this.dbProduct, this.dbVersion, string12, this.driver, this.dbdelimitChar);
        this.db.setTableInclude(string7);
        this.db.setTableExclude(string8);
        this.db.setSchema(string6);
        this.db.setJavaDriverClassName(string);
        this.db.setUserId(string3);
        this.db.setPassword(string4);
        Database database = DatabaseMapping.getDatabase(this.db);
        if (database == null) {
            n2 = 1000;
            string10 = "Unknown.  Using common SQL dialect.";
            database = DatabaseMapping.getDatabase(n2);
        } else {
            n2 = database.getDatabaseId();
            string10 = database.getProductName();
        }
        this.outputMessage("\nAuto-generated database id: " + n2 + " Database name: " + string10 + "\n");
        this.db.setDatabaseId(n2);
        boolean bl = false;
        if (this.dbProduct.indexOf("CCESS") > -1) {
            bl = true;
        }
        if (this.dbProduct.indexOf("XCEL") > -1) {
            bl = true;
        }
        if (this.dbProduct.indexOf("TEXT") > -1) {
            bl = true;
        }
        HashMap<String, SourceTable> hashMap = !bl ? this.createAnnotatedSourceTablesAll(this.db, database, connection, string6, string7, string8, n, connection2, string9) : this.createAnnotatedSourceTablesAccess(this.db, database, connection, string6, string7, string8, n, connection2);
        this.db.setSourceTables(hashMap);
        return this.db;
    }

    private void outputMessage(String string) {
        if (this.outputBox == null) {
            System.out.println(string);
        } else {
            this.outputBox.append(string + '\n');
        }
        this.status.addMessage(string);
    }

    public HashMap<String, SourceTable> createAnnotatedSourceTablesAll(AnnotatedSourceDatabase annotatedSourceDatabase, Database database, Connection connection, String string, String string2, String string3, int n, Connection connection2, String string4) throws SQLException {
        if (string4 == null) {
            return this.createAnnotatedSourceTables(annotatedSourceDatabase, database, connection, string, string2, string3, n, connection2, null);
        }
        HashMap<String, SourceTable> hashMap = new HashMap<String, SourceTable>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getCatalogs();
        while (resultSet.next()) {
            String string5 = resultSet.getString(1);
            if (!string5.matches(string4)) continue;
            hashMap.putAll(this.createAnnotatedSourceTables(annotatedSourceDatabase, database, connection, string, string2, string3, n, connection2, string5));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, SourceTable> createAnnotatedSourceTables(AnnotatedSourceDatabase annotatedSourceDatabase, Database database, Connection connection, String string, String string2, String string3, int n, Connection connection2, String string4) throws SQLException {
        Object object;
        String string5;
        String string6;
        HashMap<String, SourceTable> hashMap = new HashMap<String, SourceTable>();
        AnnotatedSourceTable annotatedSourceTable = null;
        String[] stringArray = new String[]{"TABLE", "VIEW"};
        String string7 = string2;
        if (string7 == null || string7.equals("")) {
            string7 = "%";
        }
        boolean bl = string3 != null && !string3.equals("");
        ResultSet resultSet = null;
        try {
            resultSet = this.dmd.getTables(string4, string, string7, stringArray);
        }
        catch (SQLException sQLException) {
            this.outputMessage(sQLException.toString());
            return hashMap;
        }
        int n2 = 0;
        while (resultSet.next()) {
            string6 = resultSet.getString(3);
            if (bl && string6.matches(string3)) continue;
            string5 = resultSet.getString(2);
            if (string5 != null && string5.equalsIgnoreCase("public")) {
                string5 = null;
            }
            if (database.isSystemSchema(string5)) continue;
            ++n2;
        }
        this.status.setTotalTables(n2);
        n2 = 0;
        resultSet = this.dmd.getTables(string4, string, string7, stringArray);
        while (resultSet.next()) {
            block20: {
                Statement statement;
                string6 = resultSet.getString(3);
                if (bl && string6.matches(string3)) continue;
                string5 = resultSet.getString(2);
                if (string5 != null && string5.equalsIgnoreCase("public")) {
                    string5 = null;
                }
                if (database.isSystemSchema(string5)) continue;
                this.status.setProcessedTables(++n2);
                String string8 = resultSet.getString(1);
                String string9 = resultSet.getString(5);
                this.outputMessage("Table: " + string6 + "  Schema: " + string5 + "  Catalog: " + string8);
                object = StringFunc.delimitName(string5, '\"');
                String string10 = StringFunc.delimitName(string6, '\"');
                String string11 = StringFunc.delimitName(string8, '\"');
                HashMap<String, SourceField> hashMap2 = this.createFields(string8, string5, string6);
                AnnotatedSourceKey annotatedSourceKey = this.createPrimaryKey(string8, string5, string6, hashMap2);
                annotatedSourceTable = new AnnotatedSourceTable(string11, (String)object, string10, string9, hashMap2, annotatedSourceKey);
                annotatedSourceTable.setParentDatabase(this.db);
                this.dbName = this.db.getDatabaseName();
                annotatedSourceTable.setSemanticTableName(annotatedSourceTable.getFullName());
                if (annotatedSourceKey != null) {
                    annotatedSourceKey.setTable(annotatedSourceTable);
                }
                ArrayList<SourceForeignKey> arrayList = this.createForeignKeys(this.dbName, string8, string5, string6, hashMap2, annotatedSourceTable);
                annotatedSourceTable.setForeignKeys(arrayList);
                hashMap.put(annotatedSourceTable.getFullName(), annotatedSourceTable);
                AnnotatedSourceField[] annotatedSourceFieldArray = new AnnotatedSourceField[hashMap2.size()];
                boolean bl2 = n == 2;
                boolean bl3 = n >= 1;
                if (!bl3) continue;
                StringBuffer stringBuffer = new StringBuffer(500);
                int n3 = 0;
                stringBuffer.append("SELECT COUNT(*)");
                for (AnnotatedSourceField annotatedSourceField : hashMap2.values()) {
                    if (annotatedSourceField.isBlob() || !bl2) continue;
                    stringBuffer.append(",count(distinct " + annotatedSourceField.getSQLColumnName() + ')');
                    annotatedSourceFieldArray[n3++] = annotatedSourceField;
                }
                stringBuffer.append("\nFROM " + annotatedSourceTable.getSQLTableNameWithSchema());
                Statement statement2 = null;
                try {
                    statement = connection2.createStatement();
                    this.outputMessage("   " + UnityDriver.i18n.getString("AnnotatedExtractor.computeStats"));
                    this.outputMessage(stringBuffer.toString());
                    ResultSet resultSet2 = statement.executeQuery(stringBuffer.toString());
                    if (resultSet2.next()) {
                        if (annotatedSourceTable != null) {
                            annotatedSourceTable.setNumTuples(resultSet2.getInt(1));
                        }
                        for (int i = 0; i < n3; ++i) {
                            annotatedSourceFieldArray[i].setNumDistinctValues(resultSet2.getInt(i + 2));
                        }
                    }
                    if (statement == null) break block20;
                }
                catch (SQLException sQLException) {
                    this.outputMessage("   " + UnityDriver.i18n.getString("AnnotatedExtractor.errorStats") + sQLException);
                    break block20;
                }
                statement.close();
                break block20;
                finally {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
            }
            this.outputMessage(UnityDriver.i18n.getString("AnnotatedExtractor.doneTable") + string6 + '\n');
        }
        object = hashMap.values().iterator();
        while (true) {
            if (!object.hasNext()) {
                if (resultSet == null) return hashMap;
                resultSet.close();
                return hashMap;
            }
            this.fillForeignKeysAndCreateJoins((AnnotatedSourceTable)object.next(), hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, SourceTable> createAnnotatedSourceTablesAccess(AnnotatedSourceDatabase annotatedSourceDatabase, Database database, Connection connection, String string, String string2, String string3, int n, Connection connection2) throws SQLException {
        Object object;
        HashMap<String, SourceTable> hashMap = new HashMap<String, SourceTable>();
        AnnotatedSourceTable annotatedSourceTable = null;
        String[] stringArray = null;
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = "%";
        }
        boolean bl = string3 != null && !string3.equals("");
        ResultSet resultSet = this.dmd.getTables(null, null, "%", stringArray);
        while (resultSet.next()) {
            Object object2;
            object = resultSet.getString(3);
            String string5 = StringFunc.delimitName((String)object, '\"');
            if (bl && string5.matches(string3)) continue;
            String string6 = StringFunc.delimitName(resultSet.getString(2), '\"');
            if (string6 != null && string6.equalsIgnoreCase("public")) {
                string6 = null;
            }
            if (database.isSystemSchema(string6)) continue;
            String string7 = StringFunc.delimitName(resultSet.getString(1), '\"');
            String string8 = resultSet.getString(5);
            String string9 = StringFunc.delimitName(string5, this.dbdelimitChar);
            this.outputMessage("Processing Table: " + string9 + "  Schema: " + string6 + "  Catalog: " + string7);
            HashMap<String, SourceField> hashMap2 = this.createFields(string7, string6, (String)object);
            AnnotatedSourceKey annotatedSourceKey = this.createPrimaryKeyAccess(string5, hashMap2);
            annotatedSourceTable = new AnnotatedSourceTable(string7, string6, string5, string8, hashMap2, annotatedSourceKey);
            annotatedSourceTable.setParentDatabase(this.db);
            if (string6 != null && !string6.equals("")) {
                annotatedSourceTable.setSemanticTableName(this.dbName + '.' + string6 + '.' + string5);
            } else {
                annotatedSourceTable.setSemanticTableName(this.dbName + '.' + string5);
            }
            hashMap.put(string5, annotatedSourceTable);
            StringBuffer stringBuffer = new StringBuffer(500);
            int n2 = 0;
            AnnotatedSourceField[] annotatedSourceFieldArray = new AnnotatedSourceField[hashMap2.size()];
            if (this.dbVersion.indexOf("3.50") >= 0) {
                stringBuffer.append("SELECT count(*)");
                for (AnnotatedSourceField annotatedSourceField : hashMap2.values()) {
                    if (annotatedSourceField.isBlob()) continue;
                    stringBuffer.append(",count(*)");
                    annotatedSourceFieldArray[n2++] = annotatedSourceField;
                }
                stringBuffer.append("\nFROM " + annotatedSourceTable.getSQLTableNameWithSchema());
            } else {
                stringBuffer.append("SELECT * FROM");
                object2 = annotatedSourceTable.getSQLTableNameWithSchema();
                stringBuffer.append(" (SELECT COUNT(*) FROM (SELECT * FROM " + (String)object2 + ") AS C) AS X0");
                for (AnnotatedSourceField annotatedSourceField : hashMap2.values()) {
                    if (annotatedSourceField.isBlob()) continue;
                    stringBuffer.append(",(SELECT COUNT(*) FROM (SELECT DISTINCT " + annotatedSourceField.getSQLColumnName() + " FROM " + (String)object2 + ") AS T" + n2 + ") AS Z" + n2);
                    annotatedSourceFieldArray[n2++] = annotatedSourceField;
                }
            }
            object2 = null;
            try {
                object2 = connection2.createStatement();
                this.outputMessage("   " + UnityDriver.i18n.getString("AnnotatedExtractor.computeStats"));
                this.outputMessage(stringBuffer.toString());
                ResultSet resultSet2 = object2.executeQuery(stringBuffer.toString());
                if (resultSet2.next()) {
                    if (annotatedSourceTable != null) {
                        annotatedSourceTable.setNumTuples(resultSet2.getInt(1));
                    }
                    for (int i = 0; i < n2; ++i) {
                        annotatedSourceFieldArray[i].setNumDistinctValues(resultSet2.getInt(i + 2));
                    }
                }
            }
            catch (SQLException sQLException) {
                this.outputMessage("   " + UnityDriver.i18n.getString("AnnotatedExtractor.errorStats") + sQLException);
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
            this.outputMessage(UnityDriver.i18n.getString("AnnotatedExtractor.doneTable") + string5 + '\n');
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            this.fillForeignKeysAndCreateJoins((AnnotatedSourceTable)object.next(), hashMap);
        }
        if (resultSet != null) {
            resultSet.close();
        }
        return hashMap;
    }

    public HashMap<String, SourceField> createFields(String string, String string2, String string3) throws SQLException {
        HashMap<String, SourceField> hashMap = new HashMap<String, SourceField>();
        ResultSet resultSet = this.dmd.getColumns(string, string2, string3, "%");
        while (resultSet.next()) {
            String string4 = StringFunc.delimitName(resultSet.getString(1), '\"');
            String string5 = StringFunc.delimitName(resultSet.getString(2), '\"');
            String string6 = StringFunc.delimitName(resultSet.getString(3), '\"');
            String string7 = StringFunc.delimitName(resultSet.getString(4), '\"');
            int n = resultSet.getInt(5);
            String string8 = resultSet.getString(6);
            int n2 = resultSet.getInt(7);
            int n3 = resultSet.getInt(9);
            int n4 = resultSet.getInt(10);
            int n5 = resultSet.getInt(11);
            String string9 = resultSet.getString(12);
            String string10 = resultSet.getString(13);
            int n6 = resultSet.getInt(16);
            int n7 = resultSet.getInt(17);
            String string11 = resultSet.getString(18);
            AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField(string4, string5, string6, string7, n, string8, n2, n3, n4, n5, string9, string10, n6, n7, string11);
            hashMap.put(StringFunc.identifierHashKey(string7), annotatedSourceField);
        }
        resultSet.close();
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotatedSourceKey createPrimaryKey(String string, String string2, String string3, HashMap<String, SourceField> hashMap) throws SQLException {
        AnnotatedSourceKey annotatedSourceKey = null;
        ResultSet resultSet = null;
        try {
            resultSet = this.dmd.getPrimaryKeys(string, string2, string3);
            String string4 = "";
            ArrayList<SourceField> arrayList = new ArrayList<SourceField>();
            while (resultSet.next()) {
                String string5 = resultSet.getString(4).trim();
                String string6 = resultSet.getString(6);
                string4 = string6 != null && string4.length() < 1 ? string6 : (string4.equals("") ? "PK_" + string3 + '_' : string4 + '_' + string5);
                arrayList.add(hashMap.get(StringFunc.identifierHashKey(string5)));
            }
            annotatedSourceKey = new AnnotatedSourceKey(arrayList, 1, string4);
        }
        catch (SQLException sQLException) {
            this.outputMessage(UnityDriver.i18n.getString("AnnotatedExtractor.PKError") + sQLException);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return annotatedSourceKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SourceForeignKey> createForeignKeys(String string, String string2, String string3, String string4, HashMap<String, SourceField> hashMap, AnnotatedSourceTable annotatedSourceTable) throws SQLException {
        ArrayList<SourceForeignKey> arrayList = new ArrayList<SourceForeignKey>();
        ResultSet resultSet = null;
        try {
            String string5;
            resultSet = this.dmd.getImportedKeys(string2, string3, string4);
            ArrayList<SourceField> arrayList2 = new ArrayList<SourceField>();
            String string6 = "";
            String string7 = "";
            String string8 = "";
            ArrayList<String> arrayList3 = new ArrayList<String>();
            boolean bl = true;
            while (resultSet.next()) {
                Object object;
                string8 = resultSet.getString(3);
                if (string7.equals(string8 = StringFunc.delimitName(string8, '\"'))) {
                    string5 = resultSet.getString(8);
                    string5 = StringFunc.delimitName(string5, '\"');
                    arrayList2.add(hashMap.get(StringFunc.identifierHashKey(string5)));
                    object = resultSet.getString(4);
                    object = StringFunc.delimitName((String)object, '\"');
                    arrayList3.add((String)object);
                    continue;
                }
                if (!bl) {
                    string5 = string + "_" + string2 + '.' + string3 + '.' + string7;
                    arrayList.add(new AnnotatedSourceForeignKey(annotatedSourceTable, arrayList2, arrayList3, string6, string5));
                    arrayList2 = new ArrayList();
                    string6 = "";
                    string7 = "";
                    arrayList3 = new ArrayList();
                }
                bl = false;
                string5 = resultSet.getString(8);
                if ((string5 = StringFunc.delimitName(string5, '\"')) == null) continue;
                object = hashMap.get(StringFunc.identifierHashKey(string5));
                if (object == null) {
                    throw new SQLException(UnityDriver.i18n.getString("AnnotatedExtractor.errorFindField") + string5);
                }
                arrayList2.add(hashMap.get(StringFunc.identifierHashKey(string5)));
                string6 = resultSet.getString(12);
                if (string6 != null) {
                    string6.trim();
                }
                string7 = resultSet.getString(3);
                string7 = StringFunc.delimitName(string7, '\"');
                String string9 = resultSet.getString(4);
                if ((string9 = StringFunc.delimitName(string9, '\"')) == null) continue;
                arrayList3.add(string9);
            }
            if (arrayList2.size() > 0) {
                string5 = string + "_" + string2 + '.' + string3 + '.' + string7;
                arrayList.add(new AnnotatedSourceForeignKey(annotatedSourceTable, arrayList2, arrayList3, string6, string5));
            }
        }
        catch (SQLException sQLException) {
            this.outputMessage(UnityDriver.i18n.getString("AnnotatedExtractor.errorFK") + sQLException);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return arrayList;
    }

    private void fillForeignKeysAndCreateJoins(AnnotatedSourceTable annotatedSourceTable, HashMap<String, SourceTable> hashMap) {
        ArrayList<SourceForeignKey> arrayList = annotatedSourceTable.getForeignKeys();
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnotatedSourceForeignKey annotatedSourceForeignKey = (AnnotatedSourceForeignKey)arrayList.get(i);
            String string = annotatedSourceForeignKey.getToTableName();
            ArrayList<String> arrayList2 = annotatedSourceForeignKey.getFieldNames();
            AnnotatedSourceTable annotatedSourceTable2 = (AnnotatedSourceTable)hashMap.get(string);
            if (annotatedSourceTable2 == null) continue;
            annotatedSourceForeignKey.setToSourceTable(annotatedSourceTable2);
            annotatedSourceForeignKey.setToKey(annotatedSourceTable2.getPrimaryKey());
            ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>();
            for (int j = 0; j < arrayList2.size(); ++j) {
                arrayList3.add(annotatedSourceTable2.getField(arrayList2.get(j)));
            }
            String string2 = annotatedSourceTable.getTableName() + "->" + annotatedSourceTable2.getTableName();
            String string3 = annotatedSourceTable2.getTableName() + "->" + annotatedSourceTable.getTableName();
            AnnotatedSourceJoin annotatedSourceJoin = new AnnotatedSourceJoin(annotatedSourceForeignKey, annotatedSourceTable2.getPrimaryKey(), string2, 3);
            AnnotatedSourceJoin annotatedSourceJoin2 = new AnnotatedSourceJoin(annotatedSourceTable2.getPrimaryKey(), annotatedSourceForeignKey, string3, 2);
            annotatedSourceJoin.setReverseJoin(annotatedSourceJoin2);
            annotatedSourceTable.addJoin(annotatedSourceJoin);
            annotatedSourceJoin2.setReverseJoin(annotatedSourceJoin);
            annotatedSourceTable2.addJoin(annotatedSourceJoin2);
        }
    }

    public AnnotatedSourceKey createPrimaryKeyAccess(String string, HashMap<String, SourceField> hashMap) throws SQLException {
        Object object;
        String string2 = null;
        String string3 = null;
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>();
        ResultSet resultSet = this.dmd.getIndexInfo(null, null, string, true, true);
        while (resultSet.next()) {
            object = resultSet.getString(6);
            if (object == null || !((String)object).equalsIgnoreCase("PrimaryKey")) continue;
            string2 = resultSet.getString(9).trim();
            arrayList.add(hashMap.get(StringFunc.identifierHashKey(string2)));
        }
        if (string3 == null) {
            string3 = "PK_" + string;
        }
        object = new AnnotatedSourceKey(arrayList, 1, string3);
        return object;
    }

    public void exportXML(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        fileOutputStream = new FileOutputStream(file);
        printWriter = new PrintWriter(fileOutputStream, true);
        this.db.exportXML(printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    public void exportXML(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = null;
        printWriter = new PrintWriter(outputStream, true);
        this.db.exportXML(printWriter);
        printWriter.close();
    }

    public ExtractStatus getStatus() {
        return this.status;
    }
}

