/*
 * Decompiled with CFR 0.152.
 */
package mongodb.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import mongodb.query.MongoBuilderFatalException;
import mongodb.query.MongoBuilderUpstreamException;
import mongodb.query.MongoDeleteQuery;
import mongodb.query.MongoInsertQuery;
import mongodb.query.MongoQuery;
import mongodb.query.MongoSelectQuery;
import mongodb.query.MongoUpdateQuery;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.jdbc.UnityDriver;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQCondNode;
import unity.query.LQDeleteNode;
import unity.query.LQDupElimNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQInsertNode;
import unity.query.LQLimitNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.query.LQUpdateNode;
import unity.util.StringFunc;

public class MongoBuilder {
    private LQNode startNode;
    private boolean distinct = false;
    private boolean fromSeen;
    private static final String OBJECT_ID = "ObjectID";
    private static final String ID_REGEX = "[0-9a-f]{24}";
    private GlobalSchema schema = null;
    private boolean projectionSeen = false;

    public MongoBuilder(LQNode lQNode) {
        this.startNode = lQNode;
    }

    public MongoBuilder(LQNode lQNode, GlobalSchema globalSchema) {
        this.startNode = lQNode;
        this.schema = globalSchema;
    }

    private String maybeUndelimit(String string, char c) {
        String string2 = string;
        if (StringFunc.isDelimited(string, c)) {
            string2 = StringFunc.undelimitName(string, c);
        }
        return string2;
    }

    private void rebuildDelete(LQDeleteNode lQDeleteNode, MongoDeleteQuery mongoDeleteQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (lQDeleteNode.getCondition() != null) {
            this.rebuildCondition(lQDeleteNode.getCondition(), basicDBObject, lQDeleteNode);
        }
        mongoDeleteQuery.query = basicDBObject;
        mongoDeleteQuery.collectionName = this.maybeUndelimit(lQDeleteNode.getSourceTable().getTable().getTableName(), '\"');
    }

    private void rebuildUpdate(LQUpdateNode lQUpdateNode, MongoUpdateQuery mongoUpdateQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (lQUpdateNode.getCondition() != null) {
            this.rebuildCondition(lQUpdateNode.getCondition(), basicDBObject, lQUpdateNode);
        }
        mongoUpdateQuery.query = basicDBObject;
        BasicDBObject basicDBObject2 = new BasicDBObject();
        for (int i = 0; i < lQUpdateNode.getNumFields(); ++i) {
            Object object;
            Object object2;
            LQExprNode lQExprNode = (LQExprNode)lQUpdateNode.getField(i);
            String[] stringArray = StringFunc.divideIdentifier(((LQNode)lQExprNode).toString());
            String string = stringArray[0];
            if (stringArray.length > 1) {
                string = stringArray[1];
            }
            if ((object2 = lQUpdateNode.getValue(i)) == null) {
                object = "null";
            } else if (object2 instanceof LQExprNode) {
                if (((LQExprNode)object2).getType() == 102 || ((LQExprNode)object2).getType() == 120 || ((LQExprNode)object2).getContent().toString().equalsIgnoreCase("current_time") || ((LQExprNode)object2).getContent().toString().equalsIgnoreCase("current_date") || ((LQExprNode)object2).getContent().toString().equalsIgnoreCase("current_timestamp")) {
                    throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Functions and expressions are not supported with INSERT, UPDATE or DELETE statements");
                }
                object = ((LQExprNode)object2).getContent();
            } else {
                object = object2;
            }
            if (object instanceof String && StringFunc.isDelimited((String)object, '\'')) {
                object = StringFunc.undelimitName((String)object, '\'');
            }
            basicDBObject2.put(string, object);
        }
        BasicDBObject basicDBObject3 = new BasicDBObject();
        basicDBObject3.put("$set", (Object)basicDBObject2);
        mongoUpdateQuery.update = basicDBObject3;
        mongoUpdateQuery.collectionName = this.maybeUndelimit(lQUpdateNode.getTable().getTable().getTableName(), '\"');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rebuildInsert(LQInsertNode lQInsertNode, MongoInsertQuery mongoInsertQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        ArrayList<GQFieldRef> arrayList = lQInsertNode.getInsertFields();
        ArrayList<Object> arrayList2 = lQInsertNode.getInsertValues();
        if (!(arrayList.size() != 0 || arrayList2.size() == 1 && (bl = MongoBuilder.checkIfJSONObject(arrayList2.get(0))))) {
            if (!this.schema.tableExists(this.schema.getAnnotatedDatabases().get(0).getDatabaseName(), lQInsertNode.getSourceTable().getTable().getTableName())) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Unable to resolve key-value matching as a schema has not been predicted for collection " + lQInsertNode.getSourceTable().getTable().getTableName());
            }
            int n = this.schema.findTable(lQInsertNode.getSourceTable().getTable().getTableName()).get(0).getNumFields() - 1;
            if (n <= 0) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Cannot insert values into collection " + lQInsertNode.getSourceTable().getTable().getTableName() + " as it only contains _id.");
            }
            if (n < arrayList2.size()) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Unable to resolve key-value matching as there are more values than keys for the exisiting collection.");
            }
            if (n != arrayList2.size()) throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Column names must be specified for values.");
            object3 = this.schema.findTable(lQInsertNode.getSourceTable().getTable().getTableName()).get(0).getSourceFieldsByPosition();
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = (SourceField)object2.next();
                if (((SourceField)object).getSQLColumnName().compareTo("_id") == 0) continue;
                arrayList.add(new GQFieldRef((AnnotatedSourceField)object, ((SourceField)object).getSQLColumnName(), null));
            }
        }
        if (!bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = arrayList.get(i);
                object = (LQExprNode)arrayList2.get(i);
                int n = ((LQNode)object).getType();
                Object object4 = ((LQNode)object).getContent();
                Object object5 = null;
                if (n == 104) {
                    object5 = Integer.parseInt(object4.toString());
                } else if (n == 105) {
                    object5 = Double.parseDouble(object4.toString());
                } else if (n == 127 || n == 140 || n == 141 || n == 142 || n == 101) {
                    object5 = object4.toString();
                    if (StringFunc.isDelimited((String)object5, '\'')) {
                        object5 = StringFunc.undelimitName((String)object5, '\'');
                    }
                    if (MongoBuilder.checkIfJSONObject(object5)) {
                        if (UnityDriver.DEBUG) {
                            System.out.println("Processing nested JSON");
                        }
                        object5 = this.buildBSON(object5);
                    }
                } else if (n == 131) {
                    object5 = null;
                } else {
                    if (n != 102) throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values (no expressions)");
                    if (object4.toString().compareToIgnoreCase(OBJECT_ID) == 0) {
                        int n2 = ((LQNode)object).getNumChildren();
                        if (n2 > 1) {
                            throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Incorrect number of arguments for Mongo object ObjectID");
                        }
                        if (n2 == 1) {
                            object5 = ((LQNode)object).getChild().getContent().toString();
                            if (!Pattern.matches("'[0-9a-f]{24}'", (String)object5)) {
                                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Incorrectly formated ObjectId value.  Value must be formatted as a singled quoted 3-byte hexidecimal string");
                            }
                            object5 = new ObjectId(StringFunc.removeQuotes((String)object5));
                        } else {
                            object5 = new ObjectId();
                        }
                    } else {
                        if (!UnityDriver.DEBUG) throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values (no expressions or functions)");
                        System.out.println("Encountered function " + object4.toString() + " : Throwing error");
                        throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values (no expressions or functions)");
                    }
                }
                mongoInsertQuery.insertFields.put(((GQFieldRef)object2).toString(), object5);
            }
        } else {
            object3 = (DBObject)this.buildBSON(arrayList2.get(0));
            mongoInsertQuery.insertFields.putAll((BSONObject)object3);
        }
        mongoInsertQuery.collectionName = this.maybeUndelimit(lQInsertNode.getSourceTable().getTable().getTableName(), '\"');
    }

    private Object buildBSON(Object object) throws MongoBuilderFatalException {
        String string = null;
        try {
            if (object instanceof String) {
                string = (String)object;
                if (UnityDriver.DEBUG) {
                    System.out.println(string);
                }
            } else {
                string = ((LQExprNode)object).getContent().toString();
                if (UnityDriver.DEBUG) {
                    System.out.println(string);
                }
            }
            return JSON.parse((String)StringFunc.removeQuotes(string));
        }
        catch (JSONParseException jSONParseException) {
            throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Incorrectly formed JSON string in value list");
        }
    }

    public static boolean checkIfJSONObject(Object object) {
        try {
            if (object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof Float || object instanceof Short) {
                return false;
            }
            if (object instanceof String) {
                JSON.parse((String)((String)object));
            } else if (object instanceof LQExprNode) {
                Object object2 = ((LQExprNode)object).getContent();
                if (object2 instanceof Integer || object2 instanceof Double || object2 instanceof Long || object2 instanceof Float || object2 instanceof Short) {
                    return false;
                }
                JSON.parse((String)object2.toString());
            }
            return true;
        }
        catch (JSONParseException jSONParseException) {
            return false;
        }
    }

    private void rebuildDistinct(LQDupElimNode lQDupElimNode, MongoQuery mongoQuery) throws MongoBuilderUpstreamException, MongoBuilderFatalException {
        this.distinct = true;
        this.rebuildProjection((LQProjNode)lQDupElimNode.getChild(), (MongoSelectQuery)mongoQuery);
    }

    private void rebuildProjection(LQProjNode lQProjNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        if (this.projectionSeen) {
            return;
        }
        this.projectionSeen = true;
        ArrayList<LQExprNode> arrayList = lQProjNode.getExpressions();
        for (LQExprNode lQExprNode : arrayList) {
            if (mongoSelectQuery.count) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: If a COUNT node is specified, only one projection is allowed at the moment.");
            }
            if (mongoSelectQuery.distinctField != null) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: DISTINCT with multiple projections is not allowed at the moment.");
            }
            String string = null;
            if (lQExprNode.getType() == 103) {
                string = lQExprNode.getChild(1).toString();
                lQExprNode = (LQExprNode)lQExprNode.getChild(0);
            }
            if (lQExprNode.getType() == 133) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: CASE is not supported.");
            }
            if (lQExprNode.getType() == 102) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
            }
            if (lQExprNode.getType() == 126) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Expressions in projection are not supported.");
            }
            if (lQExprNode.getType() == 120) {
                if ((lQExprNode = (LQExprNode)lQExprNode.getContent()).getContent().equals("COUNT")) {
                    lQExprNode = (LQExprNode)lQExprNode.getChild(0);
                    mongoSelectQuery.count = true;
                    if (string == null) {
                        string = "Count";
                    }
                    mongoSelectQuery.fieldNames.put("Count(*)", string);
                    if (!mongoSelectQuery.hasProjections()) continue;
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: If a COUNT node is specified, only one projection is allowed at the moment.");
                }
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: We don't know how to handle expressions that aren't COUNT yet.");
            }
            if (lQExprNode.getContent().toString().equalsIgnoreCase("current_timestamp") || lQExprNode.getContent().toString().equalsIgnoreCase("current_time") || lQExprNode.getContent().toString().equalsIgnoreCase("current_date")) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
            }
            String[] stringArray = StringFunc.divideIdentifier(lQExprNode.toString());
            String string2 = stringArray[0];
            if (stringArray.length > 1) {
                string2 = stringArray[stringArray.length - 1];
            }
            if ((string2 = StringFunc.removeDoubleQuotes(string2)).equals("*")) {
                mongoSelectQuery.clearProjections();
                break;
            }
            if (this.distinct) {
                if (mongoSelectQuery.hasProjections()) {
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: DISTINCT with multiple projections is not allowed at the moment.");
                }
                mongoSelectQuery.distinctField = string2;
                continue;
            }
            mongoSelectQuery.projections.put(string2, (Object)1);
            if (string == null) {
                string = string2;
            }
            mongoSelectQuery.fieldNames.put(string2, string);
        }
        if (!mongoSelectQuery.projections.containsField("_id") && mongoSelectQuery.projections.size() != 0) {
            mongoSelectQuery.projections.put("_id", (Object)0);
        }
    }

    private void rebuildCondition(LQCondNode lQCondNode, BasicDBObject basicDBObject, LQNode lQNode) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBObject basicDBObject2 = basicDBObject;
        LQCondNode lQCondNode2 = lQCondNode;
        int n = lQCondNode2.getType();
        LQNode lQNode2 = lQCondNode2.getChild(0);
        LQNode lQNode3 = lQCondNode2.getChild(1);
        switch (n) {
            case 118: {
                this.rebuildXOR(lQCondNode2, lQNode2, lQNode3);
                this.rebuildCondition(lQCondNode2, basicDBObject, lQNode);
                break;
            }
            case 121: {
                this.rebuildXNOR(lQCondNode2, lQNode2, lQNode3);
                this.rebuildCondition(lQCondNode2, basicDBObject, lQNode);
                break;
            }
            case 112: {
                BasicDBObject basicDBObject3 = new BasicDBObject();
                if (lQNode2.getContent().toString().compareToIgnoreCase("<") != 0 && lQNode2.getContent().toString().compareToIgnoreCase("<=") != 0 && lQNode2.getContent().toString().compareToIgnoreCase(">=") != 0 && lQNode2.getContent().toString().compareToIgnoreCase(">") != 0 && (lQNode2.getType() == 114 || lQNode2.getType() == 111 || lQNode2.getType() == 110 || lQNode2.getType() == 118 || lQNode2.getType() == 118 || lQNode2.getType() == 112)) {
                    lQCondNode2 = this.pushDownNOTIntoLogicalOperator(lQNode, lQCondNode2, lQNode2);
                    this.rebuildCondition(lQCondNode2, basicDBObject, lQNode);
                    break;
                }
                if (lQNode2.getChild(1).getType() == 100 && lQNode2.getChild(0).getType() != 100) {
                    String string = (String)lQNode2.getContent();
                    LQNode lQNode4 = lQNode2.getChild(1);
                    lQCondNode2.getChild(0).setChild(1, lQNode2.getChild(0));
                    lQCondNode2.getChild(0).setChild(0, lQNode4);
                    string = this.switchOperator(string);
                    lQCondNode2.getChild(0).setContent(string);
                    this.rebuildCondition(lQCondNode2, basicDBObject, lQNode);
                    return;
                }
                this.pushNOTDownIntoComparisonIOperator(basicDBObject, basicDBObject3, lQNode2);
                this.rebuildCondition((LQCondNode)lQNode2, basicDBObject3, lQNode);
                break;
            }
            case 111: {
                BasicDBList basicDBList = this.rebuildBinaryExpression(lQNode, lQNode2, lQNode3);
                basicDBObject.put("$and", (Object)basicDBList);
                break;
            }
            case 110: {
                BasicDBList basicDBList = this.rebuildBinaryExpression(lQNode, lQNode2, lQNode3);
                basicDBObject.put("$or", (Object)basicDBList);
                break;
            }
            default: {
                this.rebuildExpression(lQCondNode2, basicDBObject);
            }
        }
    }

    private void pushNOTDownIntoComparisonIOperator(BasicDBObject basicDBObject, BasicDBObject basicDBObject2, LQNode lQNode) {
        Object object = lQNode.getChild(0).getContent();
        if (object instanceof String) {
            object = StringFunc.removeQuotes((String)object);
        } else if (object instanceof GQFieldRef) {
            object = ((GQFieldRef)object).getName();
        }
        basicDBObject.put((String)object, (Object)basicDBObject2);
        if (lQNode.getContent().toString().compareTo("=") == 0) {
            lQNode.setContent("!=");
        } else if (lQNode.getContent().toString().compareToIgnoreCase("NOT LIKE") == 0) {
            lQNode.setContent("LIKE");
            lQNode.setType(114);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("LIKE") == 0) {
            lQNode.setContent("NOT LIKE");
            lQNode.setType(114);
        } else {
            lQNode.getChild(0).setContent("NOT");
            lQNode.getChild(0).setType(112);
        }
    }

    private LQCondNode pushDownNOTIntoLogicalOperator(LQNode lQNode, LQCondNode lQCondNode, LQNode lQNode2) throws MongoBuilderUpstreamException {
        LQCondNode lQCondNode2 = lQCondNode;
        this.complementConditionNode(lQCondNode2, lQNode2);
        Iterator<LQNode> iterator = lQNode2.getChildren().iterator();
        if (lQNode2.getContent().toString().compareToIgnoreCase("XOR") == 0 || lQNode2.getContent().toString().compareToIgnoreCase("XNOR") == 0) {
            this.pushNOTDownAndComplementOperator(lQCondNode2, iterator);
        } else if (lQNode2.getContent().toString().compareToIgnoreCase("NOT") == 0) {
            lQCondNode2 = this.collapseDoubleNOT(lQNode, lQCondNode2, iterator);
        } else if (lQNode2.getContent().toString().compareToIgnoreCase("AND") == 0 || lQNode2.getContent().toString().compareToIgnoreCase("OR") == 0) {
            this.pushNOTDownANDandOR(lQCondNode2, iterator);
        } else if (lQNode2.getContent().toString().compareToIgnoreCase("LIKE") == 0 || lQNode2.getContent().toString().compareToIgnoreCase("NOT LIKE") == 0 || lQNode2.getContent().toString().compareToIgnoreCase("=") == 0 || lQNode2.getContent().toString().compareToIgnoreCase("!=") == 0 || lQNode2.getContent().toString().compareToIgnoreCase("<>") == 0) {
            this.pushNOTDownAndComplementOperator(lQCondNode2, iterator);
        }
        return lQCondNode2;
    }

    private BasicDBList rebuildBinaryExpression(LQNode lQNode, LQNode lQNode2, LQNode lQNode3) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject basicDBObject2 = new BasicDBObject();
        this.rebuildCondition((LQCondNode)lQNode2, basicDBObject, lQNode);
        this.rebuildCondition((LQCondNode)lQNode3, basicDBObject2, lQNode);
        basicDBList.add((Object)basicDBObject);
        basicDBList.add((Object)basicDBObject2);
        return basicDBList;
    }

    private void complementConditionNode(LQCondNode lQCondNode, LQNode lQNode) throws MongoBuilderUpstreamException {
        if (lQNode.getContent().toString().compareToIgnoreCase("=") == 0) {
            lQCondNode.setContent("!=");
            lQCondNode.setType(114);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("!=") == 0 || lQNode.getContent().toString().compareToIgnoreCase("<>") == 0) {
            lQCondNode.setContent("=");
            lQCondNode.setType(114);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("LIKE") == 0) {
            lQCondNode.setContent("NOT LIKE");
            lQCondNode.setType(114);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("NOT LIKE") == 0) {
            lQCondNode.setContent("LIKE");
            lQCondNode.setType(114);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("AND") == 0) {
            lQCondNode.setContent("OR");
            lQCondNode.setType(110);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("OR") == 0) {
            lQCondNode.setContent("AND");
            lQCondNode.setType(111);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("XOR") == 0) {
            lQCondNode.setContent("XNOR");
            lQCondNode.setType(121);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("XNOR") == 0) {
            lQCondNode.setContent("XOR");
            lQCondNode.setType(118);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("NOT") != 0) {
            throw new MongoBuilderUpstreamException(lQNode.getContent().toString() + " can not be negated properly");
        }
    }

    private void pushNOTDownANDandOR(LQCondNode lQCondNode, Iterator<LQNode> iterator) {
        lQCondNode.removeChild(0);
        while (iterator.hasNext()) {
            LQNode lQNode = iterator.next();
            LQCondNode lQCondNode2 = new LQCondNode();
            lQCondNode2.setContent("NOT");
            lQCondNode2.setType(112);
            lQCondNode2.addChild(lQNode);
            lQCondNode2.getChild().setParent(lQCondNode2);
            lQCondNode.addChild(lQCondNode2);
            lQCondNode2.setParent(lQCondNode);
        }
    }

    private LQCondNode collapseDoubleNOT(LQNode lQNode, LQCondNode lQCondNode, Iterator<LQNode> iterator) {
        LQCondNode lQCondNode2 = lQCondNode;
        while (iterator.hasNext()) {
            LQNode lQNode2 = iterator.next();
            if (lQCondNode2.getParent() != null) {
                lQCondNode2.getParent().replaceChild(lQCondNode2, lQNode2);
                lQNode2.setParent(lQCondNode2.getParent());
                lQCondNode2 = (LQCondNode)lQNode2;
                continue;
            }
            if (lQNode instanceof LQSelNode) {
                ((LQSelNode)lQNode).setCondition((LQCondNode)lQNode2);
                lQCondNode2 = ((LQSelNode)lQNode).getCondition();
                continue;
            }
            if (lQNode instanceof LQUpdateNode) {
                ((LQUpdateNode)lQNode).setCondition((LQCondNode)lQNode2);
                lQCondNode2 = ((LQUpdateNode)lQNode).getCondition();
                continue;
            }
            if (!(lQNode instanceof LQDeleteNode)) continue;
            ((LQDeleteNode)lQNode).setCondition((LQCondNode)lQNode2);
            lQCondNode2 = ((LQDeleteNode)lQNode).getCondition();
        }
        return lQCondNode2;
    }

    private void pushNOTDownAndComplementOperator(LQCondNode lQCondNode, Iterator<LQNode> iterator) {
        lQCondNode.removeChild(0);
        while (iterator.hasNext()) {
            LQNode lQNode = iterator.next();
            lQCondNode.addChild(lQNode);
            lQNode.setParent(lQCondNode);
        }
    }

    private void rebuildXNOR(LQCondNode lQCondNode, LQNode lQNode, LQNode lQNode2) {
        LQNode lQNode3 = (LQNode)lQNode.clone();
        LQNode lQNode4 = (LQNode)lQNode2.clone();
        LQNode lQNode5 = lQNode;
        LQNode lQNode6 = lQNode2;
        LQCondNode lQCondNode2 = new LQCondNode();
        lQCondNode2.setType(111);
        lQCondNode2.setContent("AND");
        LQCondNode lQCondNode3 = new LQCondNode();
        lQCondNode3.setType(111);
        lQCondNode3.setContent("AND");
        LQCondNode lQCondNode4 = new LQCondNode();
        lQCondNode4.setType(112);
        lQCondNode4.setContent("NOT");
        LQCondNode lQCondNode5 = new LQCondNode();
        lQCondNode5.setType(112);
        lQCondNode5.setContent("NOT");
        lQCondNode2.addChild(lQCondNode4);
        lQCondNode4.setParent(lQCondNode2);
        lQCondNode4.addChild(lQNode3);
        lQNode3.setParent(lQCondNode4);
        lQCondNode2.addChild(lQCondNode5);
        lQCondNode5.setParent(lQCondNode2);
        lQCondNode5.addChild(lQNode4);
        lQNode4.setParent(lQCondNode5);
        lQCondNode3.addChild(lQNode5);
        lQNode5.setParent(lQCondNode3);
        lQCondNode3.addChild(lQNode6);
        lQNode6.setParent(lQCondNode3);
        lQCondNode.replaceChild(lQNode, lQCondNode2);
        lQCondNode.replaceChild(lQNode2, lQCondNode3);
        lQCondNode2.setParent(lQCondNode);
        lQCondNode3.setParent(lQCondNode);
        lQCondNode.setContent("OR");
        lQCondNode.setType(110);
    }

    private void rebuildXOR(LQCondNode lQCondNode, LQNode lQNode, LQNode lQNode2) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        LQNode lQNode3 = (LQNode)lQNode.clone();
        LQNode lQNode4 = (LQNode)lQNode2.clone();
        LQNode lQNode5 = lQNode;
        LQNode lQNode6 = lQNode2;
        LQCondNode lQCondNode2 = new LQCondNode();
        lQCondNode2.setType(111);
        lQCondNode2.setContent("AND");
        LQCondNode lQCondNode3 = new LQCondNode();
        lQCondNode3.setType(111);
        lQCondNode3.setContent("AND");
        LQCondNode lQCondNode4 = new LQCondNode();
        lQCondNode4.setType(112);
        lQCondNode4.setContent("NOT");
        LQCondNode lQCondNode5 = new LQCondNode();
        lQCondNode5.setType(112);
        lQCondNode5.setContent("NOT");
        lQCondNode2.addChild(lQCondNode4);
        lQCondNode4.setParent(lQCondNode2);
        lQCondNode4.addChild(lQNode3);
        lQNode3.setParent(lQCondNode4);
        lQCondNode2.addChild(lQNode4);
        lQNode4.setParent(lQCondNode2);
        lQCondNode3.addChild(lQCondNode5);
        lQCondNode5.setParent(lQCondNode3);
        lQCondNode5.addChild(lQNode6);
        lQNode6.setParent(lQCondNode5);
        lQCondNode3.addChild(lQNode5);
        lQNode5.setParent(lQCondNode3);
        lQCondNode.replaceChild(lQNode, lQCondNode2);
        lQCondNode.replaceChild(lQNode2, lQCondNode3);
        lQCondNode2.setParent(lQCondNode);
        lQCondNode3.setParent(lQCondNode);
        lQCondNode.setContent("OR");
        lQCondNode.setType(110);
    }

    private String rebuildOperator(String string) throws MongoBuilderFatalException {
        if (string.equals(">")) {
            return "$gt";
        }
        if (string.equals("<")) {
            return "$lt";
        }
        if (string.equals(">=")) {
            return "$gte";
        }
        if (string.equals("<=")) {
            return "$lte";
        }
        if (string.equals("!=") || string.equals("<>")) {
            return "$ne";
        }
        if (string.equals("NOT LIKE") || string.equals("NOT")) {
            return "$not";
        }
        throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Operator " + string + " not supported.");
    }

    private String switchOperator(String string) {
        if (string.equals("<")) {
            return ">";
        }
        if (string.equals("<=")) {
            return ">=";
        }
        if (string.equals(">")) {
            return "<";
        }
        if (string.equals(">=")) {
            return "<=";
        }
        if (string.equals("!<")) {
            return "!<";
        }
        if (string.equals("!<")) {
            return "!>";
        }
        return string;
    }

    private void rebuildExpression(LQCondNode lQCondNode, BasicDBObject basicDBObject) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        LQNode lQNode = lQCondNode.getChild(0);
        LQNode lQNode2 = lQCondNode.getChild(1);
        int n = lQCondNode.getType();
        if (n == 100) {
            System.out.println(((GQFieldRef)lQCondNode.getContent()).getLocalName());
        } else {
            String string;
            String string2 = (String)lQCondNode.getContent();
            Object object = lQNode.getContent();
            Object object2 = lQNode2.getContent();
            if (lQNode.getType() == 102) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Function not supported: " + object);
            }
            if (lQNode2.getType() == 102) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Function not supported: " + object2);
            }
            if (lQNode2.getContent() instanceof GQFieldRef && ((string = ((GQFieldRef)object2).getName()).equalsIgnoreCase("current_date") || string.equalsIgnoreCase("current_time") || string.equalsIgnoreCase("current_timestamp"))) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
            }
            if (lQNode.getContent() instanceof GQFieldRef && ((string = ((GQFieldRef)object).getName()).equalsIgnoreCase("current_date") || string.equalsIgnoreCase("current_time") || string.equalsIgnoreCase("current_timestamp"))) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
            }
            if (lQNode2.getType() == 100) {
                if (lQNode.getType() != 100) {
                    lQCondNode.setChild(0, lQNode2);
                    lQCondNode.setChild(1, lQNode);
                    string2 = this.switchOperator(string2);
                    lQCondNode.setContent(string2);
                    this.rebuildExpression(lQCondNode, basicDBObject);
                    return;
                }
                string = lQNode.getContent().toString();
                String string3 = lQNode2.getContent().toString();
                string = StringFunc.removeDoubleQuotes(string);
                string3 = StringFunc.removeDoubleQuotes(string3);
                String string4 = "this." + string + " == " + "this." + string3;
                basicDBObject.put("$where", (Object)string4);
                return;
            }
            if (object2 instanceof String) {
                object2 = StringFunc.removeQuotes((String)object2);
            } else if (object2 instanceof GQFieldRef) {
                if (((String)(object2 = ((GQFieldRef)object2).getName())).equalsIgnoreCase("current_date") || ((String)object2).equalsIgnoreCase("current_time") || ((String)object2).equalsIgnoreCase("current_timestamp")) {
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
                }
                object2 = StringFunc.removeDoubleQuotes((String)object2);
            }
            if (object instanceof String) {
                object = StringFunc.removeQuotes((String)object);
            } else if (object instanceof GQFieldRef) {
                if (((String)(object = ((GQFieldRef)object).getName())).equalsIgnoreCase("current_date") || ((String)object).equalsIgnoreCase("current_time") || ((String)object).equalsIgnoreCase("current_timestamp")) {
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
                }
                object = StringFunc.removeDoubleQuotes((String)object);
            }
            if (string2.equals("=")) {
                this.addToQueryObject(basicDBObject, (String)object, object2);
            } else if (string2.equals(">") || string2.equals("<") || string2.equals("<=") || string2.equals(">=")) {
                if (basicDBObject.containsKey(object)) {
                    string = (BasicDBObject)basicDBObject.get(object);
                } else {
                    string = new BasicDBObject();
                    if (((String)object).equalsIgnoreCase("NOT") || ((String)object).equalsIgnoreCase("NOT LIKE")) {
                        basicDBObject.put(this.rebuildOperator((String)object), (Object)string);
                    } else {
                        basicDBObject.put((String)object, (Object)string);
                    }
                }
                string.put(this.rebuildOperator(string2), object2);
            } else if (string2.equals("!=") || string2.equals("<>")) {
                string = new BasicDBObject();
                basicDBObject.put((String)object, (Object)string);
                string.put(this.rebuildOperator(string2), object2);
            } else if (lQCondNode.getType() == 114) {
                string = new BasicDBObject();
                if (string2.equalsIgnoreCase("NOT LIKE")) {
                    basicDBObject.put((String)object, (Object)string);
                    string.put(this.rebuildOperator(string2), (Object)Pattern.compile("^" + StringFunc.convertSQLPatternToJavaPattern(object2.toString()) + "$"));
                } else {
                    this.addToQueryObject(basicDBObject, (String)object, Pattern.compile("^" + StringFunc.convertSQLPatternToJavaPattern(object2.toString()) + "$"));
                }
            }
        }
    }

    private void addToQueryObject(BasicDBObject basicDBObject, String string, Object object) {
        Object object2 = basicDBObject.get(string);
        if (object2 == null) {
            basicDBObject.put(string, object);
        } else {
            BasicDBList basicDBList = new BasicDBList();
            BasicDBObject basicDBObject2 = new BasicDBObject();
            basicDBObject2.put(string, object2);
            basicDBList.add((Object)basicDBObject2);
            basicDBObject2 = new BasicDBObject();
            basicDBObject2.put(string, object);
            basicDBList.add((Object)basicDBObject2);
            basicDBObject.put("$and", (Object)basicDBList);
            basicDBObject.remove((Object)string);
        }
    }

    private void rebuildSelection(LQSelNode lQSelNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        LQCondNode lQCondNode = lQSelNode.getCondition();
        BasicDBObject basicDBObject = mongoSelectQuery.query;
        this.rebuildCondition(lQCondNode, basicDBObject, lQSelNode);
    }

    private void rebuildGroupBy(LQGroupByNode lQGroupByNode, MongoQuery mongoQuery) throws MongoBuilderUpstreamException {
        if (lQGroupByNode.getExpressions().size() > 0) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: GROUP BY is not supported by the driver.");
        }
        if (lQGroupByNode.getFunctionList().size() > 1) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Only support COUNT(*).");
        }
        LQExprNode lQExprNode = lQGroupByNode.getFunctionList().get(0);
        if (!lQExprNode.toString().equalsIgnoreCase("count(*)")) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Only support COUNT(*).");
        }
    }

    private void rebuildOrderBy(LQOrderByNode lQOrderByNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderUpstreamException {
        for (int i = 0; i < lQOrderByNode.getOrderNumChildren(); ++i) {
            Object object = lQOrderByNode.getOrderChild(i).getContent();
            String string = null;
            if (!(object instanceof GQFieldRef)) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: ORDER BY with an expression or function is not supported by the driver.");
            }
            string = ((GQFieldRef)object).toString();
            String string2 = lQOrderByNode.getDirection(i);
            int n = string2 == "DESC" ? -1 : 1;
            mongoSelectQuery.orderBy.put(string, (Object)n);
        }
    }

    private void rebuildFrom(LQNode lQNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        if (this.fromSeen) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Two FROM nodes were received. We currently only support single collection queries.");
        }
        this.fromSeen = true;
        mongoSelectQuery.collectionName = ((GQTableRef)lQNode.getContent()).getTable().getTableName();
        if (StringFunc.isDelimited(mongoSelectQuery.collectionName, '\"')) {
            mongoSelectQuery.collectionName = StringFunc.undelimitName(mongoSelectQuery.collectionName, '\"');
        }
    }

    private void rebuildLimit(LQLimitNode lQLimitNode, MongoSelectQuery mongoSelectQuery) {
        if (lQLimitNode.hasOffset()) {
            mongoSelectQuery.offset = lQLimitNode.getStart();
        }
        mongoSelectQuery.limit = lQLimitNode.getCount();
    }

    public MongoQuery toMongoQuery() throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        MongoQuery mongoQuery = new MongoSelectQuery();
        for (LQNode lQNode = this.startNode; lQNode != null; lQNode = lQNode.getChild()) {
            switch (lQNode.getType()) {
                case 1: {
                    this.rebuildProjection((LQProjNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 2: {
                    this.rebuildSelection((LQSelNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 6: 
                case 100: {
                    this.rebuildFrom(lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 18: {
                    this.rebuildLimit((LQLimitNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 4: {
                    this.rebuildOrderBy((LQOrderByNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 5: {
                    this.rebuildGroupBy((LQGroupByNode)lQNode, mongoQuery);
                    break;
                }
                case 16: {
                    this.rebuildDistinct((LQDupElimNode)lQNode, mongoQuery);
                    break;
                }
                case 22: 
                case 23: {
                    mongoQuery = new MongoInsertQuery();
                    this.rebuildInsert((LQInsertNode)lQNode, (MongoInsertQuery)mongoQuery);
                    break;
                }
                case 21: {
                    mongoQuery = new MongoUpdateQuery();
                    this.rebuildUpdate((LQUpdateNode)lQNode, (MongoUpdateQuery)mongoQuery);
                    break;
                }
                case 20: {
                    mongoQuery = new MongoDeleteQuery();
                    this.rebuildDelete((LQDeleteNode)lQNode, (MongoDeleteQuery)mongoQuery);
                    break;
                }
                default: {
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Got a query element we don't know how to deal with. Type " + lQNode + ".");
                }
            }
            if (lQNode.getNumChildren() <= 1) continue;
            throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Too many children found at node " + lQNode.toString());
        }
        return mongoQuery;
    }

    public String toMongoString() throws MongoBuilderUpstreamException, MongoBuilderFatalException {
        return this.toMongoQuery().toMongoString();
    }

    public String toString() {
        try {
            return this.toMongoString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }
}

