/*
 * Decompiled with CFR 0.152.
 */
package snow.conn;

import java.sql.ResultSet;
import java.sql.SQLException;
import snow.conn.ServerConnection;
import snow.jdbc.SNowResultSet;
import snow.jdbc.SNowStatement;
import snow.query.SNowBuilder;
import snow.query.SNowQuery;
import unity.annotation.GlobalSchema;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.LQTree;

public class SNowExecutor {
    private boolean resultSetComplete;
    private Operator op;
    private Relation relation;
    private int statementId;
    private String url;
    private GlobalQuery gq;

    public SNowExecutor(String string, int n) {
        this.statementId = n;
        this.url = string;
    }

    public ResultSet execute(String string, int n, SNowStatement sNowStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws SQLException {
        string = string + ";";
        GlobalParser globalParser = new GlobalParser(false, true);
        this.gq = globalParser.parse(string, globalSchema);
        LQTree lQTree = this.gq.getLogicalQueryTree();
        if (UnityDriver.DEBUG) {
            System.out.println("Logical query tree: \n");
            lQTree.print();
        }
        SNowBuilder sNowBuilder = new SNowBuilder(this.url, lQTree.getRoot());
        SNowQuery sNowQuery = null;
        sNowQuery = sNowBuilder.toQuery();
        sNowStatement.setQuery(sNowQuery);
        if (UnityDriver.DEBUG) {
            System.out.println("ServiceNow query executed: " + sNowQuery.toString());
        }
        this.op = sNowQuery.run();
        this.relation = sNowQuery.getRelation();
        TableData tableData = new TableData(serverConnection, n != 1003, this.statementId);
        tableData.setRelation(this.relation);
        return new SNowResultSet(tableData, this.relation, n, sNowStatement);
    }

    public boolean next(Tuple tuple) throws SQLException {
        if (this.resultSetComplete) {
            return false;
        }
        try {
            if (this.op.next(tuple)) {
                return true;
            }
            this.resultSetComplete = true;
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public GlobalQuery getGlobalQuery() {
        return this.gq;
    }
}

