/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import unity.annotation.CommonMethods;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceJoin;
import unity.annotation.SourceKey;
import unity.jdbc.UnityDriver;
import unity.util.StringFunc;

public class SourceTable {
    protected String tableName;
    protected String schemaName;
    protected String catalogName;
    protected String comment;
    protected int numTuples;
    protected int type;
    protected SourceDatabase parentDatabase;
    protected HashMap<String, SourceField> sourceFields = new HashMap();
    protected SourceKey primaryKey;
    protected ArrayList<SourceForeignKey> foreignKeys = new ArrayList();
    protected ArrayList<SourceKey> candidateKeys = new ArrayList();
    protected ArrayList<SourceJoin> sourceJoins = new ArrayList();
    protected LinkedHashMap<String, Object> properties = new LinkedHashMap();
    public static final Comparator<SourceTable> SourceTableNameComparator = new Comparator<SourceTable>(){

        @Override
        public int compare(SourceTable sourceTable, SourceTable sourceTable2) {
            return sourceTable.getTableName().compareTo(sourceTable2.getTableName());
        }
    };

    public SourceTable() {
    }

    public SourceTable(String string, String string2, String string3, String string4, HashMap<String, SourceField> hashMap, SourceKey sourceKey) {
        this.catalogName = string;
        this.schemaName = string2;
        this.tableName = string3;
        this.comment = string4;
        this.sourceFields = hashMap;
        this.primaryKey = sourceKey;
        this.type = 0;
    }

    public SourceDatabase getParentDatabase() {
        return this.parentDatabase;
    }

    public void setParentDatabase(SourceDatabase sourceDatabase) {
        this.parentDatabase = sourceDatabase;
    }

    public boolean isPrimaryKey(ArrayList<SourceField> arrayList) {
        if (this.primaryKey == null) {
            return false;
        }
        return this.primaryKey.matchKeyFields(arrayList);
    }

    public ArrayList<SourceForeignKey> isForeignKey(ArrayList<SourceField> arrayList) {
        ArrayList<SourceForeignKey> arrayList2 = new ArrayList<SourceForeignKey>();
        for (int i = 0; i < this.foreignKeys.size(); ++i) {
            SourceForeignKey sourceForeignKey = this.foreignKeys.get(i);
            if (!sourceForeignKey.matchKeyFields(arrayList)) continue;
            arrayList2.add(sourceForeignKey);
        }
        return arrayList2;
    }

    public boolean isForeignKey(ArrayList<SourceField> arrayList, SourceTable sourceTable) {
        for (int i = 0; i < this.foreignKeys.size(); ++i) {
            SourceForeignKey sourceForeignKey = this.foreignKeys.get(i);
            if (sourceForeignKey.getToSourceTable() != sourceTable || !sourceForeignKey.matchKeyFields(arrayList)) continue;
            return true;
        }
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public int getNumFields() {
        return this.sourceFields.size();
    }

    public int getTupleSize() {
        int n = 0;
        Iterator<SourceField> iterator = this.sourceFields.values().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().getByteSize();
        }
        return n;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getFullName() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this.parentDatabase != null && (object = this.parentDatabase.getProperty("usecatalog")) != null && object.toString().equalsIgnoreCase("false")) {
            bl = false;
        }
        if (this.catalogName != null && bl) {
            stringBuilder.append(this.catalogName);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('.');
        }
        stringBuilder.append(this.getNameWithSchema());
        return stringBuilder.toString();
    }

    public String getNameWithSchema() {
        String string = "";
        if (this.schemaName != null && !this.schemaName.equals("")) {
            string = this.schemaName + ".";
        }
        string = string + this.tableName;
        return string;
    }

    public String getSQLTableName() {
        return StringFunc.delimitName(this.tableName, this.parentDatabase.getDelimitChar());
    }

    public String getUnitySQLTableName() {
        return StringFunc.delimitName(this.tableName, '\"');
    }

    public String getUnitySQLTableNameWithSchema() {
        String string = "";
        char c = '\"';
        if (this.schemaName != null && !this.schemaName.equals("")) {
            string = string + StringFunc.delimitName(this.schemaName, c) + '.';
        }
        string = string + StringFunc.delimitName(this.tableName, c);
        return string;
    }

    public String getUnityFullSQLTableName() {
        return this.getParentDatabase().getDatabaseName() + '.' + this.getUnitySQLTableNameWithSchema();
    }

    public String getSQLTableNameWithSchema() {
        String string = "";
        char c = '\"';
        boolean bl = true;
        if (this.parentDatabase != null) {
            c = this.parentDatabase.getDelimitChar();
            Object object = this.parentDatabase.getProperty("usecatalog");
            if (object != null && object.toString().equalsIgnoreCase("false")) {
                bl = false;
            }
        }
        if (this.catalogName != null && !this.catalogName.equals("") && bl) {
            string = string + StringFunc.delimitName(this.catalogName, c) + '.';
        }
        if (this.schemaName != null && !this.schemaName.equals("")) {
            string = string + StringFunc.delimitName(this.schemaName, c) + '.';
        }
        string = string + StringFunc.delimitName(this.tableName, c);
        return string;
    }

    public String getFullSQLTableName() {
        return this.getParentDatabase().getDatabaseName() + '.' + this.getSQLTableNameWithSchema();
    }

    public String getLookupName() {
        String string = this.getFullSQLTableName();
        if (StringFunc.delimitedIdentifier(this.tableName)) {
            return string;
        }
        return string.toLowerCase();
    }

    public HashMap<String, SourceField> getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(HashMap<String, SourceField> hashMap) {
        this.sourceFields = hashMap;
    }

    public SourceKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(SourceKey sourceKey) {
        this.primaryKey = sourceKey;
    }

    public void setForeignKeys(ArrayList<SourceForeignKey> arrayList) {
        this.foreignKeys = arrayList;
    }

    public void addForeignKey(SourceForeignKey sourceForeignKey) {
        this.foreignKeys.add(sourceForeignKey);
    }

    public ArrayList<SourceForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public ArrayList<SourceKey> getCandidateKeys() {
        return this.candidateKeys;
    }

    public ArrayList<SourceJoin> getJoins() {
        return this.sourceJoins;
    }

    public void setJoins(ArrayList<SourceJoin> arrayList) {
        this.sourceJoins = arrayList;
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public void setNumTuples(int n) {
        this.numTuples = n;
    }

    public void addJoin(SourceJoin sourceJoin) {
        this.sourceJoins.add(sourceJoin);
    }

    public void removeJoin(SourceJoin sourceJoin) {
        this.sourceJoins.remove(sourceJoin);
    }

    public void removeJoins(SourceKey sourceKey) {
        Iterator<SourceJoin> iterator = this.sourceJoins.iterator();
        while (iterator.hasNext()) {
            SourceTable sourceTable;
            SourceJoin sourceJoin = iterator.next();
            if (sourceJoin.getFromKey() != sourceKey && sourceJoin.getToKey() != sourceKey) continue;
            iterator.remove();
            if (sourceJoin.getFromKey().getTable() == this) {
                sourceTable = sourceJoin.getToKey().getTable();
                sourceTable.removeJoin(sourceJoin);
                continue;
            }
            sourceTable = sourceJoin.getFromKey().getTable();
            sourceTable.removeJoin(sourceJoin);
        }
    }

    public SourceField getField(String string) {
        return this.sourceFields.get(StringFunc.identifierHashKey(string));
    }

    public void addField(SourceField sourceField) {
        this.sourceFields.put(StringFunc.identifierHashKey(sourceField.getColumnName()), sourceField);
    }

    public void addFieldWithIndex(SourceField sourceField) {
        this.sourceFields.put(StringFunc.identifierHashKey(sourceField.getColumnName()) + sourceField.ordinalPosition, sourceField);
    }

    public void removeField(String string) {
        this.sourceFields.remove(StringFunc.identifierHashKey(string));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(5000);
        stringBuilder.append("Table: " + this.tableName + "  Schema: " + this.schemaName + "  Catalog: " + this.catalogName + "\n");
        stringBuilder.append("   Number of tuples: " + this.numTuples + "\n");
        Iterator<SourceField> iterator = this.fieldIterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toShortString() + "\n");
        }
        if (this.primaryKey != null) {
            stringBuilder.append("Primary key: " + this.primaryKey + "\n");
        }
        if (this.foreignKeys != null && this.foreignKeys.size() > 0) {
            stringBuilder.append("Foreign Keys:\n");
            for (int i = 0; i < this.foreignKeys.size(); ++i) {
                stringBuilder.append(this.foreignKeys.get(i) + "\n");
            }
        }
        return stringBuilder.toString();
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("        <tableName>" + CommonMethods.exportString(this.tableName) + "</tableName>\n");
        stringBuilder.append("        <schemaName>" + CommonMethods.exportString(this.schemaName) + "</schemaName>\n");
        stringBuilder.append("        <catalogName>" + CommonMethods.exportString(this.catalogName) + "</catalogName>\n");
        stringBuilder.append("        <comment>" + CommonMethods.exportString(this.comment) + "</comment>\n");
        stringBuilder.append("        <numTuples>" + this.numTuples + "</numTuples>");
        if (this.properties != null && this.properties.size() > 0) {
            stringBuilder.append("\n        <properties>" + StringFunc.encodeProperties(this.properties) + "</properties>");
        }
        return stringBuilder.toString();
    }

    public ArrayList<SourceField> getSourceFieldList() {
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(this.sourceFields.size());
        for (Map.Entry<String, SourceField> entry : this.sourceFields.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public ArrayList<SourceField> getSourceFieldsByName() {
        ArrayList<SourceField> arrayList = this.getSourceFieldList();
        Collections.sort(arrayList, SourceField.SourceFieldNameComparator);
        return arrayList;
    }

    public ArrayList<SourceField> getSourceFieldsByPosition() {
        ArrayList<SourceField> arrayList = this.getSourceFieldList();
        Collections.sort(arrayList, SourceField.SourceFieldPositionComparator);
        return arrayList;
    }

    public Iterator<SourceField> fieldIterator() {
        return new PositionIterator();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void setProperties(LinkedHashMap<String, Object> linkedHashMap) {
        this.properties = linkedHashMap;
    }

    class PositionIterator
    implements Iterator<SourceField> {
        private int pos = 0;
        private ArrayList<SourceField> fieldsInOrder;
        private int count = 0;

        public PositionIterator() {
            if (SourceTable.this.sourceFields == null) {
                return;
            }
            this.count = SourceTable.this.sourceFields.size();
            this.fieldsInOrder = SourceTable.this.getSourceFieldsByPosition();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.count;
        }

        @Override
        public SourceField next() {
            if (this.pos >= this.count) {
                return null;
            }
            return this.fieldsInOrder.get(this.pos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(UnityDriver.i18n.getString("SourceTable.noRemoveIterator"));
        }
    }
}

