/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;

public class F_Trim
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression expr;
    private int direction;
    private Expression trimChars;
    public static final String LEADING = "LEADING";
    public static final String TRAILING = "TRAILING";
    public static final String BOTH = "BOTH";
    public static final int LEADING_VAL = 1;
    public static final int TRAILING_VAL = 2;
    public static final int BOTH_VAL = 3;

    public F_Trim(Expression expression, String string, Expression expression2) {
        this.expr = expression;
        this.direction = string.equals(LEADING) ? 1 : (string.equals(TRAILING) ? 2 : 3);
        this.trimChars = expression2;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        int n;
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        String string = object.toString();
        if (this.direction == 3 && this.trimChars == null) {
            return string.trim();
        }
        String string2 = this.trimChars == null ? " " : (String)this.trimChars.evaluate(tuple);
        int n2 = 0;
        int n3 = string.length() - 1;
        if (this.direction == 3 || this.direction == 1) {
            for (n = 0; n < string.length() && string2.indexOf(string.charAt(n)) != -1; ++n) {
            }
            n2 = n;
        }
        if (this.direction == 3 || this.direction == 2) {
            for (n = string.length() - 1; n > n2 && string2.indexOf(string.charAt(n)) != -1; --n) {
            }
            n3 = n;
        }
        return string.substring(n2, n3 + 1);
    }

    @Override
    public int getReturnType() {
        return 12;
    }

    public static int[] getParamListTypes() {
        return new int[]{12, 12, 12};
    }

    public static String getFunctionName() {
        return "TRIM";
    }

    @Override
    public String toString(Relation relation) {
        if (this.direction == 3 && this.trimChars == null) {
            return "TRIM(" + this.expr.toString(relation) + ")";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("TRIM(");
        if (this.direction == 2) {
            stringBuffer.append("TRAILING ");
        } else if (this.direction == 1) {
            stringBuffer.append("LEADING ");
        }
        if (this.trimChars != null) {
            stringBuffer.append(this.trimChars.toString(relation) + " ");
        }
        stringBuffer.append("FROM " + this.expr.toString(relation) + ")");
        return stringBuffer.toString();
    }
}

