/*
 * Decompiled with CFR 0.152.
 */
package unity.mapping;

import java.util.ArrayList;
import org.w3c.dom.Node;
import unity.annotation.CommonMethods;
import unity.mapping.FunctionParam;

public class GlobalFunction {
    private int id;
    private int unityId;
    private String name;
    private String signature;
    private String exprText;
    private String description;
    private ArrayList<FunctionParam> param;
    private int returnType;
    private boolean sqlStandard;

    public String getDescription() {
        return this.description;
    }

    public boolean isSqlStandard() {
        return this.sqlStandard;
    }

    public String getKey() {
        if (this.signature == null || this.signature.trim().equals("")) {
            return this.name.toUpperCase();
        }
        return this.signature;
    }

    public int getId() {
        return this.id;
    }

    public int getUnityId() {
        return this.unityId;
    }

    public void importXML(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (string.equals("Id")) {
                this.id = CommonMethods.getIntName(node2);
                continue;
            }
            if (string.equals("UnityId")) {
                this.unityId = CommonMethods.getIntName(node2);
                continue;
            }
            if (string.equals("Name")) {
                this.name = CommonMethods.getName(node2);
                continue;
            }
            if (string.equals("Signature")) {
                this.signature = CommonMethods.getName(node2);
                continue;
            }
            if (string.equals("ExprText")) {
                this.exprText = CommonMethods.getName(node2);
                continue;
            }
            if (string.equals("ReturnType")) {
                this.returnType = CommonMethods.getIntName(node2);
                continue;
            }
            if (string.equals("isStandard")) {
                this.sqlStandard = CommonMethods.getName(node2).contains("tr");
                continue;
            }
            if (string.equals("Desc")) {
                this.description = CommonMethods.getName(node2);
                continue;
            }
            if (!string.equals("Params")) continue;
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                FunctionParam functionParam = new FunctionParam();
                functionParam.importXML(node3);
                if (this.param == null) {
                    this.param = new ArrayList();
                }
                this.param.add(functionParam);
            }
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public String getExprText() {
        return this.exprText;
    }

    public void setExprText(String string) {
        this.exprText = string;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public void setReturnType(int n) {
        this.returnType = n;
    }
}

