/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;

public class AppendOp
extends Operator {
    private static final long serialVersionUID = 1L;
    private Operator firstOp;
    private Operator secondOp;
    private boolean firstOpDone;

    public AppendOp(Operator operator, Operator operator2) {
        super(new Operator[]{operator, operator2}, 0L);
        this.firstOp = operator;
        this.secondOp = operator2;
        this.setOutputRelation(this.firstOp.getOutputRelation());
    }

    @Override
    public void init() throws SQLException {
        this.firstOp.init();
        this.firstOpDone = false;
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (!this.firstOpDone) {
            if (this.firstOp.next(tuple)) {
                this.incrementRowsOut();
                return true;
            }
            this.firstOp.close();
            this.firstOpDone = true;
            this.secondOp.init();
        }
        if (this.secondOp.next(tuple)) {
            this.incrementRowsOut();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.secondOp.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("APPEND ROWS: ");
        return stringBuffer.toString();
    }

    @Override
    public String getName() {
        return "APPEND";
    }

    @Override
    public String getDescription() {
        return UnityDriver.i18n.getString("AppendOp.Description");
    }
}

