/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.predicates.SortComparator;
import unity.query.LQNode;

public class SortGrouper
extends Operator {
    private static final long serialVersionUID = 1L;
    protected Expression[] expressionList;
    protected Aggregate_Function[] functionList;
    protected SortComparator sorter;
    private Operator input;
    private Tuple lastTupleRead;
    private boolean success;
    private Tuple saved;
    private boolean processedATuple;

    public SortGrouper(Operator operator, SortComparator sortComparator, Expression[] expressionArray, Aggregate_Function[] aggregate_FunctionArray, Relation relation, LQNode lQNode) {
        super(new Operator[]{operator}, 0L);
        this.input = operator;
        this.sorter = sortComparator;
        this.queryNode = lQNode;
        this.expressionList = expressionArray;
        this.functionList = aggregate_FunctionArray;
        this.lastTupleRead = new Tuple(relation);
        this.saved = new Tuple(relation);
        this.setOutputRelation(relation);
        this.processedATuple = false;
    }

    @Override
    public void init() throws SQLException {
        this.input.init();
        this.success = this.input.next(this.lastTupleRead);
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        int n;
        if (!this.success) {
            if (this.expressionList.length == 0 && !this.processedATuple) {
                Object[] objectArray = new Object[this.functionList.length];
                for (int i = 0; i < this.functionList.length; ++i) {
                    objectArray[i] = this.functionList[i].compute();
                    this.functionList[i].reset();
                }
                tuple.setValues(objectArray);
                this.processedATuple = true;
                return true;
            }
            return false;
        }
        this.saved.copy(this.lastTupleRead);
        this.processedATuple = true;
        do {
            for (int i = 0; i < this.functionList.length; ++i) {
                this.functionList[i].add(this.lastTupleRead);
            }
            this.success = this.input.next(this.lastTupleRead);
        } while (this.success && (this.sorter == null || this.sorter.sqlcompare(this.saved, this.lastTupleRead) == 0));
        Object[] objectArray = new Object[this.expressionList.length + this.functionList.length];
        for (n = 0; n < this.expressionList.length; ++n) {
            objectArray[n] = this.expressionList[n].evaluate(this.saved);
        }
        for (n = 0; n < this.functionList.length; ++n) {
            objectArray[n + this.expressionList.length] = this.functionList[n].compute();
            this.functionList[n].reset();
        }
        this.incrementRowsOut();
        tuple.setValues(objectArray);
        return true;
    }

    public String toString() {
        int n;
        Relation relation = this.input.getOutputRelation();
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("SORTGROUP: GroupBy=");
        if (this.expressionList == null || this.expressionList.length == 0) {
            stringBuilder.append("(none)");
        } else {
            stringBuilder.append(this.expressionList[0].toString(relation));
            for (n = 1; n < this.expressionList.length; ++n) {
                stringBuilder.append(", " + this.expressionList[n].toString(relation));
            }
        }
        stringBuilder.append(" Aggregates: ");
        if (this.functionList.length == 0) {
            stringBuilder.append("(none)");
        } else {
            for (n = 0; n < this.functionList.length; ++n) {
                stringBuilder.append(this.functionList[n].toString(relation, this.outputRelation.getAttribute(this.expressionList.length + n)) + " ");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "SORT GROUPING";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public double getCost() {
        long l = this.input.getRows();
        return (double)l * 1.0;
    }
}

