/*
 * Decompiled with CFR 0.152.
 */
package unity.parser;

import java.io.Serializable;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.annotation.SourceView;
import unity.jdbc.UnityDriver;
import unity.mapping.DatabaseMapping;
import unity.mapping.GlobalFunction;
import unity.parser.ASTAs;
import unity.parser.ASTAscToken;
import unity.parser.ASTCreate;
import unity.parser.ASTDelete;
import unity.parser.ASTDscToken;
import unity.parser.ASTExcept;
import unity.parser.ASTExplain;
import unity.parser.ASTFrom;
import unity.parser.ASTFunction;
import unity.parser.ASTInsert;
import unity.parser.ASTInsertFields;
import unity.parser.ASTIntersect;
import unity.parser.ASTInto;
import unity.parser.ASTJoinExpr;
import unity.parser.ASTLimit;
import unity.parser.ASTMyID;
import unity.parser.ASTNP;
import unity.parser.ASTSelect;
import unity.parser.ASTStart;
import unity.parser.ASTSubquery;
import unity.parser.ASTUnion;
import unity.parser.ASTUpdate;
import unity.parser.ASTValues;
import unity.parser.GlobalParser;
import unity.parser.LQTreeBuilder;
import unity.parser.Node;
import unity.parser.ParsedIdentifier;
import unity.parser.SimpleNode;
import unity.parser.TokenMgrError;
import unity.parser.uql;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LQCondNode;
import unity.query.LQCreateViewNode;
import unity.query.LQDeleteNode;
import unity.query.LQExceptNode;
import unity.query.LQExprNode;
import unity.query.LQInsertNode;
import unity.query.LQIntersectNode;
import unity.query.LQLimitNode;
import unity.query.LQNPNode;
import unity.query.LQNode;
import unity.query.LQTree;
import unity.query.LQUnionNode;
import unity.query.LQUpdateNode;
import unity.query.Optimizer;
import unity.query.SubQuery;
import unity.util.StringFunc;

public class PTreeBuilderValidater {
    private ASTStart parseTreeRoot;
    private GlobalSchema gs;
    private boolean processAsSubquery = false;
    private boolean schemaValidation = true;
    private AnnotatedSourceDatabase database;

    public PTreeBuilderValidater(GlobalSchema globalSchema, boolean bl) {
        this.gs = globalSchema;
        this.schemaValidation = bl;
    }

    public PTreeBuilderValidater(GlobalSchema globalSchema, boolean bl, AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.gs = globalSchema;
        this.schemaValidation = bl;
        this.database = annotatedSourceDatabase;
    }

    public void setProcessAsSubquery(boolean bl) {
        this.processAsSubquery = bl;
    }

    public SimpleNode buildPTree(String string) throws SQLException {
        try {
            StringReader stringReader = new StringReader(string);
            uql uql2 = new uql(stringReader);
            uql2.parseString();
            this.parseTreeRoot = uql2.gettree();
            return this.parseTreeRoot;
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ParseError") + exception);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ParseError") + tokenMgrError);
        }
    }

    public GlobalUpdate validateUpdate(SimpleNode simpleNode) throws SQLException {
        GlobalUpdate globalUpdate = new GlobalUpdate();
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode2 instanceof ASTDelete) {
            this.processDelete(simpleNode2, globalUpdate);
        } else if (simpleNode2 instanceof ASTInsert) {
            this.processInsert(simpleNode2, globalUpdate);
        } else if (simpleNode2 instanceof ASTUpdate) {
            this.processUpdate(simpleNode2, globalUpdate);
        } else if (simpleNode2 instanceof ASTCreate) {
            this.processCreate(simpleNode2, globalUpdate);
        } else {
            throw new SQLException("Invalid SQL statement entered.");
        }
        globalUpdate.getPlan().getLogicalQueryTree().getRoot().setDatabase(null, false);
        return globalUpdate;
    }

    private void processDelete(SimpleNode simpleNode, GlobalUpdate globalUpdate) throws SQLException {
        LQDeleteNode lQDeleteNode = new LQDeleteNode();
        SubQuery subQuery = new SubQuery();
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        this.processTableReferences(simpleNode2, subQuery);
        if (subQuery.getNumTableRef() > 1) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorOnlyOneFromTable"));
        }
        GQTableRef gQTableRef = subQuery.getFirstTableRef();
        if (gQTableRef.getAliasName() == null) {
            // empty if block
        }
        this.addAllFieldsForTables(subQuery.getTableRefs(), subQuery);
        this.ValidateFields(simpleNode, subQuery);
        if (simpleNode.jjtGetNumChildren() > 1) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(1);
            LQTreeBuilder lQTreeBuilder = new LQTreeBuilder(subQuery, this.gs);
            LQCondNode lQCondNode = lQTreeBuilder.buildConditionNode((SimpleNode)simpleNode3.jjtGetChild(0), 20, null, subQuery.getFieldRefs());
            lQDeleteNode.setCondition(lQCondNode);
            GQDatabaseRef gQDatabaseRef = lQCondNode.setDatabase(null, false);
            if (gQDatabaseRef == GQDatabaseRef.UNITYJDBC_DBREF) {
                if (lQCondNode.getType() == 114 && lQCondNode.getChild(1).getType() == 17) {
                    SubQuery subQuery2 = (SubQuery)lQCondNode.getChild(1).getContent();
                    GlobalQuery globalQuery = new GlobalQuery();
                    globalQuery.addSubQuery(subQuery2);
                    globalQuery.setLogicalQueryTree(subQuery2.getLogicalQueryTree());
                    lQDeleteNode.setNestedQuery(globalQuery);
                    globalUpdate.setHasGlobalSubQuery(true);
                    globalUpdate.addSubQuery(globalQuery);
                } else {
                    throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorDeleteSubquery"));
                }
            }
        }
        gQTableRef = subQuery.getFirstTableRef();
        lQDeleteNode.setSourceTable(gQTableRef);
        subQuery.setLogicalQueryTree(new LQTree(lQDeleteNode));
        globalUpdate.setPlan(subQuery);
        globalUpdate.setDatabase(gQTableRef.getParentDB().getDatabase());
        globalUpdate.setType(20);
    }

    private void processInsert(SimpleNode simpleNode, GlobalUpdate globalUpdate) throws SQLException {
        Serializable serializable;
        Object object;
        SimpleNode simpleNode2;
        int n;
        LQInsertNode lQInsertNode = new LQInsertNode();
        SubQuery subQuery = new SubQuery();
        SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(0);
        this.processTableReferences(simpleNode3, subQuery);
        GQTableRef gQTableRef = subQuery.getFirstTableRef();
        if (gQTableRef.getAliasName() == null) {
            // empty if block
        }
        int n2 = 0;
        int n3 = 0;
        SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(1);
        if (simpleNode4 instanceof ASTInsertFields) {
            for (n = 0; n < simpleNode4.jjtGetNumChildren(); ++n) {
                simpleNode2 = (SimpleNode)simpleNode4.jjtGetChild(n);
                object = simpleNode2.toString();
                if (!((String)object).startsWith("Identifier: ")) continue;
                serializable = this.validateField(((String)object).substring(12, ((String)object).length()), subQuery, null, simpleNode2);
                lQInsertNode.addField((GQFieldRef)serializable);
                ++n2;
            }
            simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(2);
        }
        if (n2 == 0) {
            this.addAllFieldsForTables(subQuery.getTableRefs(), subQuery);
            lQInsertNode.addFields(subQuery.getFirstTableRef(), subQuery.getFieldRefs());
            n2 = subQuery.getNumFieldRef();
        }
        if (simpleNode4 instanceof ASTValues) {
            object = new LQTreeBuilder(subQuery, this.gs);
            for (n = 0; n < simpleNode4.jjtGetNumChildren(); ++n) {
                simpleNode2 = (SimpleNode)simpleNode4.jjtGetChild(n);
                serializable = ((LQTreeBuilder)object).BuildExpressionNode(22, simpleNode2, null, subQuery.getFieldRefs());
                lQInsertNode.addValue((LQExprNode)serializable);
                ++n3;
            }
            if (n2 != n3 && this.schemaValidation) {
                throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorInsertFieldListValuesDoNotMatch"));
            }
        } else {
            object = new PTreeBuilderValidater(this.gs, this.schemaValidation);
            GlobalQuery globalQuery = ((PTreeBuilderValidater)object).buildLQTree(simpleNode4, false);
            lQInsertNode.setNestedQuery(globalQuery);
            globalUpdate.addSubQuery(globalQuery);
            globalUpdate.checkGlobalQuery();
        }
        lQInsertNode.setSourceTable(subQuery.getFirstTableRef());
        subQuery.setLogicalQueryTree(new LQTree(lQInsertNode));
        globalUpdate.setPlan(subQuery);
        globalUpdate.setDatabase((AnnotatedSourceDatabase)lQInsertNode.getSourceTable().getTable().getParentDatabase());
        globalUpdate.setType(22);
    }

    private void processUpdate(SimpleNode simpleNode, GlobalUpdate globalUpdate) throws SQLException {
        Serializable serializable;
        LQNode lQNode;
        Object object;
        LQUpdateNode lQUpdateNode = new LQUpdateNode();
        SubQuery subQuery = new SubQuery();
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        this.processTableReferences(simpleNode2, subQuery);
        if (subQuery.getNumTableRef() > 1) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorOnlyOneFromTable"));
        }
        GQTableRef gQTableRef = subQuery.getFirstTableRef();
        if (gQTableRef.getAliasName() == null) {
            // empty if block
        }
        LQTreeBuilder lQTreeBuilder = new LQTreeBuilder(subQuery, this.gs);
        boolean bl = false;
        if (simpleNode.jjtGetNumChildren() > 2) {
            for (int i = 2; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (simpleNode3 instanceof ASTFrom) {
                    this.processTableReferences(simpleNode3, subQuery);
                    if (subQuery.getNumDBRef() <= 1) continue;
                    globalUpdate.setHasGlobalSubQuery(true);
                    continue;
                }
                this.addAllFieldsForTables(subQuery.getTableRefs(), subQuery);
                this.ValidateFields(simpleNode, subQuery);
                bl = true;
                object = simpleNode3;
                lQNode = lQTreeBuilder.buildConditionNode((SimpleNode)((SimpleNode)object).jjtGetChild(0), 20, null, subQuery.getFieldRefs());
                lQUpdateNode.setCondition((LQCondNode)lQNode);
                serializable = lQNode.setDatabase(null, false);
                if (serializable != GQDatabaseRef.UNITYJDBC_DBREF) continue;
                globalUpdate.setHasGlobalSubQuery(true);
            }
        }
        if (!bl) {
            this.addAllFieldsForTables(subQuery.getTableRefs(), subQuery);
            this.ValidateFields(simpleNode, subQuery);
        }
        SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(1);
        for (int i = 0; i < simpleNode4.jjtGetNumChildren(); ++i) {
            object = (SimpleNode)simpleNode4.jjtGetChild(i);
            if (!((SimpleNode)object).toString().equals("Comparison_Op: =")) {
                throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorInsertSetClauseSyntax"));
            }
            lQNode = lQTreeBuilder.BuildExpressionNode(21, (SimpleNode)((SimpleNode)object).jjtGetChild(0), null, subQuery.getFieldRefs());
            serializable = lQTreeBuilder.BuildExpressionNode(21, (SimpleNode)((SimpleNode)object).jjtGetChild(1), null, subQuery.getFieldRefs());
            lQUpdateNode.addSet((LQExprNode)lQNode, (LQExprNode)serializable);
        }
        gQTableRef = subQuery.getFirstTableRef();
        lQUpdateNode.setTable(gQTableRef);
        subQuery.setLogicalQueryTree(new LQTree(lQUpdateNode));
        globalUpdate.setPlan(subQuery);
        globalUpdate.setDatabase(gQTableRef.getParentDB().getDatabase());
        globalUpdate.setType(21);
        if (globalUpdate.hasGlobalSubQuery() && this.schemaValidation) {
            lQUpdateNode.buildSQ(globalUpdate);
            GlobalParser globalParser = new GlobalParser(false, this.schemaValidation);
            object = globalParser.parse(lQUpdateNode.getSubqueryString(), this.gs);
            globalUpdate.addSubQuery((GlobalQuery)object);
        }
    }

    private void processCreate(SimpleNode simpleNode, GlobalUpdate globalUpdate) throws SQLException {
        SimpleNode simpleNode2;
        LQCreateViewNode lQCreateViewNode = new LQCreateViewNode();
        SubQuery subQuery = new SubQuery();
        SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(0);
        SimpleNode simpleNode4 = (SimpleNode)simpleNode3.jjtGetChild(0);
        String string = simpleNode4.toString().substring(12);
        lQCreateViewNode.setViewName(string);
        if (this.gs.tableExists("unity", string)) {
            throw new SQLException(UnityDriver.i18n.getString("Evaluator.ViewExists") + string);
        }
        SimpleNode simpleNode5 = simpleNode2 = (SimpleNode)simpleNode3.jjtGetChild(1);
        boolean bl = false;
        if (simpleNode2 instanceof ASTInsertFields) {
            bl = true;
            simpleNode2 = (SimpleNode)simpleNode3.jjtGetChild(2);
        }
        PTreeBuilderValidater pTreeBuilderValidater = new PTreeBuilderValidater(this.gs, this.schemaValidation);
        pTreeBuilderValidater.setProcessAsSubquery(true);
        GlobalQuery globalQuery = pTreeBuilderValidater.buildLQTree(simpleNode2, false);
        Optimizer optimizer = new Optimizer(globalQuery, false, null);
        globalQuery = optimizer.optimize();
        lQCreateViewNode.setNestedQuery(globalQuery);
        globalUpdate.addSubQuery(globalQuery);
        globalUpdate.setHasGlobalSubQuery(true);
        ArrayList<GQFieldRef> arrayList = globalQuery.getSubQueries().get(0).getOutputFieldReferences();
        if (bl) {
            if (arrayList.size() != simpleNode5.jjtGetNumChildren()) {
                throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorCreateViewFieldList") + arrayList.size() + UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorCreateViewFieldList2") + simpleNode5.jjtGetNumChildren());
            }
            for (int i = 0; i < simpleNode5.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode6 = (SimpleNode)simpleNode5.jjtGetChild(i);
                String string2 = simpleNode6.toString().substring(12);
                GQFieldRef gQFieldRef = new GQFieldRef(arrayList.get(i));
                gQFieldRef.setReferenceName(string2);
                lQCreateViewNode.addField(gQFieldRef);
                System.out.println("Added field name: " + string2 + " field: " + gQFieldRef);
            }
        } else {
            lQCreateViewNode.setFields(arrayList);
        }
        subQuery.setLogicalQueryTree(new LQTree(lQCreateViewNode));
        globalUpdate.setPlan(subQuery);
        globalUpdate.setType(50);
    }

    public GlobalQuery buildLQTree(SimpleNode simpleNode, boolean bl) throws SQLException {
        GlobalQuery globalQuery = new GlobalQuery();
        Object object = null;
        LQTree lQTree = null;
        SubQuery subQuery = null;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            Serializable serializable;
            String string;
            Object object2;
            Node node;
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2 instanceof ASTNP) {
                lQTree = new LQTree(this.processNPNode(simpleNode2));
                subQuery = new SubQuery();
                subQuery.setLogicalQueryTree(lQTree);
                globalQuery.addSubQuery(subQuery);
                object = lQTree.getRoot();
                continue;
            }
            if (simpleNode2 instanceof ASTExplain) continue;
            if (simpleNode2 instanceof ASTLimit) {
                int n = 0;
                int n2 = 0;
                node = simpleNode2.jjtGetChild(0);
                object2 = node.toString();
                string = ((String)object2).substring(((String)object2).indexOf(":") + 1).trim();
                n2 = Integer.parseInt(string);
                if (simpleNode2.jjtGetNumChildren() > 1) {
                    object2 = simpleNode2.jjtGetChild(1).toString();
                    string = ((String)object2).substring(((String)object2).indexOf(":") + 1).trim();
                    n = Integer.parseInt(string);
                }
                serializable = new LQLimitNode(n, n2);
                serializable.addChild((LQNode)object);
                object = serializable;
                if (lQTree == null) continue;
                lQTree.setRoot((LQNode)serializable);
                continue;
            }
            if (!(simpleNode2 instanceof ASTSelect) && !(simpleNode2 instanceof ASTUnion) && !(simpleNode2 instanceof ASTIntersect) && !(simpleNode2 instanceof ASTExcept)) continue;
            subQuery = new SubQuery();
            LQTreeBuilder lQTreeBuilder = new LQTreeBuilder();
            SimpleNode simpleNode3 = simpleNode2 instanceof ASTSelect ? (SimpleNode)((SimpleNode)simpleNode.jjtGetChild((int)i)).parent : (SimpleNode)simpleNode.jjtGetChild(i);
            node = this.ParseQuery(simpleNode3, subQuery, this.processAsSubquery);
            lQTree = node instanceof ASTNP ? new LQTree(this.processNPNode((SimpleNode)node)) : lQTreeBuilder.BuildLQTree(subQuery, simpleNode3, this.gs, bl);
            subQuery.setLogicalQueryTree(lQTree);
            globalQuery.addSubQuery(subQuery);
            if (simpleNode2 instanceof ASTSelect || simpleNode2 instanceof ASTNP) {
                object = lQTree.getRoot();
                continue;
            }
            if (!(simpleNode2 instanceof ASTUnion) && !(simpleNode2 instanceof ASTIntersect) && !(simpleNode2 instanceof ASTExcept)) continue;
            object2 = null;
            string = "";
            if (simpleNode2 instanceof ASTUnion) {
                boolean bl2 = ((ASTUnion)simpleNode2).getType().equals("ALL");
                object2 = new LQUnionNode(bl2);
                string = "UNION";
            } else if (simpleNode2 instanceof ASTIntersect) {
                object2 = new LQIntersectNode();
                string = "INTERSECT";
            } else if (simpleNode2 instanceof ASTExcept) {
                object2 = new LQExceptNode();
                string = "EXCEPT";
            }
            ((LQNode)object2).addChild((LQNode)object);
            ((LQNode)object2).addChild(lQTree.getRoot());
            ((LQNode)object2).setDatabase(null, false);
            serializable = ((LQNode)object2).getDatabase();
            if (serializable != GQDatabaseRef.UNITYJDBC_DBREF && DatabaseMapping.isSupported(string, (GQDatabaseRef)serializable, null) == 1) {
                ArrayList<SubQuery> arrayList = globalQuery.getSubQueries();
                arrayList.remove(arrayList.size() - 1);
                SubQuery subQuery2 = arrayList.get(arrayList.size() - 1);
                subQuery2.merge(subQuery);
                subQuery2.setParseNodeRoot(simpleNode2);
                lQTree = subQuery2.getLogicalQueryTree();
                lQTree.setRoot((LQNode)object2);
            }
            object = object2;
        }
        globalQuery.setLogicalQueryTree(new LQTree((LQNode)object));
        return globalQuery;
    }

    private LQNPNode processNPNode(SimpleNode simpleNode) throws SQLException {
        if (simpleNode.jjtGetNumChildren() != 3) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNPSyntax"));
        }
        String string = simpleNode.jjtGetChild(0).toString();
        string = string.substring(9, string.length() - 1);
        String string2 = simpleNode.jjtGetChild(1).toString();
        string2 = string2.substring(9, string2.length() - 1);
        String string3 = simpleNode.jjtGetChild(2).toString();
        int n = Integer.parseInt(string3.substring(9, string3.length()));
        AnnotatedSourceDatabase annotatedSourceDatabase = this.gs.getDB(string.toLowerCase());
        if (annotatedSourceDatabase == null) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNonExistingDB") + string);
        }
        GQDatabaseRef gQDatabaseRef = new GQDatabaseRef(annotatedSourceDatabase, string);
        LQNPNode lQNPNode = new LQNPNode(string, string2, n, gQDatabaseRef);
        return lQNPNode;
    }

    public SimpleNode ParseQuery(SimpleNode simpleNode, SubQuery subQuery, boolean bl) throws SQLException {
        Object object;
        int n;
        SimpleNode simpleNode2 = null;
        boolean bl2 = false;
        for (n = 0; n < simpleNode.jjtGetNumChildren(); ++n) {
            if (simpleNode.jjtGetChild(n) instanceof ASTSelect) {
                simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n);
            } else if (simpleNode.jjtGetChild(n) instanceof ASTNP) {
                return (SimpleNode)simpleNode.jjtGetChild(n);
            }
            if (!(simpleNode.jjtGetChild(n) instanceof ASTFrom)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            object = (SimpleNode)simpleNode.jjtGetChild(n);
            this.processTableReferences((SimpleNode)object, subQuery);
        }
        this.ValidateFields(simpleNode, subQuery);
        if (bl) {
            this.computeOutputFields(simpleNode2, subQuery);
        }
        if (simpleNode2 != null && ((ASTSelect)simpleNode2).getAll()) {
            if (this.schemaValidation) {
                this.addAllFieldsForTables(subQuery.getTableRefs(), subQuery);
            } else {
                object = subQuery.getFirstTableRef();
                String string = "*";
                AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField();
                annotatedSourceField.setColumnName(string);
                annotatedSourceField.setOrdinalPosition(1);
                ((GQTableRef)object).getTable().addField(annotatedSourceField);
                GQFieldRef gQFieldRef = new GQFieldRef(annotatedSourceField, string, (GQTableRef)object);
                subQuery.addFieldRef(StringFunc.identifierHashKey(string), gQFieldRef);
            }
        }
        return simpleNode2;
    }

    private String[] processAsRenaming(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.parent;
        if (simpleNode2 == null) {
            return null;
        }
        int n = simpleNode2.findChild(simpleNode);
        if (n < simpleNode2.jjtGetNumChildren() - 1 && ((SimpleNode)simpleNode2.jjtGetChild(n + 1)).toString().equals("As")) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(n + 1);
            Node node = simpleNode2.jjtGetChild(n);
            node.jjtSetParent(simpleNode3);
            simpleNode2.jjtRemoveChild(n);
            simpleNode3.InsertChild(0, node);
            String string = simpleNode3.jjtGetChild(1).toString();
            string = string.substring(12, string.length());
            String[] stringArray = new String[]{string, string};
            return stringArray;
        }
        return null;
    }

    private void processTableRef(SimpleNode simpleNode, SubQuery subQuery) throws SQLException {
        String string;
        String string2;
        GQDatabaseRef gQDatabaseRef;
        AnnotatedSourceTable annotatedSourceTable = this.parseTableIdentifier(simpleNode);
        AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)annotatedSourceTable.getParentDatabase();
        if (annotatedSourceDatabase.getDatabaseName().equals("unity") && annotatedSourceTable instanceof SourceView) {
            String string3 = ((SourceView)annotatedSourceTable).getQuery();
            PTreeBuilderValidater pTreeBuilderValidater = new PTreeBuilderValidater(this.gs, this.schemaValidation);
            SimpleNode simpleNode2 = pTreeBuilderValidater.buildPTree(string3);
            GQTableRef gQTableRef = this.processSubqueryRef(simpleNode2, subQuery, annotatedSourceTable.getTableName(), annotatedSourceTable);
            simpleNode.setReference(gQTableRef);
            return;
        }
        String[] stringArray = this.processAsRenaming(simpleNode);
        if (stringArray == null) {
            stringArray = new String[]{annotatedSourceTable.getLookupName(), null};
        }
        if ((gQDatabaseRef = subQuery.getDBRef(string2 = StringFunc.identifierHashKey(string = annotatedSourceTable.getParentDatabase().getDatabaseName()))) == null) {
            gQDatabaseRef = new GQDatabaseRef(annotatedSourceDatabase, string);
            subQuery.addDatabaseRef(string2, gQDatabaseRef);
        }
        GQTableRef gQTableRef = new GQTableRef(annotatedSourceTable, stringArray[0], stringArray[1], gQDatabaseRef);
        String string4 = StringFunc.identifierHashKey(stringArray[0]);
        subQuery.addTableRef(string4, gQTableRef);
        simpleNode.setReference(gQTableRef);
    }

    private void processNPFunc(SimpleNode simpleNode, SubQuery subQuery) throws SQLException {
        Serializable serializable;
        Object object;
        LQTreeBuilder lQTreeBuilder;
        LQExprNode lQExprNode;
        LQExprNode lQExprNode2;
        String string = simpleNode.toString();
        if (!string.contains("np") && !string.contains("NP")) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorOnlyNPInFrom") + string);
        }
        String[] stringArray = this.processAsRenaming(simpleNode);
        if (stringArray == null) {
            stringArray = new String[]{"T" + (subQuery.getNumTableRef() + 1), null};
        }
        if ((lQExprNode2 = (LQExprNode)(lQExprNode = (lQTreeBuilder = new LQTreeBuilder(subQuery, this.gs)).BuildExpressionNode(1, simpleNode, null, null)).getChild(0)) == null) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNPDBFirstParam"));
        }
        String string2 = StringFunc.identifierHashKey(StringFunc.removeQuotes(lQExprNode2.generateSQL()));
        AnnotatedSourceDatabase annotatedSourceDatabase = this.gs.getDB(string2);
        if (annotatedSourceDatabase == null) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNPDBNotDefined") + string2);
        }
        LQExprNode lQExprNode3 = (LQExprNode)lQExprNode.getChild(1);
        if (lQExprNode3 == null) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNPSQLSecondParam"));
        }
        String string3 = StringFunc.removeQuotes(lQExprNode3.getContent().toString());
        string3 = string3.replaceAll("~", "'");
        AnnotatedSourceTable annotatedSourceTable = new AnnotatedSourceTable(null, null, string3, null, new HashMap<String, SourceField>(), null);
        LQExprNode lQExprNode4 = (LQExprNode)lQExprNode.getChild(2);
        if (lQExprNode4 == null) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNPAttrListThirdParam"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(StringFunc.removeQuotes(lQExprNode4.getContent().toString()), ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            serializable = new AnnotatedSourceField(null, null, stringArray[0], (String)object, 12, "VARCHAR", 50, 0, 0, 0, null, null, 0, ++n, null);
            annotatedSourceTable.addField((SourceField)((Object)serializable));
        }
        object = subQuery.getDBRef(string2);
        if (object == null) {
            object = new GQDatabaseRef(annotatedSourceDatabase, string2);
            subQuery.addDatabaseRef(string2, (GQDatabaseRef)object);
        }
        serializable = new GQTableRef(annotatedSourceTable, stringArray[0], stringArray[1], (GQDatabaseRef)object);
        subQuery.addTableRef(StringFunc.identifierHashKey(stringArray[0]), (GQTableRef)serializable);
        simpleNode.setReference(serializable);
    }

    private GQTableRef processSubqueryRef(SimpleNode simpleNode, SubQuery subQuery, String string, AnnotatedSourceTable annotatedSourceTable) throws SQLException {
        this.processAsSubquery = true;
        GlobalQuery globalQuery = this.buildLQTree(simpleNode, false);
        SubQuery subQuery2 = globalQuery.getSubQueries().get(0);
        SubQuery subQuery3 = new SubQuery();
        subQuery3.setOutputFieldReferences(subQuery2.getOutputFieldReferences());
        subQuery3.setLogicalQueryTree(globalQuery.getLogicalQueryTree());
        subQuery3.setParent(subQuery);
        subQuery3.setParseNodeRoot(simpleNode);
        String[] stringArray = this.processAsRenaming(simpleNode);
        if (stringArray == null) {
            stringArray = string == null ? new String[]{"T" + (subQuery.getNumTableRef() + 1), null} : new String[]{string, string};
        }
        GQTableRef gQTableRef = GQTableRef.createTemporaryTableRef(stringArray[0], stringArray[1]);
        AnnotatedSourceTable annotatedSourceTable2 = gQTableRef.getTable();
        gQTableRef.setReference(subQuery3);
        ArrayList<GQFieldRef> arrayList = subQuery3.getOutputFieldReferences();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<SourceField> iterator = null;
        if (annotatedSourceTable != null) {
            iterator = annotatedSourceTable.fieldIterator();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2;
            GQFieldRef gQFieldRef = arrayList.get(i);
            String string3 = string2 = gQFieldRef.getName();
            if (annotatedSourceTable != null && iterator != null) {
                string3 = iterator.next().getColumnName();
            }
            gQFieldRef.setReferenceName(string2);
            AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField();
            annotatedSourceField.setOrdinalPosition(i + 1);
            annotatedSourceField.setColumnName(string2);
            annotatedSourceField.setParentTable(annotatedSourceTable2);
            annotatedSourceTable2.addFieldWithIndex(annotatedSourceField);
            GQFieldRef gQFieldRef2 = new GQFieldRef(annotatedSourceField, string3, gQTableRef);
            arrayList.set(i, gQFieldRef2);
            String string4 = StringFunc.identifierHashKey(string2);
            boolean bl = hashSet.add(string4);
            if (!bl) {
                throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldSubqueryMultipleTimes") + string2 + ' ' + stringArray[0]);
            }
            subQuery.addFieldRef(string4, gQFieldRef2);
            if (UnityDriver.DEBUG) {
                System.out.println("\tAdded field reference: " + string2 + " to parent query.");
            }
            boolean bl2 = true;
            String string5 = string2;
            if (StringFunc.isDelimited(string2, '\"') && !(bl2 = StringFunc.delimitedIdentifier(string5 = StringFunc.undelimitName(string2, '\"').toLowerCase()))) {
                string5 = StringFunc.undelimitName(string2, '\"').toLowerCase();
                subQuery.addFieldRef(StringFunc.identifierHashKey(string5), gQFieldRef2);
                if (UnityDriver.DEBUG) {
                    System.out.println("\tAdded field reference: " + string5 + " to parent query.");
                }
            }
            string2 = stringArray[0] + '.' + string2;
            subQuery.addFieldRef(StringFunc.identifierHashKey(string2), gQFieldRef2);
            if (UnityDriver.DEBUG) {
                System.out.println("\tAdded field reference: " + string2 + " to parent query.");
            }
            if (bl2) continue;
            string5 = stringArray[0] + '.' + string5;
            subQuery.addFieldRef(StringFunc.identifierHashKey(string5), gQFieldRef2);
            if (!UnityDriver.DEBUG) continue;
            System.out.println("\tAdded field reference: " + string5 + " to parent query.");
        }
        subQuery.addTableRef(stringArray[0], gQTableRef);
        subQuery.addDatabaseRefs(subQuery3.getDBRefs());
        simpleNode.setReference(gQTableRef);
        return gQTableRef;
    }

    private void processTableReferences(SimpleNode simpleNode, SubQuery subQuery) throws SQLException {
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2 instanceof ASTMyID) {
                this.processTableRef(simpleNode2, subQuery);
                continue;
            }
            if (simpleNode2 instanceof ASTFunction) {
                this.processNPFunc(simpleNode2, subQuery);
                continue;
            }
            if (simpleNode2 instanceof ASTSubquery) {
                this.processSubqueryRef(simpleNode2, subQuery, null, null);
                continue;
            }
            if (!(simpleNode2 instanceof ASTJoinExpr)) continue;
            String string = simpleNode2.toString().toUpperCase();
            if (string.indexOf("OUTER") >= 0) {
                subQuery.setOuterJoins(2);
            } else if (subQuery.getOuterJoins() == 0) {
                subQuery.setOuterJoins(1);
            }
            this.processTableReferences(simpleNode2, subQuery);
        }
        if (UnityDriver.DEBUG && simpleNode instanceof ASTFrom) {
            HashMap<String, GQTableRef> hashMap = subQuery.getTableRefs();
            for (String string : hashMap.keySet()) {
                GQTableRef gQTableRef = hashMap.get(string);
                if (gQTableRef.getParentDB() != null) {
                    System.out.println(string + " maps to " + gQTableRef.getParentDB().getName() + '.' + gQTableRef.getTable().getFullName());
                    continue;
                }
                System.out.println(string + " maps to " + "subquery table: " + gQTableRef.getReferenceName());
            }
        }
    }

    private void validateStarIdentifier(SimpleNode simpleNode, String string, SubQuery subQuery) throws SQLException {
        Object object;
        String[] stringArray = StringFunc.divideIdentifier(string);
        if (stringArray.length == 2 && (object = subQuery.getDBRef(stringArray[0])) != null) {
            HashMap<String, GQTableRef> hashMap = subQuery.filterTableRefsByDB((GQDatabaseRef)object);
            this.addAllFieldsForTables(hashMap, subQuery);
            String string2 = string.toLowerCase();
            GQFieldRef gQFieldRef = new GQFieldRef(null, string2, null);
            gQFieldRef.setReference(hashMap);
            subQuery.addFieldRef(string2, gQFieldRef);
            simpleNode.setReference(gQFieldRef);
            return;
        }
        GQTableRef gQTableRef = subQuery.getTableRef(stringArray[stringArray.length - 2]);
        if (gQTableRef == null) {
            object = stringArray[0];
            for (int i = 1; i < stringArray.length - 1; ++i) {
                object = object + '.' + stringArray[i];
            }
            gQTableRef = subQuery.getTableRef((String)object);
        }
        if (gQTableRef == null) {
            throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.IdentifierAmbiguous") + string + ' ' + UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNoTableFound"));
        }
        object = new HashMap<String, GQTableRef>();
        ((HashMap)object).put(gQTableRef.getName(), gQTableRef);
        this.addAllFieldsForTables((HashMap<String, GQTableRef>)object, subQuery);
        String string3 = StringFunc.identifierHashKey(string);
        GQFieldRef gQFieldRef = new GQFieldRef(null, string3, null);
        gQFieldRef.setReference(object);
        subQuery.addFieldRef(string3, gQFieldRef);
        simpleNode.setReference(gQFieldRef);
    }

    private GQFieldRef findDelimited(String string, SubQuery subQuery) {
        String[] stringArray = StringFunc.divideIdentifier(string);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (StringFunc.isDelimited(stringArray[i], '\"')) {
                stringArray2[i] = stringArray[i];
                stringArray[i] = StringFunc.undelimitName(stringArray[i], '\"');
                continue;
            }
            stringArray2[i] = "\"" + stringArray[i] + "\"";
        }
        int n = (int)Math.pow(2.0, stringArray.length);
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < n; ++i) {
            stringBuffer.setLength(0);
            int n2 = i;
            for (int j = 0; j < stringArray.length; ++j) {
                if (j != 0) {
                    stringBuffer.append('.');
                }
                if (n2 % 2 == 0) {
                    stringBuffer.append(stringArray[j]);
                } else {
                    stringBuffer.append(stringArray2[j]);
                }
                n2 /= 2;
            }
            GQFieldRef gQFieldRef = subQuery.getFieldRef(StringFunc.identifierHashKey(stringBuffer.toString()));
            if (gQFieldRef == null) continue;
            return gQFieldRef;
        }
        return null;
    }

    private GQFieldRef validateField(String string, SubQuery subQuery, String string2, SimpleNode simpleNode) throws SQLException {
        AnnotatedSourceField annotatedSourceField = null;
        String string3 = null;
        GQTableRef gQTableRef = null;
        String string4 = string;
        boolean bl = false;
        GQFieldRef gQFieldRef = subQuery.getFieldRef(StringFunc.identifierHashKey(string));
        if (gQFieldRef == null) {
            gQFieldRef = this.findDelimited(string, subQuery);
        }
        if (!this.schemaValidation && gQFieldRef == null) {
            String[] stringArray = StringFunc.divideIdentifier(string);
            String string5 = stringArray[stringArray.length - 1];
            gQTableRef = null;
            if (stringArray.length > 1) {
                String string6;
                string3 = stringArray[0];
                gQTableRef = subQuery.getTableRef(StringFunc.identifierHashKey(string3));
                if (gQTableRef == null) {
                    string6 = StringFunc.identifierHashKey(subQuery.getFirstDatabaseRef().getName() + '.' + string3);
                    gQTableRef = subQuery.getTableRef(string6);
                }
                if (gQTableRef == null) {
                    string6 = StringFunc.identifierHashKey(subQuery.getFirstDatabaseRef().getName() + '.' + StringFunc.delimitName(string3, '\"'));
                    gQTableRef = subQuery.getTableRef(string6);
                }
                if (gQTableRef == null) {
                    string5 = string;
                } else {
                    string5 = stringArray[1];
                    for (int i = 2; i < stringArray.length; ++i) {
                        string5 = string5 + "." + stringArray[i];
                    }
                }
            }
            if (gQTableRef == null) {
                gQTableRef = subQuery.getFirstTableRef();
                string3 = gQTableRef != null ? gQTableRef.getName() : "notable";
            }
            AnnotatedSourceField annotatedSourceField2 = new AnnotatedSourceField();
            annotatedSourceField2.setColumnName(string5);
            String string7 = string3 + '.' + string5;
            gQFieldRef = new GQFieldRef(annotatedSourceField2, string5, gQTableRef);
            subQuery.addFieldRef(StringFunc.identifierHashKey(string7), gQFieldRef);
            subQuery.addFieldRef(StringFunc.identifierHashKey(string5), gQFieldRef);
            simpleNode.setReference(gQFieldRef);
            return gQFieldRef;
        }
        if (gQFieldRef == null) {
            ArrayList<Object> arrayList;
            String string8;
            int n = string.indexOf("*");
            if (n >= 0) {
                this.validateStarIdentifier(simpleNode, string, subQuery);
                return null;
            }
            String[] stringArray = StringFunc.divideIdentifier(string);
            if (stringArray.length == 1) {
                string8 = stringArray[0];
                ArrayList<AnnotatedSourceField> arrayList2 = this.gs.findField(string8);
                if (arrayList2 == null) {
                    GlobalFunction globalFunction = DatabaseMapping.getFunction(string8, null);
                    if (globalFunction != null && simpleNode != null) {
                        ASTFunction aSTFunction = new ASTFunction(simpleNode.id);
                        aSTFunction.setName(string8);
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
                        aSTFunction.jjtSetParent(simpleNode2);
                        if (simpleNode2 != null) {
                            simpleNode2.replaceChild(simpleNode, aSTFunction);
                        }
                        return null;
                    }
                    if (StringFunc.SQLKeywords.containsKey(string4.toUpperCase())) {
                        GQFieldRef gQFieldRef2 = new GQFieldRef(null, string4.toUpperCase(), null);
                        subQuery.addFieldRef(StringFunc.identifierHashKey(string4), gQFieldRef2);
                        return gQFieldRef2;
                    }
                    throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldNotInSchema") + string4);
                }
                arrayList = subQuery.findFieldWithTableRefs(arrayList2);
                int n2 = (Integer)arrayList.get(0);
                if (n2 == 0) {
                    throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldNotValid") + string4);
                }
                if (n2 > 1) {
                    throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldAmbiguous") + string4);
                }
                gQTableRef = (GQTableRef)arrayList.get(1);
                string3 = gQTableRef.getName();
                annotatedSourceField = (AnnotatedSourceField)arrayList.get(2);
                bl = true;
            } else {
                SubQuery subQuery2;
                ArrayList<AnnotatedSourceTable> arrayList3;
                string8 = stringArray[stringArray.length - 1];
                string3 = stringArray[0];
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    string3 = string3 + '.' + stringArray[i];
                }
                gQTableRef = subQuery.getTableRef(string3);
                if (gQTableRef == null && stringArray.length == 2 && (arrayList3 = this.gs.findTable(string3)) != null && arrayList3.size() == 1) {
                    string3 = arrayList3.get(0).getFullSQLTableName();
                    gQTableRef = subQuery.getTableRef(StringFunc.identifierHashKey(string3));
                }
                if (gQTableRef == null && stringArray.length > 2) {
                    string3 = stringArray.length == 3 ? stringArray[1] : stringArray[1] + '.' + stringArray[2];
                    ArrayList<AnnotatedSourceTable> arrayList4 = this.gs.findTable(string3);
                    if (arrayList4 == null) {
                        throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldAmbiguousNoTable") + string4);
                    }
                    if (arrayList4.size() != 1 && (arrayList4 = this.gs.findTable(string3 = stringArray[0] + '.' + stringArray[1])).size() != 1) {
                        throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldAmbiguousMultipleTable") + string4);
                    }
                    string3 = arrayList4.get(0).getFullName();
                    gQTableRef = subQuery.getTableRef(StringFunc.identifierHashKey(string3));
                }
                if (gQTableRef == null && gQFieldRef == null && (subQuery2 = subQuery.getParent()) != null) {
                    gQFieldRef = subQuery2.getFieldRef(StringFunc.identifierHashKey(string));
                    if (gQFieldRef == null) {
                        gQFieldRef = this.findDelimited(string, subQuery2);
                    }
                    if (gQFieldRef == null) {
                        stringArray = StringFunc.divideIdentifier(string);
                        string8 = stringArray[stringArray.length - 1];
                        gQTableRef = null;
                        if (stringArray.length > 1) {
                            string3 = stringArray[0];
                            gQTableRef = subQuery2.getTableRef(string3);
                        } else {
                            gQTableRef = subQuery2.getFirstTableRef();
                            string3 = gQTableRef.getName();
                        }
                        arrayList = new AnnotatedSourceField();
                        ((SourceField)((Object)arrayList)).setColumnName(string8);
                        String string9 = string3 + '.' + string8;
                        gQFieldRef = new GQFieldRef((AnnotatedSourceField)((Object)arrayList), string8, gQTableRef);
                        subQuery.addFieldRef(StringFunc.identifierHashKey(string9), gQFieldRef);
                        subQuery.addFieldRef(StringFunc.identifierHashKey(string8), gQFieldRef);
                        subQuery2.addFieldRef(StringFunc.identifierHashKey(string9), gQFieldRef);
                        subQuery2.addFieldRef(StringFunc.identifierHashKey(string8), gQFieldRef);
                    }
                    if (gQFieldRef != null) {
                        subQuery.setCorrelated(true);
                        simpleNode.setReference(gQFieldRef);
                        arrayList = string3 + '.' + string8;
                        subQuery.addFieldRef(StringFunc.identifierHashKey((String)((Object)arrayList)), gQFieldRef);
                        return gQFieldRef;
                    }
                }
                if (gQTableRef == null) {
                    throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldNotInFrom") + string4);
                }
                annotatedSourceField = (AnnotatedSourceField)gQTableRef.getTable().getField(StringFunc.identifierHashKey(string8));
                if (annotatedSourceField == null && (annotatedSourceField = (AnnotatedSourceField)gQTableRef.getTable().getField(StringFunc.undelimitName(string8, '\"').toLowerCase())) == null) {
                    throw new SQLException(UnityDriver.i18n.getString("Field") + string4 + UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorFieldNotInTable") + string3);
                }
            }
            String string10 = gQTableRef.getName() + '.' + string8;
            gQFieldRef = subQuery.getFieldRef(StringFunc.identifierHashKey(string10));
            if (gQFieldRef == null) {
                arrayList = string3 != null ? string3 + '.' + string8 : string8;
                gQFieldRef = new GQFieldRef(annotatedSourceField, string8, gQTableRef);
                subQuery.addFieldRef(StringFunc.identifierHashKey((String)((Object)arrayList)), gQFieldRef);
                subQuery.addFieldRef(StringFunc.identifierHashKey(string10), gQFieldRef);
                if (bl) {
                    subQuery.addFieldRef(StringFunc.identifierHashKey(string8), gQFieldRef);
                }
                if (string2 != null) {
                    gQFieldRef.setReferenceName(string2);
                    subQuery.addFieldRef(string2, gQFieldRef);
                }
            }
        }
        simpleNode.setReference(gQFieldRef);
        if (string2 != null) {
            gQFieldRef = new GQFieldRef(null, string2, null);
            subQuery.addFieldRef(string2, gQFieldRef);
        }
        return gQFieldRef;
    }

    public void addAllFieldsForTables(HashMap<String, GQTableRef> hashMap, SubQuery subQuery) {
        for (String string : hashMap.keySet()) {
            GQTableRef gQTableRef = hashMap.get(string);
            String string2 = gQTableRef.getReferenceName();
            AnnotatedSourceTable annotatedSourceTable = gQTableRef.getTable();
            Iterator<SourceField> iterator = annotatedSourceTable.fieldIterator();
            while (iterator.hasNext()) {
                AnnotatedSourceField annotatedSourceField = (AnnotatedSourceField)iterator.next();
                String string3 = (String)annotatedSourceField.getProperty("output");
                if (string3 != null && string3.equalsIgnoreCase("false")) continue;
                String string4 = annotatedSourceField.getColumnName();
                String string5 = StringFunc.identifierHashKey(string2 + '.' + string4);
                GQFieldRef gQFieldRef = subQuery.getFieldRef(string5);
                if (gQFieldRef == null) {
                    gQFieldRef = new GQFieldRef(annotatedSourceField, string4, gQTableRef);
                    subQuery.addFieldRef(string5, gQFieldRef);
                }
                subQuery.addOutputFieldRef(gQFieldRef);
            }
        }
    }

    public void ValidateFields(SimpleNode simpleNode, SubQuery subQuery) throws SQLException {
        ArrayList<ParsedIdentifier> arrayList = new ArrayList<ParsedIdentifier>();
        GQFieldRef gQFieldRef = null;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2 instanceof ASTInto || simpleNode2 instanceof ASTUnion || simpleNode2 instanceof ASTExcept || simpleNode2 instanceof ASTIntersect) continue;
            arrayList.clear();
            this.getIdentifiers(simpleNode2, arrayList);
            for (int j = 0; j < arrayList.size(); ++j) {
                ParsedIdentifier parsedIdentifier = arrayList.get(j);
                if (parsedIdentifier.parseNode instanceof ASTAs) {
                    GQFieldRef gQFieldRef2 = gQFieldRef;
                    gQFieldRef = new GQFieldRef(null, parsedIdentifier.name, null);
                    gQFieldRef.setReference(gQFieldRef2);
                    subQuery.addFieldRef(StringFunc.identifierHashKey(parsedIdentifier.aliasName), gQFieldRef);
                    continue;
                }
                gQFieldRef = this.validateField(parsedIdentifier.name, subQuery, parsedIdentifier.aliasName, parsedIdentifier.parseNode);
            }
        }
    }

    private void computeOutputFields(SimpleNode simpleNode, SubQuery subQuery) {
        GQFieldRef gQFieldRef = null;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2 instanceof ASTAs) continue;
            if (simpleNode2.getReference() != null) {
                gQFieldRef = (GQFieldRef)simpleNode2.getReference();
                subQuery.addOutputFieldRef(gQFieldRef);
                continue;
            }
            String string = "col" + (i + 1);
            if (i + 1 < simpleNode.jjtGetNumChildren() && simpleNode.jjtGetChild(i + 1) instanceof ASTAs) {
                string = simpleNode.jjtGetChild(i + 1).jjtGetChild(0).toString().substring(12);
            } else {
                ASTAs aSTAs = new ASTAs(18);
                ASTMyID aSTMyID = new ASTMyID(23);
                aSTMyID.setName(string);
                aSTAs.jjtAddChild(aSTMyID, 0);
                simpleNode.InsertChild(i + 1, aSTAs);
            }
            gQFieldRef = new GQFieldRef(null, string, null);
            subQuery.addOutputFieldRef(gQFieldRef);
        }
    }

    private void getIdentifiers(SimpleNode simpleNode, ArrayList<ParsedIdentifier> arrayList) {
        if (simpleNode == null) {
            return;
        }
        String string = simpleNode.toString();
        String string2 = string.toLowerCase();
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
        if (!(simpleNode2 instanceof ASTFrom || simpleNode2 instanceof ASTJoinExpr || simpleNode2.jjtGetParent() instanceof ASTFrom && simpleNode2 instanceof ASTAs || simpleNode2 instanceof ASTAscToken || simpleNode2 instanceof ASTDscToken || simpleNode2 instanceof ASTSubquery || !string2.startsWith("identifier: ") && !string2.startsWith("string: \""))) {
            string = string2.startsWith("ident") ? string.substring(12, string.length()) : string.substring(8, string.length());
            ParsedIdentifier parsedIdentifier = new ParsedIdentifier();
            parsedIdentifier.name = string;
            parsedIdentifier.parseNode = simpleNode;
            arrayList.add(parsedIdentifier);
        }
        if (simpleNode.jjtGetNumChildren() > 0 && !string2.startsWith("as")) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                if (simpleNode instanceof ASTSubquery) continue;
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (simpleNode3 instanceof ASTAs && !(simpleNode instanceof ASTFrom) && !(simpleNode instanceof ASTJoinExpr)) {
                    String string3 = simpleNode3.jjtGetChild(0).toString();
                    if (!string3.toLowerCase().startsWith("identifier: ")) continue;
                    string3 = string3.substring(12, string3.length());
                    String string4 = simpleNode.jjtGetChild(i - 1).toString().toLowerCase();
                    if (string4.contains("identifier:")) {
                        if (arrayList.size() <= 0) continue;
                        arrayList.get((int)(arrayList.size() - 1)).aliasName = string3;
                        continue;
                    }
                    ParsedIdentifier parsedIdentifier = new ParsedIdentifier();
                    parsedIdentifier.name = string3;
                    parsedIdentifier.parseNode = simpleNode3;
                    parsedIdentifier.aliasName = string3;
                    arrayList.add(parsedIdentifier);
                    continue;
                }
                this.getIdentifiers((SimpleNode)simpleNode.jjtGetChild(i), arrayList);
            }
        }
    }

    public AnnotatedSourceTable parseTableIdentifier(SimpleNode simpleNode) throws SQLException {
        String string = simpleNode.toString();
        String string2 = string.startsWith("Ident") ? string.substring(12, string.length()) : string.substring(8, string.length());
        String string3 = string2;
        String[] stringArray = StringFunc.divideIdentifier(string2);
        String string4 = null;
        if (stringArray.length > 1) {
            string4 = stringArray[0];
            string2 = stringArray[1];
            for (int i = 2; i < stringArray.length; ++i) {
                string2 = string2 + '.' + stringArray[i];
            }
        }
        AnnotatedSourceTable annotatedSourceTable = null;
        if (this.schemaValidation) {
            ArrayList<AnnotatedSourceTable> arrayList = this.gs.findTable(string4, string2);
            if (arrayList == null || arrayList.size() == 0) {
                throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorNonExistingTable") + string3);
            }
            if (arrayList.size() > 1) {
                throw new SQLException(UnityDriver.i18n.getString("PTreeBuilderValidater.ErrorAmbiguousTable") + string3);
            }
            annotatedSourceTable = arrayList.get(0);
        } else {
            AnnotatedSourceDatabase annotatedSourceDatabase = this.database;
            if (this.database == null) {
                annotatedSourceDatabase = new AnnotatedSourceDatabase("DB", "", "", "", "", "", '\"');
            }
            annotatedSourceTable = new AnnotatedSourceTable(null, null, string2, null, new HashMap<String, SourceField>(), null);
            annotatedSourceTable.setParentDatabase(annotatedSourceDatabase);
        }
        return annotatedSourceTable;
    }
}

