/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.math.BigDecimal;
import java.sql.SQLException;
import unity.jdbc.UnityDriver;
import unity.predicates.Predicate;

public class Greater
extends Predicate {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean evaluate(Object object, Object object2) throws SQLException {
        try {
            if (object == null) {
                return false;
            }
            if (object2 == null) {
                return false;
            }
            if (object instanceof Number && object2 instanceof Number) {
                if (object instanceof Double || object instanceof BigDecimal || object instanceof Float || object2 instanceof Double || object2 instanceof BigDecimal || object2 instanceof Float) {
                    return ((Number)object).doubleValue() > ((Number)object2).doubleValue();
                }
                return ((Number)object).longValue() > ((Number)object2).longValue();
            }
            if (object.getClass() == object2.getClass()) {
                return ((Comparable)object).compareTo(object2) > 0;
            }
            Object[] objectArray = Predicate.convertTypes(object, object2);
            return ((Comparable)objectArray[0]).compareTo(objectArray[1]) > 0;
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("Greater.ErrorComparison") + object + " (" + (object == null ? null : object.getClass()) + ") > " + object2 + " (" + (object2 == null ? null : object2.getClass()) + ") " + UnityDriver.i18n.getString("Error") + exception);
        }
    }

    public String toString() {
        return ">";
    }
}

