/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.HashSet;
import unity.engine.Relation;
import unity.mapping.DatabaseMapping;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.operators.SortEliminator;
import unity.predicates.SortComparator;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQDupElimNode
extends LQNode {
    private static final long serialVersionUID = 1L;

    public LQDupElimNode() {
        this.type = 16;
    }

    @Override
    public String generateSQL() {
        return "DISTINCT";
    }

    @Override
    public String toString() {
        return this.generateSQL() + ' ' + super.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        this.outputRelation = new Relation(operatorArray[0].getOutputRelation());
        boolean[] blArray = new boolean[this.outputRelation.getNumAttributes()];
        int[] nArray = new int[this.outputRelation.getNumAttributes()];
        for (int i = 0; i < this.outputRelation.getNumAttributes(); ++i) {
            nArray[i] = i;
            blArray[i] = true;
        }
        SortComparator sortComparator = new SortComparator(nArray, blArray);
        MergeSort mergeSort = new MergeSort(operatorArray[0], this.getMemorySize(), sortComparator, this);
        SortEliminator sortEliminator = new SortEliminator(mergeSort, sortComparator);
        return sortEliminator;
    }

    @Override
    public int numTuples() {
        int n = ((LQNode)this.children.get(0)).numTuples();
        return n;
    }

    @Override
    public int tupleSize() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).tupleSize();
        }
        return 0;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        int n = this.getChild(0).tupleSize();
        this.cost = (double)(3L * l) * (1.0 + 0.005 * (double)n);
        this.rows = l * 1L;
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        if (DatabaseMapping.isSupported("#DISTINCT#", this.database, null) != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        return hashSet;
    }
}

