/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import unity.annotation.AnnotatedSourceDatabase;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.operators.ResultSetScan;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;

public class LocalQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String SQLQueryString;
    private AnnotatedSourceDatabase database;
    private Connection con;
    private ResultSet rs = null;
    private Statement stmt = null;
    private ResultSetScan resultSetScanOp;
    private int _resultSetType;
    private int _resultSetConcurrency;
    private String errorMessage;

    public LocalQuery(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.database = annotatedSourceDatabase;
        this._resultSetType = 1003;
        this._resultSetConcurrency = 1007;
        this.errorMessage = null;
    }

    public LocalQuery(GQDatabaseRef gQDatabaseRef, GlobalQuery globalQuery) {
        this.SQLQueryString = "";
        if (gQDatabaseRef != null) {
            this.database = gQDatabaseRef.getDatabase();
        }
        this._resultSetType = 1003;
        this._resultSetConcurrency = 1007;
        this.errorMessage = null;
    }

    public ResultSetScan getResultSetScan() {
        return this.resultSetScanOp;
    }

    public String getDatabaseName() {
        return this.database.getDatabaseName();
    }

    public void setResultSetType(int n) {
        this._resultSetType = n;
    }

    public void setResultSetConcurrency(int n) {
        this._resultSetConcurrency = n;
    }

    public void execute(UnityConnection unityConnection) throws SQLException {
        this.con = unityConnection.getConnection(this.database.getDatabaseName());
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.resultSetScanOp == null) {
            this.stmt = this.con.createStatement(this._resultSetType, this._resultSetConcurrency);
            this.rs = this.stmt.executeQuery(this.SQLQueryString);
        } else {
            this.stmt = this.con.createStatement(1003, this._resultSetConcurrency);
            this.resultSetScanOp.setSQLString(this.SQLQueryString);
            if (!this.resultSetScanOp.getDelayedExecution()) {
                if (UnityDriver.DEBUG) {
                    System.out.println("Executing query: " + this.SQLQueryString);
                }
                this.rs = this.stmt.executeQuery(this.SQLQueryString);
                this.resultSetScanOp.setResultSet(this.rs);
                if (UnityDriver.DEBUG) {
                    System.out.println("Query execution complete.");
                }
            } else if (UnityDriver.DEBUG) {
                System.out.println("Delaying execution due to distributed join.");
            }
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public String getSQLQueryString() {
        return this.SQLQueryString;
    }

    public void setSQLQueryString(String string) {
        this.SQLQueryString = string;
    }

    public void setResultSetScanOp(ResultSetScan resultSetScan) {
        this.resultSetScanOp = resultSetScan;
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public AnnotatedSourceDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.database = annotatedSourceDatabase;
    }
}

