/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator.text.heading;

import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.util.StringUtil;

public class Heading
extends Text {
    public static final int MINIMUM_LEVEL = 1;
    public static final int MAXIMUM_LEVEL = 6;
    public static final char UNDERLINE_CHAR_1 = '=';
    public static final char UNDERLINE_CHAR_2 = '-';
    private int level;
    boolean underlineStyle = true;

    public Heading(Object value) {
        super(value);
        this.level = 1;
    }

    public Heading(Object value, int level) {
        super(value);
        this.level = level;
        this.trimLevel();
    }

    @Override
    public String getPredecessor() {
        if (this.underlineStyle && this.level < 3) {
            return "";
        }
        return StringUtil.fillUpRightAligned("", "#", this.level) + " ";
    }

    @Override
    public String getSuccessor() {
        if (this.underlineStyle && this.level < 3) {
            char underlineChar = this.level == 1 ? (char)'=' : '-';
            return "\n" + StringUtil.fillUpLeftAligned("", "" + underlineChar, this.value.toString().length());
        }
        return "";
    }

    private void trimLevel() {
        this.level = Math.min(6, Math.max(1, this.level));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.trimLevel();
        this.invalidateSerialized();
    }

    public boolean isUnderlineStyle() {
        return this.underlineStyle;
    }

    public void setUnderlineStyle(boolean underlineStyle) {
        this.underlineStyle = underlineStyle;
        this.invalidateSerialized();
    }
}

