/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.icon.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class BorderIcon
implements Icon {
    private Icon icon;
    private Color color;
    private Insets insets;

    public BorderIcon(Icon icon, int n) {
        this(icon, null, new Insets(n, n, n, n));
    }

    public BorderIcon(Icon icon, Color color, Insets insets) {
        this.icon = icon;
        this.color = color;
        this.insets = insets;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.color != null) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.getIconWidth(), this.insets.top);
            graphics.fillRect(n, n2 + this.getIconHeight() - this.insets.bottom, this.getIconWidth(), this.insets.bottom);
            graphics.fillRect(n, n2 + this.insets.top, this.insets.left, this.getIconHeight() - this.insets.top - this.insets.bottom);
            graphics.fillRect(n + this.getIconWidth() - this.insets.right, n2 + this.insets.top, this.insets.right, this.getIconHeight() - this.insets.top - this.insets.bottom);
            graphics.setColor(color);
        }
        this.icon.paintIcon(component, graphics, n + this.insets.left, n2 + this.insets.top);
    }

    public int getIconWidth() {
        return this.insets.left + this.insets.right + this.icon.getIconWidth();
    }

    public int getIconHeight() {
        return this.insets.top + this.insets.bottom + this.icon.getIconHeight();
    }
}

