/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ClassPathItemListModel;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ClassPathListCellRenderer;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.JpaConnectionConfigPanel;

public class HibernateConfigPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HibernateConfigPanel.class);
    JComboBox cboConfigs;
    JButton btnNewConfig;
    JButton btnRemoveConfig;
    JList lstClassPath;
    JButton btnClassPathAdd;
    JButton btnClassPathDirAdd;
    JButton btnClassPathRemove;
    JButton btnClassPathMoveUp;
    JButton btnClassPathMoveDown;
    JTextField txtConfigName;
    JButton btnApplyConfigChanges;
    JpaConnectionConfigPanel _jpaConnectionConfigPanel = new JpaConnectionConfigPanel();
    JRadioButton radCreateProcess;
    JButton btnProcessDetails;
    JRadioButton radInVM;

    public HibernateConfigPanel(HibernatePluginResources resources) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        JLabel lblConfig = new JLabel(s_stringMgr.getString("HibernatePanel.config"));
        this.add((Component)lblConfig, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.cboConfigs = new JComboBox();
        this.add((Component)this.cboConfigs, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnNewConfig = new JButton(s_stringMgr.getString("HibernatePanel.newConfig"));
        this.add((Component)this.btnNewConfig, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnRemoveConfig = new JButton(s_stringMgr.getString("HibernatePanel.removeConfig"));
        this.add((Component)this.btnRemoveConfig, gbc);
        gbc = new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 1, new Insets(15, 10, 10, 10), 0, 0);
        this.add((Component)this.createConfigDefPanel(resources), gbc);
    }

    private JPanel createConfigDefPanel(HibernatePluginResources resources) {
        JPanel ret = new JPanel(new GridBagLayout());
        ret.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("HibernatePanel.ConfiguirationDef")));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.createConfigNamePanel(), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
        ret.add((Component)this.createClasspathPanel(resources), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 5, 0), 0, 0);
        ret.add((Component)this._jpaConnectionConfigPanel, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 5, 5), 0, 0);
        ret.add((Component)this.createProcessPanel(), gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0);
        this.btnApplyConfigChanges = new JButton(s_stringMgr.getString("HibernatePanel.applyConfigChanges"));
        ret.add((Component)this.btnApplyConfigChanges, gbc);
        return ret;
    }

    private JPanel createProcessPanel() {
        JPanel ret = new JPanel();
        ret.setBorder(BorderFactory.createEtchedBorder());
        ret.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("HibernatePanel.howToAccess")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 5), 0, 0);
        this.radInVM = new JRadioButton(s_stringMgr.getString("HibernateConfigPanel.inVM"));
        ret.add((Component)this.radInVM, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.radCreateProcess = new JRadioButton(s_stringMgr.getString("HibernateConfigPanel.createProcess"));
        ret.add((Component)this.radCreateProcess, gbc);
        gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.btnProcessDetails = new JButton(s_stringMgr.getString("HibernateConfigPanel.createProcessDetails"));
        ret.add((Component)this.btnProcessDetails, gbc);
        gbc = new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        ButtonGroup btnGr = new ButtonGroup();
        btnGr.add(this.radCreateProcess);
        btnGr.add(this.radInVM);
        this.radCreateProcess.setSelected(true);
        return ret;
    }

    private JPanel createConfigNamePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("HibernatePanel.configName")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.txtConfigName = new JTextField();
        ret.add((Component)this.txtConfigName, gbc);
        return ret;
    }

    private JPanel createClasspathPanel(HibernatePluginResources resources) {
        TitledBorder brd = BorderFactory.createTitledBorder(s_stringMgr.getString("HibernatePanel.classpath.of.hibernat.libs.and.entities"));
        JPanel ret = new JPanel(new GridBagLayout());
        ret.setBorder(brd);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
        this.lstClassPath = new JList(new ClassPathItemListModel());
        this.lstClassPath.setCellRenderer(new ClassPathListCellRenderer(resources));
        ret.add((Component)new JScrollPane(this.lstClassPath), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 5, 5, 5), 0, 0);
        ret.add((Component)this.createButtonClasspathPanel(resources), gbc);
        return ret;
    }

    private JPanel createButtonClasspathPanel(HibernatePluginResources resources) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnClassPathAdd = new JButton(s_stringMgr.getString("HibernatePanel.classPathAdd"));
        this.btnClassPathAdd.setIcon(resources.getIcon("jar"));
        ret.add((Component)this.btnClassPathAdd, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnClassPathDirAdd = new JButton(s_stringMgr.getString("HibernatePanel.classPathDirAdd"));
        this.btnClassPathDirAdd.setIcon(resources.getIcon("jardirectory"));
        ret.add((Component)this.btnClassPathDirAdd, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnClassPathRemove = new JButton(s_stringMgr.getString("HibernatePanel.classPathRemove"));
        ret.add((Component)this.btnClassPathRemove, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnClassPathMoveUp = new JButton(s_stringMgr.getString("HibernatePanel.moveUp"));
        ret.add((Component)this.btnClassPathMoveUp, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnClassPathMoveDown = new JButton(s_stringMgr.getString("HibernatePanel.moveDown"));
        ret.add((Component)this.btnClassPathMoveDown, gbc);
        return ret;
    }
}

