/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.awt.Component;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.JpaConnectionConfigPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;

public class JpaConnectionConfigCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(JpaConnectionConfigCtrl.class);
    private JpaConnectionConfigPanel _panel;
    private HibernatePlugin _plugin;

    public JpaConnectionConfigCtrl(JpaConnectionConfigPanel jpaConnectionConfigPanel, HibernatePlugin plugin) {
        this._panel = jpaConnectionConfigPanel;
        this._plugin = plugin;
    }

    public void init(HibernateConfiguration cfg) {
        if (null == cfg) {
            return;
        }
        this._panel.txtPersistenceUnitName.setText(cfg.getPersistenceUnitName());
    }

    public boolean checkValid(boolean silent) {
        String persistenceUnitName = this._panel.txtPersistenceUnitName.getText();
        if (StringUtilities.isEmpty((String)persistenceUnitName, (boolean)true)) {
            if (!silent) {
                JOptionPane.showMessageDialog((Component)this._plugin.getApplication().getMainFrame(), s_stringMgr.getString("HibernateController.noPersistenceUnitName"));
            }
            return false;
        }
        return true;
    }

    public void saveConfiguration(HibernateConfiguration cfg) {
        String persistenceUnitName = this._panel.txtPersistenceUnitName.getText();
        cfg.setPersistenceUnitName(persistenceUnitName);
    }

    public boolean isMyPanel(Component selectedComponent) {
        return selectedComponent == this._panel;
    }
}

