/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.mapping;

import java.util.Hashtable;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ClassPathUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateSqlConnectionData;

public class MappingRoot {
    private static ILogger s_log = LoggerController.createLogger(MappingRoot.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MappingRoot.class);
    private String _toString = s_stringMgr.getString("MappingRoot.toString");
    private Hashtable<String, String> _properties = new Hashtable();

    public String toString() {
        return this._toString;
    }

    public Hashtable<String, String> getMappingProperties() {
        return this._properties;
    }

    public void clear() {
        this._properties = new Hashtable();
    }

    public void init(HibernateConnection con, HibernateConfiguration cfg) {
        this.clear();
        this._properties.put(s_stringMgr.getString("MappingRoot.cfgName"), cfg.getName());
        this._properties.put(s_stringMgr.getString("MappingRoot.classpath"), ClassPathUtil.classPathToString(cfg.getClassPathItems()));
        try {
            HibernateSqlConnectionData data = con.getHibernateSqlConnectionData();
            this._properties.put(s_stringMgr.getString("MappingRoot.url"), data.getURL());
            this._properties.put(s_stringMgr.getString("MappingRoot.user"), data.getUserName());
            this._properties.put(s_stringMgr.getString("MappingRoot.driverName"), data.getDriverName());
            this._properties.put(s_stringMgr.getString("MappingRoot.driverVersion"), data.getDriverVersion());
        }
        catch (Exception e) {
            s_log.error((Object)s_stringMgr.getString("MappingRoot.connectionErr"), (Throwable)e);
        }
    }
}

