/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPluginResources;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPluginSessionCallback;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProviderImpl;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.CopyTableAction;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.PasteTableAction;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.PasteTableAsOrFilteredAction;
import net.sourceforge.squirrel_sql.plugins.dbcopy.gui.DBCopyGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.PreferencesManager;

public class DBCopyPlugin
extends DefaultSessionPlugin {
    public static final String BUNDLE_BASE_NAME = "net.sourceforge.squirrel_sql.plugins.dbcopy.dbcopy";
    private static final ILogger s_log = LoggerController.createLogger(DBCopyPlugin.class);
    private PluginResources _resources;
    private SessionInfoProviderImpl _sessionInfoProvider = new SessionInfoProviderImpl();

    public PluginSessionCallback sessionStarted(ISession session) {
        IObjectTreeAPI api = session.getObjectTreeAPIOfActiveSessionWindow();
        this.addMenuItemsToContextMenu(api);
        return new DBCopyPluginSessionCallback(this);
    }

    public void sessionEnding(ISession session) {
        if (session.equals(this._sessionInfoProvider.getCopySourceSession())) {
            this._sessionInfoProvider.dispose();
            this.setPasteMenuEnabled(false);
        }
    }

    public String getInternalName() {
        return "dbcopy";
    }

    public String getDescriptiveName() {
        return "DBCopy Plugin";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Dan Dragut";
    }

    public String getVersion() {
        return "1.15";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getLicenceFileName() {
        return "license.txt";
    }

    public void initialize() throws PluginException {
        super.initialize();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Initializing DB Copy Plugin");
        }
        this._resources = new DBCopyPluginResources(BUNDLE_BASE_NAME, (IPlugin)this);
        PreferencesManager.initialize((IPlugin)this);
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new CopyTableAction(app, (Resources)this._resources, this)));
        coll.add((Action)((Object)new PasteTableAction(app, (Resources)this._resources, this)));
        coll.add((Action)((Object)new PasteTableAsOrFilteredAction((Resources)this._resources, this)));
        this.setPasteMenuEnabled(false);
    }

    public void unload() {
        super.unload();
        this._sessionInfoProvider.dispose();
        this.setPasteMenuEnabled(false);
        PreferencesManager.unload();
    }

    public void setCopyMenuEnabled(final boolean enabled) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionCollection coll = DBCopyPlugin.this.getApplication().getActionCollection();
                coll.get(CopyTableAction.class).setEnabled(enabled);
            }
        });
    }

    public void setPasteMenuEnabled(boolean enabled) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionCollection coll = DBCopyPlugin.this.getApplication().getActionCollection();
                coll.get(PasteTableAction.class).setEnabled(true);
            }
        });
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        DBCopyGlobalPreferencesTab tab = new DBCopyGlobalPreferencesTab();
        return new IGlobalPreferencesPanel[]{tab};
    }

    protected void addMenuItemsToContextMenu(final IObjectTreeAPI api) {
        final ActionCollection coll = this.getApplication().getActionCollection();
        if (SwingUtilities.isEventDispatchThread()) {
            this.addToPopup(api, coll);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBCopyPlugin.this.addToPopup(api, coll);
                }
            });
        }
    }

    private void addToPopup(IObjectTreeAPI api, ActionCollection coll) {
        api.addToPopup(DatabaseObjectType.TABLE_TYPE_DBO, coll.get(CopyTableAction.class));
        api.addToPopup(DatabaseObjectType.TABLE_TYPE_DBO, coll.get(PasteTableAction.class));
        api.addToPopup(DatabaseObjectType.TABLE_TYPE_DBO, coll.get(PasteTableAsOrFilteredAction.class));
        api.addToPopup(DatabaseObjectType.TABLE, coll.get(CopyTableAction.class));
        api.addToPopup(DatabaseObjectType.TABLE, coll.get(PasteTableAction.class));
        api.addToPopup(DatabaseObjectType.TABLE, coll.get(PasteTableAsOrFilteredAction.class));
        api.addToPopup(DatabaseObjectType.SCHEMA, coll.get(PasteTableAction.class));
        api.addToPopup(DatabaseObjectType.SCHEMA, coll.get(PasteTableAsOrFilteredAction.class));
        api.addToPopup(DatabaseObjectType.CATALOG, coll.get(PasteTableAction.class));
        api.addToPopup(DatabaseObjectType.CATALOG, coll.get(PasteTableAsOrFilteredAction.class));
        api.addToPopup(DatabaseObjectType.SESSION, coll.get(PasteTableAsOrFilteredAction.class));
    }

    public SessionInfoProvider getSessionInfoProvider() {
        return this._sessionInfoProvider;
    }
}

