/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.dboutput;

import java.awt.BorderLayout;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DBOutputPanel
extends JPanel {
    private static final ILogger s_log = LoggerController.createLogger(DBOutputPanel.class);
    private ISession _session;
    private JTextArea _textArea;
    private Timer _refreshTimer = new Timer(true);
    private boolean _autoRefresh = false;
    private int _refreshPeriod = 10;

    public DBOutputPanel(ISession session, int autoRefeshPeriod) {
        this._session = session;
        this._refreshPeriod = autoRefeshPeriod;
        this.createGUI();
        this.initDBOutput();
    }

    protected void initDBOutput() {
        try {
            CallableStatement c = this._session.getSQLConnection().getConnection().prepareCall("{call dbms_output.enable()}");
            c.execute();
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
    }

    public ISession getSession() {
        return this._session;
    }

    private void resetTimer() {
        if (this._refreshTimer != null) {
            this._refreshTimer.cancel();
            this._refreshTimer = null;
        }
        if (this._autoRefresh && this._refreshPeriod > 0) {
            this._refreshTimer = new Timer(true);
            this._refreshTimer.scheduleAtFixedRate((TimerTask)new RefreshTimerTask(), this._refreshPeriod * 1000, (long)(this._refreshPeriod * 1000));
        }
    }

    public void setAutoRefresh(boolean enable) {
        if (enable != this._autoRefresh) {
            this._autoRefresh = enable;
            this.resetTimer();
        }
    }

    public boolean getAutoRefesh() {
        return this._autoRefresh;
    }

    public void setAutoRefreshPeriod(int seconds) {
        if (this._refreshPeriod != seconds) {
            this._refreshPeriod = seconds;
            this.resetTimer();
        }
    }

    public int getAutoRefreshPeriod() {
        return this._refreshPeriod;
    }

    public void clearOutput() {
        Document doc = this._textArea.getDocument();
        int length = doc.getLength();
        try {
            doc.remove(0, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public synchronized void populateDBOutput() {
        try {
            final StringBuffer buf = new StringBuffer();
            CallableStatement c = this._session.getSQLConnection().getConnection().prepareCall("{call dbms_output.get_line(?, ?)}");
            c.registerOutParameter(1, 12);
            c.registerOutParameter(2, 4);
            int status = 0;
            while (status == 0) {
                c.execute();
                status = c.getInt(2);
                if (status != 0) continue;
                String str = c.getString(1);
                if (str != null) {
                    buf.append(str);
                }
                buf.append("\n");
            }
            c.close();
            if (buf.length() > 0) {
                final JTextArea store = this._textArea;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        store.append(buf.toString());
                    }
                });
            }
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
    }

    private void createGUI() {
        IApplication app = this._session.getApplication();
        this.setLayout(new BorderLayout());
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        this.add(new JScrollPane(this._textArea, 22, 30));
    }

    public class RefreshTimerTask
    extends TimerTask {
        @Override
        public void run() {
            DBOutputPanel.this.populateDBOutput();
        }
    }
}

