/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.action.ActionKeys;
import net.sourceforge.squirrel_sql.client.action.ActionUpdateHelper;
import net.sourceforge.squirrel_sql.client.action.IFileEditAction;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.CascadeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllButCurrentSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.MaximizeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileHorizontalAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileVerticalAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.IMainPanelTabAction;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ActionCollection {
    private static ILogger s_log = LoggerController.createLogger(ActionCollection.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ActionCollection.class);
    private final Map<String, Action> _actionColl = new HashMap<String, Action>();

    void doAfterLoadInitalizations() {
        this.enableInternalFrameOptions(false);
    }

    public void add(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        this._actionColl.put(action.getClass().getName(), action);
    }

    public synchronized Action get(Class<? extends Action> actionClass) {
        if (actionClass == null) {
            throw new IllegalArgumentException("null Action Class passed.");
        }
        return this.get(actionClass.getName());
    }

    public synchronized Action get(String actionClassName) {
        if (actionClassName == null) {
            throw new IllegalArgumentException("null Action Class Name passed.");
        }
        Action action = this._actionColl.get(actionClassName);
        if (action == null) {
            String errMsg = s_stringMgr.getString("ActionCollection.actionNotFound", actionClassName);
            s_log.error(errMsg);
            action = this.createAction(actionClassName);
        }
        return action;
    }

    public void enableAction(Class actionClass, boolean enable) throws IllegalArgumentException {
        if (actionClass == null) {
            throw new IllegalArgumentException("null Action Class passed.");
        }
        Action action = this.get(actionClass);
        if (action != null) {
            action.setEnabled(enable);
        }
    }

    public void internalFrameOpenedOrClosed(int nbrInternalFramesOpen) {
        this.enableInternalFrameOptions(nbrInternalFramesOpen > 0);
    }

    public void deactivationChanged(IWidget frame) {
        boolean isSQLFrame = frame instanceof SQLInternalFrame;
        boolean isTreeFrame = frame instanceof ObjectTreeInternalFrame;
        boolean isSessionInternalFrame = frame instanceof SessionInternalFrame;
        Iterator<Action> it = this.actions();
        while (it.hasNext()) {
            Action act = it.next();
            if (act instanceof ISessionAction) {
                ((ISessionAction)((Object)act)).setSession(null);
            }
            if (isSQLFrame && act instanceof ISQLPanelAction) {
                ((ISQLPanelAction)((Object)act)).setSQLPanel(null);
            }
            if (isTreeFrame && act instanceof IObjectTreeAction) {
                ((IObjectTreeAction)((Object)act)).setObjectTree(null);
            }
            if (isSessionInternalFrame && act instanceof ISQLPanelAction) {
                ((ISQLPanelAction)((Object)act)).setSQLPanel(null);
            }
            if (!isSessionInternalFrame || !(act instanceof IObjectTreeAction)) continue;
            ((IObjectTreeAction)((Object)act)).setObjectTree(null);
        }
    }

    public synchronized void activationChanged(IWidget frame) {
        ActionUpdateHelper actionUpdateHelper = new ActionUpdateHelper(frame);
        Iterator<Action> it = this.actions();
        while (it.hasNext()) {
            Action act = it.next();
            if (act instanceof ISessionAction) {
                ((ISessionAction)((Object)act)).setSession(actionUpdateHelper.getSession());
            }
            if (act instanceof IFileEditAction) {
                ((IFileEditAction)((Object)act)).setFileHandler(actionUpdateHelper.getFileHandler());
            }
            if (act instanceof ISQLPanelAction) {
                ((ISQLPanelAction)((Object)act)).setSQLPanel(actionUpdateHelper.getSQLPanelAPI());
            }
            if (act instanceof IObjectTreeAction) {
                ((IObjectTreeAction)((Object)act)).setObjectTree(actionUpdateHelper.getObjectTreePanel());
            }
            if (!(act instanceof IMainPanelTabAction)) continue;
            ((IMainPanelTabAction)((Object)act)).setSelectedMainPanelTab(actionUpdateHelper.getSelectedMainTab());
        }
    }

    public synchronized void loadActionKeys(ActionKeys[] actionKeys) {
        if (actionKeys == null) {
            throw new IllegalArgumentException("null ActionKeys[] passed");
        }
        for (int i = 0; i < actionKeys.length; ++i) {
            int mnemonic;
            ActionKeys ak = actionKeys[i];
            Action action = this.get(ak.getActionClassName());
            if (action == null) continue;
            String accel = ak.getAccelerator();
            if (accel != null && accel.length() > 0) {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel));
            }
            if ((mnemonic = ak.getMnemonic()) == 0) continue;
            action.putValue("MnemonicKey", mnemonic);
        }
    }

    public Iterator<Action> actions() {
        return this._actionColl.values().iterator();
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this._actionColl.values());
    }

    public synchronized void setCurrentSession(ISession session) {
        Iterator<Action> it = this.actions();
        while (it.hasNext()) {
            Action act = it.next();
            if (!(act instanceof ISessionAction)) continue;
            ((ISessionAction)((Object)act)).setSession(session);
        }
    }

    private Action createAction(String actionClassName) {
        Action action = null;
        try {
            String msg = s_stringMgr.getString("ActionCollection.createActionInfo", actionClassName);
            s_log.info(msg);
            action = (Action)Class.forName(actionClassName).newInstance();
            this._actionColl.put(actionClassName, action);
        }
        catch (Exception ex) {
            String msg = s_stringMgr.getString("ActionCollection.createActionError", actionClassName);
            s_log.error(msg, ex);
        }
        return action;
    }

    private void enableInternalFrameOptions(boolean enable) {
        this.enableAction(CascadeAction.class, enable);
        this.enableAction(MaximizeAction.class, enable);
        this.enableAction(TileAction.class, enable);
        this.enableAction(TileHorizontalAction.class, enable);
        this.enableAction(TileVerticalAction.class, enable);
        this.enableAction(CloseAllSessionsAction.class, enable);
        this.enableAction(CloseAllButCurrentSessionsAction.class, enable);
    }
}

