/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.ISessionWidgetIndexHandler;
import net.sourceforge.squirrel_sql.client.gui.OpeningSequenceBasedSessionWidgetIndexHandler;
import net.sourceforge.squirrel_sql.client.gui.TabSequenceBasedSessionWidgetIndexHandler;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;

public class SessionWindowsHolder {
    HashMap<IIdentifier, List<ISessionWidget>> _framesBySessionIdentifier = new HashMap();
    HashMap<ISessionWidget, IIdentifier> _sessionIdentifierByFrame = new HashMap();
    Vector<ISessionWidget> _framesInOpeningSequence = new Vector();
    private IApplication _app;

    public SessionWindowsHolder(IApplication app) {
        this._app = app;
    }

    public int addFrame(IIdentifier sessionIdentifier, ISessionWidget sessionWidget) {
        List<ISessionWidget> windowList = this._framesBySessionIdentifier.get(sessionIdentifier);
        if (windowList == null) {
            windowList = new ArrayList<ISessionWidget>();
            this._framesBySessionIdentifier.put(sessionIdentifier, windowList);
        }
        windowList.add(sessionWidget);
        this._framesInOpeningSequence.add(sessionWidget);
        this._sessionIdentifierByFrame.put(sessionWidget, sessionIdentifier);
        return windowList.size();
    }

    public ISessionWidget[] getFramesOfSession(IIdentifier sessionIdentifier) {
        List<ISessionWidget> list = this._framesBySessionIdentifier.get(sessionIdentifier);
        if (null == list) {
            return new ISessionWidget[0];
        }
        return list.toArray(new ISessionWidget[list.size()]);
    }

    public void removeWindow(ISessionWidget sessionWidget) {
        IIdentifier sessionIdentifier = this._sessionIdentifierByFrame.get(sessionWidget);
        if (null == sessionIdentifier) {
            throw new IllegalArgumentException("Unknown Frame " + sessionWidget.getTitle());
        }
        List<ISessionWidget> framesOfSession = this._framesBySessionIdentifier.get(sessionIdentifier);
        framesOfSession.remove(sessionWidget);
        this._framesInOpeningSequence.remove(sessionWidget);
        this._sessionIdentifierByFrame.remove(sessionWidget);
    }

    public void removeAllWindows(IIdentifier sessionId) {
        ISessionWidget[] framesOfSession = this.getFramesOfSession(sessionId);
        for (int i = 0; i < framesOfSession.length; ++i) {
            this._framesInOpeningSequence.remove(framesOfSession[i]);
            this._sessionIdentifierByFrame.remove(framesOfSession[i]);
        }
        this._framesBySessionIdentifier.remove(sessionId);
    }

    public ISessionWidget getNextSessionWindow(ISessionWidget sessionWindow) {
        ISessionWidgetIndexHandler indexHandler = this.getSessionWidgetIndexHandler();
        ISessionWidget nextWidget = indexHandler.getNextWidget(sessionWindow);
        if (null != nextWidget) {
            return nextWidget;
        }
        if (1 < indexHandler.size()) {
            return indexHandler.getFirstSessionWidget();
        }
        return sessionWindow;
    }

    public ISessionWidget getPreviousSessionWindow(ISessionWidget sessionWindow) {
        ISessionWidgetIndexHandler indexHandler = this.getSessionWidgetIndexHandler();
        ISessionWidget prevWidget = indexHandler.getPreviousWidget(sessionWindow);
        if (null != prevWidget) {
            return prevWidget;
        }
        if (1 < indexHandler.size()) {
            return indexHandler.getLastSessionWidget();
        }
        return sessionWindow;
    }

    private ISessionWidgetIndexHandler getSessionWidgetIndexHandler() {
        if (this._app.getDesktopStyle().isDockTabStyle()) {
            return new TabSequenceBasedSessionWidgetIndexHandler(this._app);
        }
        return new OpeningSequenceBasedSessionWidgetIndexHandler(this._framesInOpeningSequence);
    }
}

