/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.SchemaPropertiesPanel;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.SchemaTableCboItem;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.SchemaTableModel;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoCacheSerializer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaPropertiesController
implements IAliasPropertiesPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SchemaPropertiesController.class);
    private static final ILogger s_log = LoggerController.createLogger(SchemaPropertiesController.class);
    private static final String PREF_KEY_LAST_SCHEMA_FILTER = "SchemaPropertiesController.last.schema.filter";
    private SchemaPropertiesPanel _pnl;
    private JComboBox _cboTables = new JComboBox();
    private JComboBox _cboView = new JComboBox();
    private JComboBox _cboFunction = new JComboBox();
    private JComboBox _cboUDT = new JComboBox();
    private Color _origTblColor;
    private SQLAlias _alias;
    private IApplication _app;
    private SchemaTableModel _schemaTableModel;

    public SchemaPropertiesController(SQLAlias alias, IApplication app) {
        this._alias = alias;
        this._app = app;
        this._pnl = new SchemaPropertiesPanel();
        this._schemaTableModel = new SchemaTableModel(alias.getSchemaProperties().getSchemaDetails());
        this._pnl.tblSchemas.setModel(this._schemaTableModel);
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        TableColumn tc = new TableColumn(0);
        tc.setHeaderValue(s_stringMgr.getString("SchemaPropertiesController.tableHeader.schema"));
        cm.addColumn(tc);
        tc = new TableColumn(1);
        tc.setHeaderValue(s_stringMgr.getString("SchemaPropertiesController.tableHeader.tables"));
        tc.setCellEditor(new DefaultCellEditor(this.initCbo(this._cboTables)));
        cm.addColumn(tc);
        tc = new TableColumn(2);
        tc.setHeaderValue(s_stringMgr.getString("SchemaPropertiesController.tableHeader.views"));
        tc.setCellEditor(new DefaultCellEditor(this.initCbo(this._cboView)));
        cm.addColumn(tc);
        tc = new TableColumn(3);
        tc.setHeaderValue(s_stringMgr.getString("SchemaPropertiesController.tableHeader.procedures"));
        tc.setCellEditor(new DefaultCellEditor(this.initCbo(this._cboFunction)));
        cm.addColumn(tc);
        tc = new TableColumn(4);
        tc.setHeaderValue(s_stringMgr.getString("SchemaPropertiesController.tableHeader.udts"));
        tc.setCellEditor(new DefaultCellEditor(this.initCbo(this._cboUDT)));
        cm.addColumn(tc);
        this._pnl.tblSchemas.setColumnModel(cm);
        this._pnl.radLoadAllAndCacheNone.setSelected(alias.getSchemaProperties().getGlobalState() == 0);
        this._pnl.radLoadAndCacheAll.setSelected(alias.getSchemaProperties().getGlobalState() == 1);
        this._pnl.radSpecifySchemasByLikeString.setSelected(alias.getSchemaProperties().getGlobalState() == 3);
        this._pnl.txtSchemasByLikeStringInclude.setText(alias.getSchemaProperties().getByLikeStringInclude());
        this._pnl.txtSchemasByLikeStringExclude.setText(alias.getSchemaProperties().getByLikeStringExclude());
        this._pnl.radSpecifySchemas.setSelected(alias.getSchemaProperties().getGlobalState() == 2);
        this._pnl.chkCacheSchemaIndepndentMetaData.setSelected(alias.getSchemaProperties().isCacheSchemaIndependentMetaData());
        this._pnl.txtSchemaFilter.setText(this._app.getPropsImpl().getString(PREF_KEY_LAST_SCHEMA_FILTER, null));
        this._pnl.cboSchemaTableUpdateWhat.addItem(SchemaTableUpdateWhatItem.ALL);
        this._pnl.cboSchemaTableUpdateWhat.addItem(SchemaTableUpdateWhatItem.TABLES);
        this._pnl.cboSchemaTableUpdateWhat.addItem(SchemaTableUpdateWhatItem.VIEWS);
        this._pnl.cboSchemaTableUpdateWhat.addItem(SchemaTableUpdateWhatItem.PROCEDURES);
        this._pnl.cboSchemaTableUpdateWhat.addItem(SchemaTableUpdateWhatItem.UDTS);
        for (int i = 0; i < SchemaTableCboItem.items.length; ++i) {
            this._pnl.cboSchemaTableUpdateTo.addItem(SchemaTableCboItem.items[i]);
        }
        this._pnl.btnSchemaTableUpdateApply.addActionListener(e -> this.onSchemaTableUpdateApply());
        this.updateEnabled();
        this._pnl.radLoadAllAndCacheNone.addActionListener(e -> this.updateEnabled());
        this._pnl.radLoadAndCacheAll.addActionListener(e -> this.updateEnabled());
        this._pnl.radSpecifySchemasByLikeString.addActionListener(e -> this.updateEnabled());
        this._pnl.radSpecifySchemas.addActionListener(e -> this.updateEnabled());
        this._pnl.btnUpdateSchemasTable.addActionListener(e -> this.onRefreshSchemaTable());
        this._pnl.btnClearSchemasTable.addActionListener(e -> this.onClearSchemaTable());
        this._pnl.btnPrintCacheFileLocation.addActionListener(e -> this.onPrintCacheFileLocation());
        this._pnl.btnDeleteCache.addActionListener(e -> this.onDeleteCache());
    }

    private void onDeleteCache() {
        SchemaInfoCacheSerializer.deleteCacheFile(this._app, this._alias, true);
    }

    private void onPrintCacheFileLocation() {
        File schemaCacheFile = SchemaInfoCacheSerializer.getSchemaCacheFile(this._alias);
        String aliasName = null == this._alias.getName() || 0 == this._alias.getName().trim().length() ? "<unnamed>" : this._alias.getName();
        String[] params = new String[]{aliasName, schemaCacheFile.getPath()};
        if (schemaCacheFile.exists()) {
            this._app.getMessageHandler().showMessage(s_stringMgr.getString("SchemaPropertiesController.cacheFilePath", params));
        } else {
            this._app.getMessageHandler().showMessage(s_stringMgr.getString("SchemaPropertiesController.cacheFilePathNotExists", params));
        }
    }

    private void onRefreshSchemaTable() {
        ConnectToAliasCallBack cb = new ConnectToAliasCallBack(this._app, this._alias){

            @Override
            public void connected(ISQLConnection conn) {
                SchemaPropertiesController.this.onConnected(conn);
            }
        };
        ConnectToAliasCommand cmd = new ConnectToAliasCommand(this._app, this._alias, false, cb);
        cmd.execute();
    }

    private void onSchemaTableUpdateApply() {
        TableCellEditor cellEditor = this._pnl.tblSchemas.getCellEditor();
        if (null != cellEditor) {
            cellEditor.stopCellEditing();
        }
        SchemaTableUpdateWhatItem selWhatItem = (SchemaTableUpdateWhatItem)this._pnl.cboSchemaTableUpdateWhat.getSelectedItem();
        SchemaTableCboItem selToItem = (SchemaTableCboItem)this._pnl.cboSchemaTableUpdateTo.getSelectedItem();
        if (SchemaTableUpdateWhatItem.TABLES == selWhatItem) {
            this._schemaTableModel.setColumnTo(1, selToItem, this._pnl.getSchemaFilter());
        } else if (SchemaTableUpdateWhatItem.VIEWS == selWhatItem) {
            this._schemaTableModel.setColumnTo(2, selToItem, this._pnl.getSchemaFilter());
        } else if (SchemaTableUpdateWhatItem.PROCEDURES == selWhatItem) {
            this._schemaTableModel.setColumnTo(3, selToItem, this._pnl.getSchemaFilter());
        } else if (SchemaTableUpdateWhatItem.UDTS == selWhatItem) {
            this._schemaTableModel.setColumnTo(4, selToItem, this._pnl.getSchemaFilter());
        } else {
            this._schemaTableModel.setColumnTo(1, selToItem, this._pnl.getSchemaFilter());
            this._schemaTableModel.setColumnTo(2, selToItem, this._pnl.getSchemaFilter());
            this._schemaTableModel.setColumnTo(3, selToItem, this._pnl.getSchemaFilter());
            this._schemaTableModel.setColumnTo(4, selToItem, this._pnl.getSchemaFilter());
        }
    }

    private synchronized void onConnected(ISQLConnection conn) {
        try {
            String[] schemas = this._app.getSessionManager().getAllowedSchemas(conn, this._alias, null);
            this._schemaTableModel.updateSchemas(schemas);
            this.updateEnabled();
        }
        catch (Exception e) {
            s_log.error("Failed to load Schemas", e);
        }
    }

    private void onClearSchemaTable() {
        this._schemaTableModel.clear();
    }

    private void updateEnabled() {
        if (null == this._origTblColor) {
            this._origTblColor = this._pnl.tblSchemas.getForeground();
        }
        this._pnl.btnUpdateSchemasTable.setEnabled(this._pnl.radSpecifySchemas.isSelected());
        this._pnl.tblSchemas.setEnabled(this._pnl.radSpecifySchemas.isSelected());
        this._pnl.cboSchemaTableUpdateWhat.setEnabled(this._pnl.radSpecifySchemas.isSelected());
        this._pnl.txtSchemaFilter.setEnabled(this._pnl.radSpecifySchemas.isSelected());
        this._pnl.cboSchemaTableUpdateTo.setEnabled(this._pnl.radSpecifySchemas.isSelected());
        this._pnl.btnSchemaTableUpdateApply.setEnabled(this._pnl.radSpecifySchemas.isSelected());
        this._pnl.txtSchemasByLikeStringInclude.setEnabled(this._pnl.radSpecifySchemasByLikeString.isSelected());
        this._pnl.txtSchemasByLikeStringExclude.setEnabled(this._pnl.radSpecifySchemasByLikeString.isSelected());
        if (this._pnl.radSpecifySchemas.isSelected()) {
            this._pnl.tblSchemas.setForeground(this._origTblColor);
        } else {
            this._pnl.tblSchemas.setForeground(Color.lightGray);
        }
    }

    private JComboBox initCbo(JComboBox cbo) {
        cbo.setEditable(false);
        for (int i = 0; i < SchemaTableCboItem.items.length; ++i) {
            cbo.addItem(SchemaTableCboItem.items[i]);
        }
        cbo.setSelectedIndex(0);
        return cbo;
    }

    @Override
    public void applyChanges() {
        TableCellEditor cellEditor = this._pnl.tblSchemas.getCellEditor();
        if (null != cellEditor) {
            cellEditor.stopCellEditing();
        }
        if (this._pnl.radLoadAllAndCacheNone.isSelected()) {
            this._alias.getSchemaProperties().setGlobalState(0);
        } else if (this._pnl.radLoadAndCacheAll.isSelected()) {
            this._alias.getSchemaProperties().setGlobalState(1);
        } else if (this._pnl.radSpecifySchemasByLikeString.isSelected()) {
            this._alias.getSchemaProperties().setGlobalState(3);
        } else if (this._pnl.radSpecifySchemas.isSelected()) {
            this._alias.getSchemaProperties().setGlobalState(2);
        }
        this._alias.getSchemaProperties().setByLikeStringInclude(this._pnl.txtSchemasByLikeStringInclude.getText());
        this._alias.getSchemaProperties().setByLikeStringExclude(this._pnl.txtSchemasByLikeStringExclude.getText());
        this._alias.getSchemaProperties().setSchemaDetails(this._schemaTableModel.getData());
        this._alias.getSchemaProperties().setCacheSchemaIndependentMetaData(this._pnl.chkCacheSchemaIndepndentMetaData.isSelected());
        this._app.getPropsImpl().put(PREF_KEY_LAST_SCHEMA_FILTER, this._pnl.txtSchemaFilter.getText());
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SchemaPropertiesController.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("SchemaPropertiesController.hint");
    }

    @Override
    public Component getPanelComponent() {
        return this._pnl;
    }

    static /* synthetic */ StringManager access$100() {
        return s_stringMgr;
    }

    private static class SchemaTableUpdateWhatItem {
        public static final SchemaTableUpdateWhatItem TABLES = new SchemaTableUpdateWhatItem(SchemaPropertiesController.access$100().getString("SchemaTableUpdateWhatItem.tables"));
        public static final SchemaTableUpdateWhatItem VIEWS = new SchemaTableUpdateWhatItem(SchemaPropertiesController.access$100().getString("SchemaTableUpdateWhatItem.views"));
        public static final SchemaTableUpdateWhatItem PROCEDURES = new SchemaTableUpdateWhatItem(SchemaPropertiesController.access$100().getString("SchemaTableUpdateWhatItem.procedures"));
        public static final SchemaTableUpdateWhatItem UDTS = new SchemaTableUpdateWhatItem(SchemaPropertiesController.access$100().getString("SchemaTableUpdateWhatItem.udts"));
        public static final SchemaTableUpdateWhatItem ALL = new SchemaTableUpdateWhatItem(SchemaPropertiesController.access$100().getString("SchemaTableUpdateWhatItem.allObjects"));
        private String _name;

        private SchemaTableUpdateWhatItem(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

