/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.CancelStatementThread;
import net.sourceforge.squirrel_sql.client.session.DataSetUpdateableTableModelImpl;
import net.sourceforge.squirrel_sql.client.session.DefaultSQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.StatementWrapper;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoUpdateCheck;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.QueryHolder;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLExecuterTask
implements Runnable {
    private static final ILogger s_log = LoggerController.createLogger(SQLExecuterTask.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLExecuterTask.class);
    private ISQLExecuterHandler _handler;
    private ISession _session;
    private String _sql;
    private boolean _stopExecution = false;
    private int _currentQueryIndex = 0;
    private ISQLExecutionListener[] _executionListeners;
    private SchemaInfoUpdateCheck _schemaInfoUpdateCheck;
    private IQueryTokenizer _tokenizer = null;
    private boolean schemaCheck = true;
    private StatementWrapper _currentStatementWrapper;
    private String _tableToBeEdited;
    private boolean _executeEditableCheck = true;

    public SQLExecuterTask(ISession session, String sql, ISQLExecuterHandler handler) {
        this(session, sql, handler, new ISQLExecutionListener[0]);
    }

    public SQLExecuterTask(ISession session, String sql, ISQLExecuterHandler handler, ISQLExecutionListener[] executionListeners) {
        this(session, sql, handler, executionListeners, null);
    }

    public SQLExecuterTask(ISession session, String sql, ISQLExecuterHandler handler, ISQLExecutionListener[] executionListeners, String tableToBeEdited) {
        this._tableToBeEdited = tableToBeEdited;
        this._session = session;
        this._schemaInfoUpdateCheck = new SchemaInfoUpdateCheck(this._session);
        this._sql = sql;
        this._tokenizer = this._session.getQueryTokenizer();
        this._tokenizer.setScriptToTokenize(this._sql);
        this._handler = handler;
        if (this._handler == null) {
            this._handler = new DefaultSQLExecuterHandler(session);
        }
        this._executionListeners = executionListeners;
    }

    public void setExecutionListeners(ISQLExecutionListener[] executionListeners) {
        this._executionListeners = executionListeners;
    }

    public void setExecuteEditableCheck(boolean executeEditableCheck) {
        this._executeEditableCheck = executeEditableCheck;
    }

    public int getQueryCount() {
        return this._tokenizer.getQueryCount();
    }

    public void setSchemaCheck(boolean aBoolean) {
        this.schemaCheck = aBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._sql == null) {
            return;
        }
        String lastExecutedStatement = null;
        int statementCount = 0;
        SessionProperties props = this._session.getProperties();
        ArrayList<String> sqlExecErrorMsgs = new ArrayList<String>();
        try {
            ISQLConnection conn = this._session.getSQLConnection();
            boolean correctlySupportsMaxRows = conn.getSQLMetaData().correctlySupportsSetMaxRows();
            if (this._tokenizer.getQueryCount() == 0) {
                throw new IllegalArgumentException("No SQL selected for execution.");
            }
            this._currentQueryIndex = 0;
            int processedStatementCount = 0;
            statementCount = this._tokenizer.getQueryCount();
            this._handler.sqlStatementCount(statementCount);
            while (this._tokenizer.hasQuery() && !this._stopExecution) {
                QueryHolder querySql = this._tokenizer.nextQuery();
                if (querySql == null) continue;
                ++processedStatementCount;
                if (this._handler != null) {
                    this._handler.sqlToBeExecuted(querySql.getQuery());
                }
                this._currentStatementWrapper = new StatementWrapper(conn.createStatement(), this._session);
                this._currentStatementWrapper.setFetchSize();
                if (correctlySupportsMaxRows) {
                    this._currentStatementWrapper.setMaxRows();
                }
                if (!correctlySupportsMaxRows) {
                    if (this.isSelectStatement(querySql.getQuery())) {
                        this._currentStatementWrapper.setMaxRows();
                    } else if (this._currentStatementWrapper.isMaxRowsWasSet()) {
                        this._currentStatementWrapper.closeIfContinueReadIsNotActive();
                        this._currentStatementWrapper = new StatementWrapper(conn.createStatement(), this._session);
                    }
                }
                try {
                    lastExecutedStatement = querySql.getQuery();
                    if (this.processQuery(querySql, processedStatementCount, statementCount, this._currentStatementWrapper)) continue;
                    break;
                }
                catch (SQLException ex) {
                    if (!this._stopExecution) {
                        if (props.getAbortOnError()) {
                            throw ex;
                        }
                        if (1 < statementCount) {
                            sqlExecErrorMsgs.add(this.handleError(ex, "Error occurred in:\n" + lastExecutedStatement));
                            continue;
                        }
                        sqlExecErrorMsgs.add(this.handleError(ex, null));
                        continue;
                    }
                    break;
                }
                finally {
                    this._currentStatementWrapper.closeIfContinueReadIsNotActive();
                }
            }
        }
        catch (Throwable ex) {
            if (props.getAbortOnError() && 1 < statementCount) {
                sqlExecErrorMsgs.add(this.handleError(ex, "Error occurred in:\n" + lastExecutedStatement));
            } else {
                sqlExecErrorMsgs.add(this.handleError(ex, null));
            }
            if (!(ex instanceof SQLException)) {
                s_log.error("Unexpected exception when executing SQL: " + ex, ex);
                this.enableEventQueueOutOfMemoryHandling(ex);
            }
        }
        finally {
            if (this._stopExecution && this._handler != null) {
                this._handler.sqlExecutionCancelled();
            }
            if (this._handler != null) {
                this._handler.sqlCloseExecutionHandler(sqlExecErrorMsgs, lastExecutedStatement);
            }
            if (this.schemaCheck) {
                try {
                    this._schemaInfoUpdateCheck.flush();
                }
                catch (Throwable t) {
                    s_log.error("Could not update cache ", t);
                }
            }
            this.fireExecutionListenersFinshed();
        }
    }

    private void enableEventQueueOutOfMemoryHandling(final Throwable ex) {
        if (ex instanceof OutOfMemoryError) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    throw new RuntimeException(ex);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private boolean isSelectStatement(String querySql) {
        return "SELECT".length() < querySql.trim().length() && "SELECT".equalsIgnoreCase(querySql.trim().substring(0, "SELECT".length()));
    }

    public void cancel() {
        if (this._stopExecution) {
            return;
        }
        this._handler.sqlExecutionCancelled();
        String msg = s_stringMgr.getString("SQLResultExecuterPanel.canceleRequested");
        this._session.getApplication().getMessageHandler().showMessage(msg);
        this._stopExecution = true;
        if (null != this._currentStatementWrapper) {
            CancelStatementThread cst = new CancelStatementThread(this._currentStatementWrapper, this._session.getApplication().getMessageHandler());
            cst.tryCancel();
        }
    }

    private boolean processQuery(QueryHolder sql, int processedStatementCount, int statementCount, StatementWrapper statementWrapper) throws SQLException {
        ++this._currentQueryIndex;
        SQLExecutionInfo exInfo = new SQLExecutionInfo(this._currentQueryIndex, sql, statementWrapper.getMaxRows(), this._tableToBeEdited);
        boolean firstResultIsResultSet = statementWrapper.execute(sql.getQuery());
        exInfo.sqlExecutionComplete();
        this.handleAllWarnings(this._session.getSQLConnection(), statementWrapper);
        boolean supportsMultipleResultSets = this._session.getSQLConnection().getSQLMetaData().supportsMultipleResultSets();
        boolean inFirstLoop = true;
        DataSetUpdateableTableModelImpl dataSetUpdateableTableModel = new DataSetUpdateableTableModelImpl();
        dataSetUpdateableTableModel.setSession(this._session);
        while (true) {
            if (this._stopExecution) {
                return false;
            }
            int updateCount = statementWrapper.getUpdateCount();
            ResultSetWrapper res = null;
            if (inFirstLoop && firstResultIsResultSet) {
                res = statementWrapper.getResultSetWrapper();
            } else if (!inFirstLoop) {
                res = statementWrapper.getResultSetWrapper();
            }
            if (-1 != updateCount && this._handler != null) {
                this._handler.sqlDataUpdated(updateCount);
            }
            if (null != res) {
                boolean moreResultsReceived = false;
                while (true) {
                    if (!this.processResultSet(res, exInfo, dataSetUpdateableTableModel)) {
                        return false;
                    }
                    if (this._stopExecution) {
                        return false;
                    }
                    if (!supportsMultipleResultSets || !statementWrapper.getMoreResults()) break;
                    res = statementWrapper.getResultSetWrapper();
                    moreResultsReceived = true;
                }
                if (moreResultsReceived) {
                    updateCount = statementWrapper.getUpdateCount();
                }
            }
            if (!supportsMultipleResultSets || !statementWrapper.getMoreResults() && -1 == updateCount) break;
            inFirstLoop = false;
        }
        this.fireExecutionListeners(sql);
        if (this._handler != null) {
            this._handler.sqlExecutionComplete(exInfo, processedStatementCount, statementCount);
        }
        EditableSqlCheck edittableCheck = new EditableSqlCheck(exInfo);
        if (this._executeEditableCheck && edittableCheck.allowsEditing()) {
            TableInfo ti = this.getTableName(edittableCheck.getTableNameFromSQL());
            dataSetUpdateableTableModel.setTableInfo(ti);
        } else {
            dataSetUpdateableTableModel.setTableInfo(null);
        }
        if (this.schemaCheck) {
            this._schemaInfoUpdateCheck.addExecutionInfo(exInfo);
        }
        return true;
    }

    private void fireExecutionListeners(final QueryHolder sql) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < SQLExecuterTask.this._executionListeners.length; ++i) {
                    SQLExecuterTask.this._executionListeners[i].statementExecuted(sql);
                }
            }
        });
    }

    private void fireExecutionListenersFinshed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < SQLExecuterTask.this._executionListeners.length; ++i) {
                    SQLExecuterTask.this._executionListeners[i].executionFinished();
                }
            }
        });
    }

    private boolean processResultSet(ResultSetWrapper rs, SQLExecutionInfo exInfo, DataSetUpdateableTableModelImpl dataSetUpdateableTableModel) {
        if (this._stopExecution) {
            return false;
        }
        if (this._handler != null) {
            try {
                this._handler.sqlResultSetAvailable(rs, exInfo, dataSetUpdateableTableModel);
            }
            catch (DataSetException ex) {
                if (this._stopExecution) {
                    return false;
                }
                this._session.showMessage(ex);
                s_log.error("Error reading ResultSet for SQL: " + exInfo.getSQL(), ex);
            }
        }
        this.handleResultSetWarnings(rs.getResultSet());
        rs.closeIfContinueReadIsNotActive();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAllWarnings(ISQLConnection conn, StatementWrapper stmtWrapper) {
        ISQLConnection iSQLConnection = conn;
        synchronized (iSQLConnection) {
            try {
                this.handleWarnings(conn.getWarnings());
                conn.getConnection().clearWarnings();
            }
            catch (Throwable th) {
                s_log.debug("Driver doesn't handle Connection.getWarnings()/clearWarnings()", th);
            }
        }
        try {
            this.handleWarnings(stmtWrapper.getWarnings());
            stmtWrapper.clearWarnings();
        }
        catch (Throwable th) {
            s_log.debug("Driver doesn't handle Statement.getWarnings()/clearWarnings()", th);
        }
    }

    private void handleResultSetWarnings(ResultSet rs) {
        try {
            this.handleWarnings(rs.getWarnings());
        }
        catch (Throwable th) {
            s_log.error("Can't get warnings from ResultSet", th);
            this._session.showMessage(th);
        }
    }

    private void handleWarnings(SQLWarning sw) {
        if (this._handler != null) {
            try {
                while (sw != null) {
                    this._handler.sqlExecutionWarning(sw);
                    sw = sw.getNextWarning();
                }
            }
            catch (Throwable th) {
                s_log.debug("Driver/DBMS can't handle SQLWarnings", th);
            }
        }
    }

    private String handleError(Throwable th, String postErrorString) {
        if (this._handler != null) {
            return this._handler.sqlExecutionException(th, postErrorString);
        }
        return null;
    }

    public TableInfo getTableName(String tableNameFromSQL) {
        String tableNameFromSQLDoubleQuotesRemoved;
        ITableInfo[] tables = this._session.getSchemaInfo().getITableInfos();
        for (int i = 0; i < tables.length; ++i) {
            String simpleName;
            String nameWithSchema = simpleName = tables[i].getSimpleName().toUpperCase();
            String nameWithSchemaAndCatalog = simpleName;
            if (null != tables[i].getSchemaName() && 0 < tables[i].getSchemaName().length()) {
                nameWithSchemaAndCatalog = nameWithSchema = tables[i].getSchemaName().toUpperCase() + "." + nameWithSchema;
            }
            if (null != tables[i].getCatalogName() && 0 < tables[i].getCatalogName().length()) {
                nameWithSchemaAndCatalog = tables[i].getCatalogName().toUpperCase() + "." + nameWithSchema;
            }
            if (!simpleName.equals(tableNameFromSQL) && !nameWithSchema.equals(tableNameFromSQL) && !nameWithSchemaAndCatalog.equals(tableNameFromSQL)) continue;
            return (TableInfo)tables[i];
        }
        String[] parts = tableNameFromSQL.split("\\.");
        if (parts.length == 2) {
            String catalogOrSchema = parts[0];
            String simpleName = parts[1];
            tables = this._session.getSchemaInfo().getITableInfos(catalogOrSchema, null, simpleName);
            if (tables != null && tables.length > 0) {
                return (TableInfo)tables[0];
            }
            tables = this._session.getSchemaInfo().getITableInfos(null, catalogOrSchema, simpleName);
            if (tables != null && tables.length > 0) {
                return (TableInfo)tables[0];
            }
        }
        if (tableNameFromSQL.equals(tableNameFromSQLDoubleQuotesRemoved = tableNameFromSQL.replaceAll("\"", ""))) {
            return null;
        }
        return this.getTableName(tableNameFromSQLDoubleQuotesRemoved);
    }
}

