/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.BaseTableTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RowCountTab
extends BaseTableTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowCountTab.class);

    @Override
    public String getTitle() {
        return s_stringMgr.getString("RowCountTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("RowCountTab.hint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IDataSet createDataSet() throws DataSetException {
        ISQLConnection conn = this.getSession().getSQLConnection();
        try (Statement stmt = conn.createStatement();){
            ResultSetDataSet resultSetDataSet;
            ResultSet rs = stmt.executeQuery("select count(*) from " + this.getTableInfo().getQualifiedName());
            try {
                ResultSetDataSet rsds = new ResultSetDataSet();
                rsds.setResultSet(rs, this.getDialectType());
                resultSetDataSet = rsds;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return resultSetDataSet;
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }
}

