/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.BarChartCreator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigMode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigPanelTabMode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.TimeScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.XYChartCreator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.HorizontalAlignment;
import org.jfree.chart.ui.RectangleEdge;

public class ChartHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChartHandler.class);
    public static final int MAX_LEGEND_ENTRIES = 10;

    public static void doChart(DataScale xAxisDataScale, DataScale yAxisDataScale, DataScaleTable dataScaleTable, Integer callDepth, ChartConfigPanelTabMode chartConfigPanelTabMode, ChartConfigMode mode, Frame parent, TimeScale timeScale) {
        try {
            String label;
            JFreeChart chart;
            String title;
            if (chartConfigPanelTabMode == ChartConfigPanelTabMode.XY_CHART || chartConfigPanelTabMode == ChartConfigPanelTabMode.DIFFERENCES_CHART) {
                XYChartCreator xyChartCreator = new XYChartCreator(xAxisDataScale, yAxisDataScale, dataScaleTable, chartConfigPanelTabMode == ChartConfigPanelTabMode.DIFFERENCES_CHART, timeScale);
                title = xyChartCreator.getTitle();
                chart = xyChartCreator.getChart();
                label = xyChartCreator.getLabel();
            } else {
                BarChartCreator barChartCreator = new BarChartCreator(xAxisDataScale, yAxisDataScale, callDepth, mode);
                title = barChartCreator.getTitle();
                chart = barChartCreator.getChart();
                label = barChartCreator.getLabel();
            }
            JFrame f = new JFrame(title);
            ImageIcon icon = Main.getApplication().getResources().getIcon("AppIcon");
            if (icon != null) {
                f.setIconImage(icon.getImage());
            }
            LegendTitle legendtitle = new LegendTitle(ChartHandler.createLegendItemSource(chart));
            BlockContainer blockcontainer = new BlockContainer((Arrangement)new BorderArrangement());
            LabelBlock labelblock = new LabelBlock(label, new Font("SansSerif", 1, 12));
            labelblock.setPadding(5.0, 5.0, 5.0, 5.0);
            blockcontainer.add((Block)labelblock, (Object)RectangleEdge.TOP);
            BlockContainer blockcontainer1 = legendtitle.getItemContainer();
            blockcontainer1.setPadding(2.0, 10.0, 5.0, 2.0);
            blockcontainer.add((Block)blockcontainer1);
            legendtitle.setWrapper(blockcontainer);
            legendtitle.setPosition(RectangleEdge.BOTTOM);
            legendtitle.setHorizontalAlignment(HorizontalAlignment.LEFT);
            chart.addSubtitle((Title)legendtitle);
            ChartPanel chartPanel = new ChartPanel(chart);
            f.getContentPane().add((Component)chartPanel);
            f.setLocation(parent.getLocationOnScreen());
            f.setSize(parent.getSize());
            f.setVisible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static LegendItemSource createLegendItemSource(final JFreeChart chart) {
        return new LegendItemSource(){

            public LegendItemCollection getLegendItems() {
                return ChartHandler.reduceLegendItems(chart);
            }
        };
    }

    private static LegendItemCollection reduceLegendItems(JFreeChart chart) {
        LegendItemCollection legendItems = chart.getPlot().getLegendItems();
        LegendItemCollection ret = new LegendItemCollection();
        for (int i = 0; i < legendItems.getItemCount(); ++i) {
            if (10 < i && 10 < legendItems.getItemCount()) {
                ret.add(new LegendItem("..."));
                ret.add(legendItems.get(legendItems.getItemCount() - 1));
                break;
            }
            ret.add(legendItems.get(i));
        }
        return ret;
    }
}

