/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class Interval {
    private IndexedColumn _indexedColumn;
    private int _firstIx;
    private int _lastIx;
    private Object _beginData;
    private Object _endData;
    private String _label;
    private String _tooltipSmall;
    private final String _tooltipBig;
    private String _report;

    public Interval(IndexedColumn indexedColumn, int firstIx, int lastIx, Object beginData, Object endData) {
        this._indexedColumn = indexedColumn;
        this._firstIx = firstIx;
        this._lastIx = lastIx;
        this._beginData = beginData;
        this._endData = endData;
        Object firstVal = this._indexedColumn.get(firstIx);
        Object lastVal = this._indexedColumn.get(lastIx);
        String firstValRendered = this._indexedColumn.renderObject(firstVal);
        String lastValRendered = this._indexedColumn.renderObject(lastVal);
        this._label = this.hasDifferentValues() ? firstValRendered + " - " + lastValRendered : firstValRendered;
        int distinctValsForColumn = this._indexedColumn.countDistinctValsForColumn();
        int distinctValsInInterval = this._indexedColumn.countDistinctValsForInterval(this._firstIx, this._lastIx);
        this._tooltipSmall = this.createToolTip("<small>", beginData, endData, firstValRendered, lastValRendered, distinctValsForColumn, distinctValsInInterval);
        this._tooltipBig = this.createToolTip("", beginData, endData, firstValRendered, lastValRendered, distinctValsForColumn, distinctValsInInterval);
        this._report = "<html><table><tr><th>" + this.escapeHtmlChars(this._label) + "</th></tr><tr><td><table><tr><td>row count</td><td>" + this.getLen() + "</td></tr><tr><td>percentage</td><td>" + String.format("%.3f", 100.0 * this.getWight()) + "%</td></tr><tr><td>from-to index</td><td>" + this._firstIx + " - " + this._lastIx + "</td></tr></table></tr></td></table></html>";
    }

    private String createToolTip(String size, Object beginData, Object endData, String firstValRendered, String lastValRendered, int distinctValsForColumn, int distinctValsInInterval) {
        String tooltip = "<html> " + size + "<b>Interval details for column <i>" + this._indexedColumn.getColumnName() + "</i></b><br><table BORDER=1><tr><td>" + size + "Interval bounds (first/last data value)</td><td>" + size + this.escapeHtmlChars(this._label) + "</td></tr><tr><td>" + size + "Interval bounds (calculated)</td><td>" + size + this.getIntervalOpeningBracket() + this.escapeHtmlChars(this._indexedColumn.renderObject(beginData)) + ", " + this.escapeHtmlChars(this._indexedColumn.renderObject(endData)) + this.getIntervalClosingBracket() + "</td></tr><tr><td>" + size + "Number of values in Interval</td><td>" + size + this.getLen() + " (percentage = " + String.format("%.3f", 100.0 * this.getWight()) + "%)</td></tr><tr><td>" + size + "Number of distinct values in Interval</td><td>" + size + distinctValsInInterval + "</td></tr><tr><td>" + size + "First index = " + this._firstIx + "</td><td>" + size + "Last Index = " + this._lastIx + "<br></tr></table><br>" + size + "<b>Details of complete Overview</b><br>" + size + "<table BORDER=1>" + size + "<tr><td>" + size + "Number of distinct values for column <i>" + this._indexedColumn.getColumnName() + "</i> in Overview</td><td>" + size + distinctValsForColumn + "</td></tr><tr><td>" + size + "Complete row count of underlying data in Overview</td><td>" + size + this._indexedColumn.size() + "</td></tr></table></html>";
        return tooltip;
    }

    private String getIntervalOpeningBracket() {
        if (0 == this._indexedColumn.compareObjects(this._indexedColumn.get(this._firstIx), this._beginData)) {
            return "[";
        }
        return "]";
    }

    private String getIntervalClosingBracket() {
        if (0 == this._indexedColumn.compareObjects(this._indexedColumn.get(this._lastIx), this._endData)) {
            return "]";
        }
        return "[";
    }

    public int getLen() {
        return this._lastIx - this._firstIx + 1;
    }

    private String escapeHtmlChars(String sql) {
        String buf = sql.replaceAll("&", "&amp;");
        buf = buf.replaceAll("<", "&lt;");
        buf = buf.replaceAll("<", "&gt;");
        buf = buf.replaceAll("\"", "&quot;");
        return buf;
    }

    private boolean hasDifferentValues() {
        Object lastVal;
        Object firstVal = this._indexedColumn.get(this._firstIx);
        return false == Utilities.equalsRespectNull(firstVal, lastVal = this._indexedColumn.get(this._lastIx));
    }

    public double getWight() {
        return (double)this.getLen() / (double)this._indexedColumn.size();
    }

    public String getLabel() {
        return this._label;
    }

    public String getSmallToolTipHtml() {
        return this._tooltipSmall;
    }

    public String getBigToolTipHtml() {
        return this._tooltipBig;
    }

    public String getReport() {
        return this._report;
    }

    public List<Object[]> getResultRows() {
        return this._indexedColumn.getResultRows(this._firstIx, this._lastIx);
    }

    public boolean containsAllRows() {
        return this.getLen() == this._indexedColumn.size();
    }

    public String getWidth() {
        return this._indexedColumn.calculateDist(this._beginData, this._endData);
    }

    public Object get(int i) {
        return this._indexedColumn.get(this._firstIx + i);
    }

    public int getDataSetRowIndex(int intervalIx) {
        return this._indexedColumn.getRowIx(this._firstIx + intervalIx);
    }

    public IndexedColumn getIndexedColumn() {
        return this._indexedColumn;
    }
}

