/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.PopupEditableIOPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class CellDataColumnDataPopupPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDataColumnDataPopupPanel.class);
    private final PopupEditableIOPanel ioPanel;
    private JDialog _parentFrame = null;
    private int _row;
    private int _col;
    private JTable _table;

    CellDataColumnDataPopupPanel(Object cellContents, ColumnDisplayDefinition colDef, boolean tableIsEditable) {
        super(new BorderLayout());
        if (tableIsEditable && CellComponentFactory.isEditableInPopup(colDef, cellContents)) {
            this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, true);
            JPanel editingControls = this.createPopupEditingControls();
            this.add((Component)editingControls, "South");
        } else {
            this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, false);
        }
        this.add((Component)this.ioPanel, "Center");
    }

    private JPanel createPopupEditingControls() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel updateControls = new JPanel();
        JButton updateButton = new JButton(s_stringMgr.getString("cellDataPopUp.updateData"));
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StringBuffer messageBuffer = new StringBuffer();
                Object newValue = CellDataColumnDataPopupPanel.this.ioPanel.getObject(messageBuffer);
                if (messageBuffer.length() > 0) {
                    String msg = s_stringMgr.getString("cellDataPopUp.cannnotBGeConverted", messageBuffer);
                    JOptionPane.showMessageDialog(CellDataColumnDataPopupPanel.this, msg, s_stringMgr.getString("cellDataPopUp.conversionError"), 0);
                    CellDataColumnDataPopupPanel.this.ioPanel.requestFocus();
                } else {
                    CellDataColumnDataPopupPanel.this._table.setValueAt(newValue, CellDataColumnDataPopupPanel.this._row, CellDataColumnDataPopupPanel.this._col);
                    CellDataColumnDataPopupPanel.this._parentFrame.setVisible(false);
                    CellDataColumnDataPopupPanel.this._parentFrame.dispose();
                }
            }
        });
        JButton cancelButton = new JButton(s_stringMgr.getString("cellDataPopup.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CellDataColumnDataPopupPanel.this._parentFrame.setVisible(false);
                CellDataColumnDataPopupPanel.this._parentFrame.dispose();
            }
        });
        updateControls.add(updateButton);
        updateControls.add(cancelButton);
        panel.add((Component)updateControls, "South");
        return panel;
    }

    public void setUserActionInfo(JDialog parent, int row, int col, JTable table) {
        this._parentFrame = parent;
        this._row = row;
        this._col = col;
        this._table = table;
    }
}

