/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.gui.FontFamilyWrapper;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FontChooser
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FontChooser.class);
    private final boolean _selectStyles;
    private JComboBox _fontNamesCmb;
    private final JComboBox _fontSizesCmb = new JComboBox<String>(new String[]{"8", "9", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28"});
    private final JCheckBox _boldChk = new JCheckBox(s_stringMgr.getString("FontChooser.bold"));
    private final JCheckBox _italicChk = new JCheckBox(s_stringMgr.getString("FontChooser.italic"));
    private final JLabel _previewLbl = new JLabel(s_stringMgr.getString("FontChooser.previewText"));
    private Font _font;
    private ActionListener _previewUpdater;

    public FontChooser() {
        this((Frame)null);
    }

    public FontChooser(boolean selectStyles) {
        this((Frame)null, selectStyles);
    }

    public FontChooser(Frame owner) {
        this(owner, true);
    }

    public FontChooser(Frame owner, boolean selectStyles) {
        super(owner, s_stringMgr.getString("FontChooser.title"), true);
        this._selectStyles = selectStyles;
        this.createUserInterface();
    }

    public FontChooser(Dialog owner) {
        this(owner, true);
    }

    public FontChooser(Dialog owner, boolean selectStyles) {
        super(owner, s_stringMgr.getString("FontChooser.title"), true);
        this._selectStyles = selectStyles;
        this.createUserInterface();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._previewUpdater == null) {
            this._previewUpdater = new PreviewLabelUpdater();
            this._fontNamesCmb.addActionListener(this._previewUpdater);
            this._fontSizesCmb.addActionListener(this._previewUpdater);
            this._boldChk.addActionListener(this._previewUpdater);
            this._italicChk.addActionListener(this._previewUpdater);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._previewUpdater != null) {
            this._fontNamesCmb.removeActionListener(this._previewUpdater);
            this._fontSizesCmb.removeActionListener(this._previewUpdater);
            this._boldChk.removeActionListener(this._previewUpdater);
            this._italicChk.removeActionListener(this._previewUpdater);
            this._previewUpdater = null;
        }
    }

    public Font showDialog() {
        return this.showDialog(null);
    }

    public Font showDialog(Font font) {
        if (font != null) {
            this._fontNamesCmb.setSelectedItem(FontFamilyWrapper.wrap(this, font.getName()));
            this._fontSizesCmb.setSelectedItem("" + font.getSize());
            this._boldChk.setSelected(this._selectStyles && font.isBold());
            this._italicChk.setSelected(this._selectStyles && font.isItalic());
        } else {
            this._fontNamesCmb.setSelectedIndex(0);
            this._fontSizesCmb.setSelectedIndex(0);
            this._boldChk.setSelected(false);
            this._italicChk.setSelected(false);
        }
        this.setupPreviewLabel();
        this.setVisible(true);
        return this._font;
    }

    public Font getSelectedFont() {
        return this._font;
    }

    protected void setupFontFromDialog() {
        int size = 12;
        try {
            size = Integer.parseInt((String)this._fontSizesCmb.getSelectedItem());
        }
        catch (Exception exception) {
            // empty catch block
        }
        FontInfo fi = new FontInfo();
        fi.setFamily(((FontFamilyWrapper)this._fontNamesCmb.getSelectedItem()).getFontFamilyName());
        fi.setSize(size);
        fi.setIsBold(this._boldChk.isSelected());
        fi.setIsItalic(this._italicChk.isSelected());
        this._font = fi.createFont();
    }

    private void createUserInterface() {
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.setContentPane(content);
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        content.add((Component)new JLabel(s_stringMgr.getString("FontChooser.font")), gbc);
        ++gbc.gridx;
        content.add((Component)new JLabel(s_stringMgr.getString("FontChooser.size")), gbc);
        if (this._selectStyles) {
            ++gbc.gridx;
            content.add((Component)new JLabel(s_stringMgr.getString("FontChooser.style")), gbc);
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        this._fontNamesCmb = new JComboBox<FontFamilyWrapper>(FontFamilyWrapper.createWrappers(this));
        content.add((Component)this._fontNamesCmb, gbc);
        ++gbc.gridx;
        this._fontSizesCmb.setEditable(true);
        content.add((Component)this._fontSizesCmb, gbc);
        if (this._selectStyles) {
            ++gbc.gridx;
            content.add((Component)this._boldChk, gbc);
            ++gbc.gridy;
            content.add((Component)this._italicChk, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.anchor = 10;
        content.add((Component)this.createPreviewPanel(), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        content.add((Component)this.createButtonsPanel(), gbc);
        this.pack();
        GUIUtils.centerWithinParent(this);
        this.setResizable(true);
    }

    private JPanel createPreviewPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("FontChooser.previewTitle")));
        Dimension prefSize = this._previewLbl.getPreferredSize();
        prefSize.height = 50;
        this._previewLbl.setPreferredSize(prefSize);
        pnl.add((Component)this._previewLbl, "Center");
        this.setupPreviewLabel();
        return pnl;
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("FontChooser.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.setupFontFromDialog();
                FontChooser.this.dispose();
            }
        });
        JButton cancelBtn = new JButton(s_stringMgr.getString("FontChooser.cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this._font = null;
                FontChooser.this.dispose();
            }
        });
        pnl.add(okBtn);
        pnl.add(cancelBtn);
        GUIUtils.setJButtonSizesTheSame(new JButton[]{okBtn, cancelBtn});
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private void setupPreviewLabel() {
        this.setupFontFromDialog();
        this._previewLbl.setFont(this._font);
    }

    private final class PreviewLabelUpdater
    implements ActionListener {
        private PreviewLabelUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FontChooser.this.setupPreviewLabel();
        }
    }
}

