/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerField
extends JTextField {
    public IntegerField() {
        super(10);
    }

    public IntegerField(int cols) {
        super(cols);
    }

    public int getInt() {
        String text = this.getText();
        if (text == null || text.length() == 0) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    public void setInt(int value) {
        this.setText(String.valueOf(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new IntegerDocument(this.getColumns());
    }

    private static class IntegerDocument
    extends PlainDocument {
        private int _columns;

        public IntegerDocument(int columns) {
            this._columns = columns;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet set) throws BadLocationException {
            if (str != null) {
                try {
                    Integer.decode(str);
                    if (this.getLength() + str.length() <= this._columns) {
                        super.insertString(offs, str, set);
                    }
                }
                catch (NumberFormatException ex) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

