/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultMetaDataTable;
import net.sourceforge.squirrel_sql.fw.gui.action.InStatColumnInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ReferencesFrameStarter;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.RootTable;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ShowReferencesCommand {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowReferencesCommand.class);
    private final JTable _table;
    private final IDataSetUpdateableModel _updateableModel;
    private JFrame _owningFrame;
    private ISession _session;

    public ShowReferencesCommand(JTable table, IDataSetUpdateableModel updateableModel, JFrame owningFrame, ISession session) {
        this._table = table;
        this._updateableModel = updateableModel;
        this._owningFrame = owningFrame;
        this._session = session;
    }

    public void execute() {
        ITableInfo ti;
        ResultMetaDataTable globalDbTable = null;
        if (this._updateableModel instanceof IDataSetUpdateableTableModel && null != (ti = ((IDataSetUpdateableTableModel)this._updateableModel).getTableInfo())) {
            globalDbTable = new ResultMetaDataTable(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
        }
        ArrayList<InStatColumnInfo> inStatColumnInfos = new TableCopyInStatementCommand(this._table).getInStatColumnInfos();
        if (null == globalDbTable) {
            List<ResultMetaDataTable> tables = this.findTable(inStatColumnInfos);
            if (0 == tables.size()) {
                JOptionPane.showMessageDialog(this._owningFrame, s_stringMgr.getString("ShowReferencesCommand.noTable"));
                return;
            }
            if (1 < tables.size()) {
                JOptionPane.showMessageDialog(this._owningFrame, s_stringMgr.getString("ShowReferencesCommand.non.unique.table"));
                return;
            }
            globalDbTable = tables.get(0);
        }
        ReferencesFrameStarter.showReferences(new RootTable(globalDbTable, inStatColumnInfos), this._session, this._owningFrame);
    }

    private List<ResultMetaDataTable> findTable(ArrayList<InStatColumnInfo> inStatColumnInfos) {
        HashMap<String, ResultMetaDataTable> ret = new HashMap<String, ResultMetaDataTable>();
        for (InStatColumnInfo inStatColumnInfo : inStatColumnInfos) {
            ResultMetaDataTable buf = inStatColumnInfo.getColDef().getResultMetaDataTable();
            if (null == buf) continue;
            ret.put(buf.getQualifiedName().toLowerCase(), buf);
        }
        return new ArrayList<ResultMetaDataTable>(ret.values());
    }
}

