/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;

public class TableCopySqlPartCommandBase {
    protected String getData(ColumnDisplayDefinition colDef, Object cellObj, StatType statType) {
        if (cellObj == null) {
            return this.getPrefixForStatType(statType, true) + "null";
        }
        if (null == colDef) {
            return this.getPrefixForStatType(statType, false) + "'" + cellObj.toString().replaceAll("'", "''") + "'";
        }
        if (colDef.getSqlType() == 5 || colDef.getSqlType() == 4 || colDef.getSqlType() == 3 || colDef.getSqlType() == 8 || colDef.getSqlType() == -5 || colDef.getSqlType() == 2 || colDef.getSqlType() == -6 || colDef.getSqlType() == -7 || colDef.getSqlType() == 7) {
            return this.getPrefixForStatType(statType, false) + cellObj.toString();
        }
        if (colDef.getSqlType() == 92 && cellObj instanceof Date) {
            Date date = (Date)cellObj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return this.getPrefixForStatType(statType, false) + "{t '" + this.prefixNulls(cal.get(11), 2) + ":" + this.prefixNulls(cal.get(12), 2) + ":" + this.prefixNulls(cal.get(13), 2) + "'}";
        }
        if (colDef.getSqlType() == 91 && cellObj instanceof Date) {
            Date date = (Date)cellObj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return this.getPrefixForStatType(statType, false) + "{d '" + this.prefixNulls(cal.get(1), 4) + "-" + this.prefixNulls(cal.get(2) + 1, 2) + "-" + this.prefixNulls(cal.get(5), 2) + "'}";
        }
        if (colDef.getSqlType() == 93 && cellObj instanceof Date) {
            Date date = (Date)cellObj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return this.getPrefixForStatType(statType, false) + "{ts '" + this.prefixNulls(cal.get(1), 4) + "-" + this.prefixNulls(cal.get(2) + 1, 2) + "-" + this.prefixNulls(cal.get(5), 2) + " " + this.prefixNulls(cal.get(11), 2) + ":" + this.prefixNulls(cal.get(12), 2) + ":" + this.prefixNulls(cal.get(13), 2) + this.getNanoString(date);
        }
        if (cellObj instanceof Byte[] || cellObj instanceof byte[]) {
            int n;
            Byte[] cellObjBytes = null;
            if (cellObj instanceof Byte[]) {
                cellObjBytes = (Byte[])cellObj;
            } else {
                byte[] cellObjBytesPrimitives = (byte[])cellObj;
                cellObjBytes = new Byte[cellObjBytesPrimitives.length];
                int i = 0;
                byte[] byArray = cellObjBytesPrimitives;
                n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte b = byArray[j];
                    cellObjBytes[i++] = b;
                }
            }
            Formatter formatter = new Formatter();
            Byte[] i = cellObjBytes;
            int n2 = i.length;
            for (n = 0; n < n2; ++n) {
                byte b = i[n];
                formatter.format("%02x", b);
            }
            String cellObjStr = formatter.toString();
            formatter.close();
            String prefix = "X'";
            String suffix = "'";
            if (colDef.getDialectType().equals((Object)DialectType.DB2)) {
                if (colDef.getSqlType() == 2004) {
                    prefix = "BLOB(X'";
                    suffix = "')";
                }
            } else if (colDef.getDialectType().equals((Object)DialectType.ORACLE)) {
                prefix = "'";
                suffix = "'";
            } else if (colDef.getDialectType().equals((Object)DialectType.MSSQL)) {
                prefix = "0x";
                suffix = "";
            }
            return this.getPrefixForStatType(statType, false) + prefix + cellObjStr + suffix;
        }
        return this.getPrefixForStatType(statType, false) + "'" + cellObj.toString().replaceAll("'", "''") + "'";
    }

    private String getNanoString(Date date) {
        if (!(date instanceof Timestamp)) {
            return "'}";
        }
        Timestamp ts = (Timestamp)date;
        int nanos = ts.getNanos() / 1000;
        if (0 == nanos) {
            return "'}";
        }
        return "." + this.prefixNulls(nanos, 6) + "'}";
    }

    private String getPrefixForStatType(StatType statType, boolean isNullVal) {
        if (isNullVal) {
            switch (statType) {
                case IN: {
                    return "";
                }
                case WHERE: {
                    return " is ";
                }
                case UPDATE: {
                    return "=";
                }
            }
        } else {
            switch (statType) {
                case IN: {
                    return "";
                }
                case WHERE: {
                    return "=";
                }
                case UPDATE: {
                    return "=";
                }
            }
        }
        throw new IllegalStateException("Can't happen");
    }

    private String prefixNulls(int toPrefix, int digitCount) {
        String ret = "" + toPrefix;
        while (ret.length() < digitCount) {
            ret = 0 + ret;
        }
        return ret;
    }

    static enum StatType {
        IN,
        WHERE,
        UPDATE;

    }
}

