/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.io.File;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IDataExportWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataRow;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class AbstractDataExportFileWriter
implements IDataExportWriter {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractDataExportFileWriter.class);
    private static final int FEEDBACK_EVRY_N_SECONDS = 2;
    private File file;
    private TableExportPreferences _prefs;
    private ProgressAbortCallback progressController;
    private long timeOfLastStatusUpdate = 0L;

    public AbstractDataExportFileWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        this.file = file;
        this._prefs = prefs;
        this.progressController = progressController;
    }

    @Override
    public long write(IExportData data) throws Exception {
        this.beforeWorking(this.file);
        if (this._prefs.isWithHeaders()) {
            Iterator<String> headers = data.getHeaders();
            int colIdx = 0;
            this.beforeHeader();
            while (headers.hasNext()) {
                String columnName = headers.next();
                this.addHeaderCell(colIdx, columnName);
                ++colIdx;
            }
            this.afterHeader();
        }
        Iterator<IExportDataRow> rows = data.getRows();
        this.progress(i18n.BEGIN_WRITING);
        this.beforeRows();
        long rowsCount = 0L;
        NumberFormat nfRowCount = NumberFormat.getInstance();
        long begin = System.currentTimeMillis();
        while (rows.hasNext() && !this.isStop()) {
            ++rowsCount;
            IExportDataRow aRow = rows.next();
            if (this.isStatusUpdateNecessary()) {
                long secondsPassed = (System.currentTimeMillis() - begin) / 1000L;
                this.taskStatus(s_stringMgr.getString("AbstractDataExportFileWriter.numberOfRowsCompletedInSeconds", nfRowCount.format(rowsCount), secondsPassed));
            }
            this.beforeRow(aRow.getRowIndex());
            Iterator<IExportDataCell> cells = aRow.getCells();
            while (cells.hasNext()) {
                IExportDataCell cell = cells.next();
                this.addCell(cell);
            }
            this.afterRow();
        }
        this.progress(s_stringMgr.getString("AbstractDataExportFileWriter.finishedLoading", nfRowCount.format(rowsCount)));
        this.afterRows();
        this.progress(i18n.CLOSING_THE_FILE);
        this.afterWorking();
        this.progress(i18n.DONE);
        if (this.progressController != null) {
            this.progressController.setFinished();
        }
        if (this.isStop()) {
            return -1L;
        }
        return rowsCount;
    }

    private boolean isStatusUpdateNecessary() {
        long time = System.currentTimeMillis();
        if (this.timeOfLastStatusUpdate + TimeUnit.SECONDS.toMillis(2L) < time) {
            this.timeOfLastStatusUpdate = time;
            return true;
        }
        return false;
    }

    public void beforeRows() {
    }

    public void afterRows() {
    }

    public void beforeRow(int rowIdx) throws Exception {
    }

    public void afterRow() throws Exception {
    }

    protected abstract void afterWorking() throws Exception;

    protected abstract void addCell(IExportDataCell var1) throws Exception;

    protected void beforeHeader() throws Exception {
    }

    protected abstract void addHeaderCell(int var1, String var2) throws Exception;

    protected void afterHeader() throws Exception {
    }

    protected abstract void beforeWorking(File var1) throws Exception;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public TableExportPreferences getPrefs() {
        return this._prefs;
    }

    public void setPrefs(TableExportPreferences prefs) {
        this._prefs = prefs;
    }

    protected void progress(String task) {
        if (this.progressController != null) {
            this.progressController.currentlyLoading(task);
        }
    }

    protected void taskStatus(String status) {
        if (this.progressController != null) {
            this.progressController.setTaskStatus(status);
        }
    }

    protected boolean isStop() {
        if (this.progressController == null) {
            return false;
        }
        return this.progressController.isStop();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String BEGIN_WRITING = AbstractDataExportFileWriter.access$000().getString("AbstractDataExportFileWriter.beginWriting");
        public static final String KEY_NUMBER_OF_ROWS_COMPLETED_IN_SECONDS = "AbstractDataExportFileWriter.numberOfRowsCompletedInSeconds";
        public static final String KEY_FINISHED_LOADING = "AbstractDataExportFileWriter.finishedLoading";
        public static final String CLOSING_THE_FILE = AbstractDataExportFileWriter.access$000().getString("AbstractDataExportFileWriter.closingTheFile");
        public static final String DONE = AbstractDataExportFileWriter.access$000().getString("AbstractDataExportFileWriter.done");
    }
}

