/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.LineSeparator;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.AbstractDataExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;

public class DataExportCSVWriter
extends AbstractDataExportFileWriter {
    private List<String> headerCells = new ArrayList<String>();
    private List<String> aRow = new ArrayList<String>();
    private BufferedWriter bw;

    public DataExportCSVWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        super(file, prefs, progressController);
    }

    protected String getDataCSV(String sepChar, IExportDataCell cellObj, boolean useGlobalFormatting) {
        if (cellObj.getObject() == null) {
            return "";
        }
        String value = cellObj.getColumnDisplayDefinition() != null && useGlobalFormatting ? CellComponentFactory.renderObject(cellObj.getObject(), cellObj.getColumnDisplayDefinition()) : cellObj.getObject().toString();
        return DataExportCSVWriter.getDataCSV(sepChar, value);
    }

    public static String getDataCSV(String sepChar, String value) {
        if (value == null) {
            return "";
        }
        String ret = value.trim();
        if (0 <= ret.indexOf(sepChar) || 0 <= ret.indexOf(10) || 0 <= ret.indexOf(13) || 0 <= ret.indexOf(34)) {
            ret = "\"" + ret.replaceAll("\"", "\"\"") + "\"";
        }
        return ret;
    }

    @Override
    protected void afterWorking() throws Exception {
        this.bw.flush();
        this.bw.close();
    }

    @Override
    protected void addHeaderCell(int colIdx, String columnName) {
        this.headerCells.add(DataExportCSVWriter.getDataCSV(this.getSeperatorCharRespectTab(), columnName));
    }

    @Override
    protected void beforeWorking(File file) throws Exception {
        this.bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getCSVCharset()));
    }

    public Charset getCSVCharset() {
        try {
            return Charset.forName(this.getPrefs().getCsvEncoding());
        }
        catch (IllegalCharsetNameException icne) {
            return Charset.defaultCharset();
        }
    }

    @Override
    protected void addCell(IExportDataCell cell) {
        String cellObjData = this.getDataCSV(this.getSeperatorCharRespectTab(), cell, this.getPrefs().isUseGlobalPrefsFormating());
        this.aRow.add(cellObjData);
    }

    @Override
    protected void afterHeader() throws Exception {
        this.writeARow(this.headerCells);
        super.afterHeader();
    }

    @Override
    public void beforeRow(int rowIdx) throws Exception {
        super.beforeRow(rowIdx);
        this.aRow.clear();
    }

    @Override
    public void afterRow() throws Exception {
        this.writeARow(this.aRow);
        super.afterRow();
    }

    private void writeARow(List<String> data) throws IOException {
        Iterator<String> it = data.iterator();
        while (it.hasNext()) {
            this.bw.write(it.next());
            if (!it.hasNext()) continue;
            this.bw.write(this.getSeperatorCharRespectTab());
        }
        this.bw.write(LineSeparator.valueOf(this.getPrefs().getLineSeperator()).getSeparator());
    }

    private String getSeperatorCharRespectTab() {
        if (this.getPrefs().isSeperatorTab()) {
            return "\t";
        }
        return this.getPrefs().getSeperatorChar();
    }
}

