/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.AbstractDataExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;

public class DataExportJSONWriter
extends AbstractDataExportFileWriter {
    private ObjectMapper _mapper;
    private ObjectNode _root;
    private ObjectNode _tableNode;
    private ArrayNode _columns;
    private ArrayNode _rows;
    int _currentRowNumber = 0;
    private ObjectNode _currentRow;
    private ArrayNode _currentValues;

    public DataExportJSONWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        super(file, prefs, progressController);
    }

    @Override
    protected void beforeWorking(File file) {
        this._mapper = new ObjectMapper();
        this._root = this._mapper.createObjectNode();
        this._tableNode = this._mapper.createObjectNode();
        this._root.set("table", (JsonNode)this._tableNode);
        this._columns = this._mapper.createArrayNode();
        this._tableNode.set("columns", (JsonNode)this._columns);
    }

    @Override
    public void beforeRows() {
        this._rows = this._mapper.createArrayNode();
        this._tableNode.set("rows", (JsonNode)this._rows);
    }

    @Override
    public void beforeRow(int rowIdx) {
        this._currentRow = this._mapper.createObjectNode();
        this._rows.add((JsonNode)this._currentRow);
        this._currentRow.put("rowNumber", ++this._currentRowNumber);
        this._currentValues = this._mapper.createArrayNode();
        this._currentRow.set("values", (JsonNode)this._currentValues);
    }

    @Override
    protected void addCell(IExportDataCell cell) {
        ObjectNode objectNode = this._mapper.createObjectNode();
        String fieldName = "value";
        if (cell.getObject() != null) {
            if (cell.getObject() instanceof Integer) {
                objectNode.put(fieldName, (Integer)cell.getObject());
            } else if (cell.getObject() instanceof Double) {
                objectNode.put(fieldName, (Double)cell.getObject());
            } else if (cell.getObject() instanceof Float) {
                objectNode.put(fieldName, (Float)cell.getObject());
            } else if (cell.getObject() instanceof Short) {
                objectNode.put(fieldName, (Short)cell.getObject());
            } else if (cell.getObject() instanceof Boolean) {
                objectNode.put(fieldName, (Boolean)cell.getObject());
            } else if (cell.getObject() instanceof Byte) {
                objectNode.put(fieldName, (short)((Byte)cell.getObject()).byteValue());
            } else if (cell.getObject() instanceof Long) {
                objectNode.put(fieldName, (Long)cell.getObject());
            } else if (cell.getObject() instanceof BigDecimal) {
                objectNode.put(fieldName, (BigDecimal)cell.getObject());
            } else if (this.getPrefs().isUseGlobalPrefsFormating() && cell.getColumnDisplayDefinition() != null) {
                objectNode.put(fieldName, CellComponentFactory.renderObject(cell.getObject(), cell.getColumnDisplayDefinition()));
            } else {
                objectNode.put(fieldName, cell.getObject().toString());
            }
        } else {
            objectNode.put(fieldName, "<null>");
        }
        this._currentValues.add((JsonNode)objectNode);
    }

    @Override
    protected void addHeaderCell(int colIdx, String columnName) {
        this._columns.add((JsonNode)this._mapper.createObjectNode().put("name", columnName));
    }

    @Override
    protected void afterWorking() throws Exception {
        String jsonString = this._mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this._root);
        Files.write(this.getFile().toPath(), jsonString.getBytes(), new OpenOption[0]);
    }
}

